/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.FVDCodeBaseImpl;
import com.sun.corba.se.internal.io.IIOPInputStream;
import com.sun.corba.se.internal.io.IIOPOutputStream;
import com.sun.corba.se.internal.io.LibraryManager;
import com.sun.corba.se.internal.io.ObjectStreamClass;
import com.sun.corba.se.internal.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.internal.util.RepositoryId;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.SendingContext.CodeBase;
import com.sun.org.omg.SendingContext.CodeBaseHelper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.SendingContext.RunTime;

public class ValueHandlerImpl
implements ValueHandler {
    public static final short kRemoteType = 0;
    public static final short kAbstractType = 1;
    public static final short kValueType = 2;
    private Hashtable inputStreamPairs = null;
    private Hashtable outputStreamPairs = null;
    private CodeBase codeBase = null;
    private static boolean libraryManagerLoaded = false;
    private boolean useHashtables = true;
    private boolean isInputStream = true;
    private IIOPOutputStream outputStreamBridge = null;
    private IIOPInputStream inputStreamBridge = null;
    static Class class$java$lang$Object;
    static Class class$java$rmi$Remote;
    static Class class$org$omg$CORBA$Object;

    public ValueHandlerImpl() {
        if (!libraryManagerLoaded) {
            LibraryManager.load();
            libraryManagerLoaded = true;
        }
    }

    public ValueHandlerImpl(boolean bl2) {
        this();
        this.useHashtables = false;
        this.isInputStream = bl2;
    }

    private IIOPInputStream createInputStream() {
        return (IIOPInputStream)AccessController.doPrivileged(new StreamFactory(this.getInputStreamClassName()));
    }

    private IIOPOutputStream createOutputStream() {
        return (IIOPOutputStream)AccessController.doPrivileged(new StreamFactory(this.getOutputStreamClassName()));
    }

    public boolean isAbstractBase(Class clazz) {
        return RepositoryId.isAbstractBase(clazz);
    }

    public boolean isCustomMarshaled(Class clazz) {
        return ObjectStreamClass.lookup(clazz).isCustomMarshaled();
    }

    protected String getInputStreamClassName() {
        return "com.sun.corba.se.internal.io.IIOPInputStream";
    }

    protected String getOutputStreamClassName() {
        return "com.sun.corba.se.internal.io.IIOPOutputStream";
    }

    private boolean isArray(String string) {
        return RepositoryId.cache.getId(string).isSequence();
    }

    public boolean isSequence(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.isSequence();
    }

    protected TCKind getJavaCharTCKind() {
        return TCKind.tk_wchar;
    }

    protected void readCharArray(InputStream inputStream, char[] cArray, int n2, int n3) {
        inputStream.read_wchar_array(cArray, n2, n3);
    }

    protected void writeCharArray(OutputStream outputStream, char[] cArray, int n2, int n3) {
        outputStream.write_wchar_array(cArray, n2, n3);
    }

    public RunTime getRunTimeCodeBase() {
        if (this.codeBase != null) {
            return this.codeBase;
        }
        this.codeBase = new FVDCodeBaseImpl();
        FVDCodeBaseImpl fVDCodeBaseImpl = (FVDCodeBaseImpl)this.codeBase;
        fVDCodeBaseImpl.setValueHandler(this);
        return this.codeBase;
    }

    public Serializable writeReplace(Serializable serializable) {
        return ObjectStreamClass.lookup(serializable.getClass()).writeReplace(serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(org.omg.CORBA.portable.OutputStream outputStream, Serializable serializable) {
        block11: {
            OutputStream outputStream2 = (OutputStream)outputStream;
            if (!this.useHashtables) {
                if (this.outputStreamBridge == null) {
                    this.outputStreamBridge = this.createOutputStream();
                    this.outputStreamBridge.setOrbStream(outputStream2);
                }
                try {
                    this.outputStreamBridge.increaseRecursionDepth();
                    this.writeValueInternal(this.outputStreamBridge, outputStream2, serializable);
                }
                finally {
                    this.outputStreamBridge.decreaseRecursionDepth();
                }
                return;
            }
            IIOPOutputStream iIOPOutputStream = null;
            if (this.outputStreamPairs == null) {
                this.outputStreamPairs = new Hashtable();
            }
            if ((iIOPOutputStream = (IIOPOutputStream)this.outputStreamPairs.get(outputStream)) == null) {
                iIOPOutputStream = this.createOutputStream();
                iIOPOutputStream.setOrbStream(outputStream2);
                this.outputStreamPairs.put(outputStream, iIOPOutputStream);
            }
            try {
                iIOPOutputStream.increaseRecursionDepth();
                this.writeValueInternal(iIOPOutputStream, outputStream2, serializable);
                Object var6_6 = null;
                if (iIOPOutputStream.decreaseRecursionDepth() != 0) break block11;
                this.outputStreamPairs.remove(outputStream);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (iIOPOutputStream.decreaseRecursionDepth() == 0) {
                    this.outputStreamPairs.remove(outputStream);
                }
                throw throwable;
            }
            {
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Class getAnyClassFromType(String string) throws ClassNotFoundException {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getAnyClassFromType();
    }

    public Class getClassFromType(String string) throws ClassNotFoundException {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getClassFromType();
    }

    public String createForAnyType(Class clazz) {
        return RepositoryId.createForAnyType(clazz);
    }

    public String getRMIRepositoryID(Class clazz) {
        return RepositoryId.createForJavaType(clazz);
    }

    public boolean useFullValueDescription(Class clazz, String string) throws IOException {
        return RepositoryId.useFullValueDescription(clazz, string);
    }

    public String getClassName(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getClassName();
    }

    public String getDefinedInId(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getDefinedInId();
    }

    public String getSerialVersionUID(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getSerialVersionUID();
    }

    public String getUnqualifiedName(String string) {
        RepositoryId repositoryId = RepositoryId.cache.getId(string);
        return repositoryId.getUnqualifiedName();
    }

    private void writeValueInternal(IIOPOutputStream iIOPOutputStream, OutputStream outputStream, Serializable serializable) {
        Class clazz = serializable.getClass();
        if (clazz.isArray()) {
            this.write_Array(outputStream, serializable, clazz.getComponentType());
        } else {
            iIOPOutputStream.simpleWriteObject(serializable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write_Array(OutputStream outputStream, Serializable serializable, Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])serializable;
                int n2 = nArray.length;
                outputStream.write_ulong(n2);
                outputStream.write_long_array(nArray, 0, n2);
                return;
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])serializable;
                int n3 = byArray.length;
                outputStream.write_ulong(n3);
                outputStream.write_octet_array(byArray, 0, n3);
                return;
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])serializable;
                int n4 = lArray.length;
                outputStream.write_ulong(n4);
                outputStream.write_longlong_array(lArray, 0, n4);
                return;
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])serializable;
                int n5 = fArray.length;
                outputStream.write_ulong(n5);
                outputStream.write_float_array(fArray, 0, n5);
                return;
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])serializable;
                int n6 = dArray.length;
                outputStream.write_ulong(n6);
                outputStream.write_double_array(dArray, 0, n6);
                return;
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])serializable;
                int n7 = sArray.length;
                outputStream.write_ulong(n7);
                outputStream.write_short_array(sArray, 0, n7);
                return;
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])serializable;
                int n8 = cArray.length;
                outputStream.write_ulong(n8);
                this.writeCharArray(outputStream, cArray, 0, n8);
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new Error("Invalid primitive type : " + serializable.getClass().getName());
                boolean[] blArray = (boolean[])serializable;
                int n9 = blArray.length;
                outputStream.write_ulong(n9);
                outputStream.write_boolean_array(blArray, 0, n9);
            }
            return;
        } else if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = ValueHandlerImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
            Object[] objectArray = (Object[])serializable;
            int n10 = objectArray.length;
            outputStream.write_ulong(n10);
            for (int i2 = 0; i2 < n10; ++i2) {
                Util.writeAny(outputStream, objectArray[i2]);
            }
            return;
        } else {
            Object[] objectArray = (Object[])serializable;
            int n11 = objectArray.length;
            outputStream.write_ulong(n11);
            int n12 = 2;
            if (clazz.isInterface()) {
                String string = clazz.getName();
                if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueHandlerImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
                    n12 = 0;
                } else if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = ValueHandlerImpl.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz)) {
                    n12 = 0;
                } else if (RepositoryId.isAbstractBase(clazz)) {
                    n12 = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                    n12 = 1;
                }
            }
            block8: for (int i3 = 0; i3 < n11; ++i3) {
                switch (n12) {
                    case 0: {
                        Util.writeRemoteObject(outputStream, objectArray[i3]);
                        continue block8;
                    }
                    case 1: {
                        Util.writeAbstractObject(outputStream, objectArray[i3]);
                        continue block8;
                    }
                    case 2: {
                        try {
                            outputStream.write_value((Serializable)objectArray[i3]);
                            continue block8;
                        }
                        catch (ClassCastException classCastException) {
                            if (objectArray[i3] instanceof Serializable) {
                                throw classCastException;
                            }
                            Utility.throwNotSerializableForCorba(objectArray[i3].getClass().getName());
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable readValue(org.omg.CORBA.portable.InputStream inputStream, int n2, Class clazz, String string, RunTime runTime) {
        Serializable serializable;
        block12: {
            CodeBase codeBase = CodeBaseHelper.narrow(runTime);
            InputStream inputStream2 = (InputStream)inputStream;
            if (!this.useHashtables) {
                if (this.inputStreamBridge == null) {
                    this.inputStreamBridge = this.createInputStream();
                    this.inputStreamBridge.setOrbStream(inputStream2);
                    this.inputStreamBridge.setSender(codeBase);
                    this.inputStreamBridge.setValueHandler(this);
                }
                Serializable serializable2 = null;
                try {
                    this.inputStreamBridge.increaseRecursionDepth();
                    serializable2 = this.readValueInternal(this.inputStreamBridge, inputStream2, n2, clazz, string, codeBase);
                }
                finally {
                    if (this.inputStreamBridge.decreaseRecursionDepth() == 0) {
                        // empty if block
                    }
                }
                return serializable2;
            }
            IIOPInputStream iIOPInputStream = null;
            if (this.inputStreamPairs == null) {
                this.inputStreamPairs = new Hashtable();
            }
            if ((iIOPInputStream = (IIOPInputStream)this.inputStreamPairs.get(inputStream)) == null) {
                iIOPInputStream = this.createInputStream();
                iIOPInputStream.setOrbStream(inputStream2);
                iIOPInputStream.setSender(codeBase);
                iIOPInputStream.setValueHandler(this);
                this.inputStreamPairs.put(inputStream, iIOPInputStream);
            }
            serializable = null;
            try {
                iIOPInputStream.increaseRecursionDepth();
                serializable = this.readValueInternal(iIOPInputStream, inputStream2, n2, clazz, string, codeBase);
                Object var11_12 = null;
                if (iIOPInputStream.decreaseRecursionDepth() != 0) break block12;
                this.inputStreamPairs.remove(inputStream);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (iIOPInputStream.decreaseRecursionDepth() == 0) {
                    this.inputStreamPairs.remove(inputStream);
                }
                throw throwable;
            }
            {
            }
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object read_Array(IIOPInputStream iIOPInputStream, InputStream inputStream, Class clazz, CodeBase codeBase, int n2) {
        try {
            int n3 = inputStream.read_ulong();
            Class clazz2 = null;
            if (clazz == null) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    inputStream.read_value();
                }
                Object var9_11 = null;
                return var9_11;
            }
            clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz2 == Integer.TYPE) {
                    int[] nArray = new int[n3];
                    inputStream.read_long_array(nArray, 0, n3);
                    Serializable serializable = (Serializable)nArray;
                    return serializable;
                }
                if (clazz2 == Byte.TYPE) {
                    byte[] byArray = new byte[n3];
                    inputStream.read_octet_array(byArray, 0, n3);
                    Serializable serializable = (Serializable)byArray;
                    return serializable;
                }
                if (clazz2 == Long.TYPE) {
                    long[] lArray = new long[n3];
                    inputStream.read_longlong_array(lArray, 0, n3);
                    Serializable serializable = (Serializable)lArray;
                    return serializable;
                }
                if (clazz2 == Float.TYPE) {
                    float[] fArray = new float[n3];
                    inputStream.read_float_array(fArray, 0, n3);
                    Serializable serializable = (Serializable)fArray;
                    return serializable;
                }
                if (clazz2 == Double.TYPE) {
                    double[] dArray = new double[n3];
                    inputStream.read_double_array(dArray, 0, n3);
                    Serializable serializable = (Serializable)dArray;
                    return serializable;
                }
                if (clazz2 == Short.TYPE) {
                    short[] sArray = new short[n3];
                    inputStream.read_short_array(sArray, 0, n3);
                    Serializable serializable = (Serializable)sArray;
                    return serializable;
                }
                if (clazz2 == Character.TYPE) {
                    char[] cArray = new char[n3];
                    this.readCharArray(inputStream, cArray, 0, n3);
                    Serializable serializable = (Serializable)cArray;
                    return serializable;
                }
                if (clazz2 == Boolean.TYPE) {
                    boolean[] blArray = new boolean[n3];
                    inputStream.read_boolean_array(blArray, 0, n3);
                    Serializable serializable = (Serializable)blArray;
                    return serializable;
                }
                throw new Error("Invalid primitive type : " + clazz.getName());
            }
            if (clazz2 == (class$java$lang$Object == null ? (class$java$lang$Object = ValueHandlerImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
                Object object;
                Object[] objectArray = (Object[])Array.newInstance(clazz2, n3);
                iIOPInputStream.activeRecursionMgr.addObject(n2, objectArray);
                for (int i3 = 0; i3 < n3; ++i3) {
                    object = null;
                    try {
                        object = Util.readAny(inputStream);
                    }
                    catch (IndirectionException indirectionException) {
                        try {
                            object = iIOPInputStream.activeRecursionMgr.getObject(indirectionException.offset);
                        }
                        catch (IOException iOException) {
                            throw new MARSHAL("Invalid indirection to offset " + indirectionException.offset, 0x53550003, CompletionStatus.COMPLETED_NO);
                        }
                    }
                    objectArray[i3] = object;
                }
                object = (Serializable)objectArray;
                return object;
            }
            Object[] objectArray = (Object[])Array.newInstance(clazz2, n3);
            iIOPInputStream.activeRecursionMgr.addObject(n2, objectArray);
            int n4 = 2;
            boolean bl2 = false;
            if (clazz2.isInterface()) {
                boolean bl3 = false;
                if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = ValueHandlerImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz2)) {
                    n4 = 0;
                    bl3 = true;
                } else if ((class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = ValueHandlerImpl.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz2)) {
                    n4 = 0;
                    bl3 = true;
                } else if (RepositoryId.isAbstractBase(clazz2)) {
                    n4 = 1;
                    bl3 = true;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz2)) {
                    n4 = 1;
                }
                if (bl3) {
                    try {
                        String string = Util.getCodebase(clazz2);
                        String string2 = RepositoryId.createForAnyType(clazz2);
                        clazz2 = Utility.loadStubClass(string2, string, clazz2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
            }
            for (int i4 = 0; i4 < n3; ++i4) {
                try {
                    switch (n4) {
                        case 0: {
                            if (!bl2) {
                                objectArray[i4] = inputStream.read_Object(clazz2);
                                break;
                            }
                            objectArray[i4] = Utility.readObjectAndNarrow(inputStream, clazz2);
                            break;
                        }
                        case 1: {
                            if (!bl2) {
                                objectArray[i4] = inputStream.read_abstract_interface(clazz2);
                                break;
                            }
                            objectArray[i4] = Utility.readAbstractAndNarrow(inputStream, clazz2);
                            break;
                        }
                        case 2: {
                            objectArray[i4] = inputStream.read_value(clazz2);
                        }
                    }
                    continue;
                }
                catch (IndirectionException indirectionException) {
                    try {
                        objectArray[i4] = iIOPInputStream.activeRecursionMgr.getObject(indirectionException.offset);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new MARSHAL("Invalid indirection to offset " + indirectionException.offset, 0x53550003, CompletionStatus.COMPLETED_NO);
                    }
                }
            }
            Serializable serializable = (Serializable)objectArray;
            return serializable;
        }
        finally {
            iIOPInputStream.activeRecursionMgr.removeObject(n2);
        }
    }

    private Serializable readValueInternal(IIOPInputStream iIOPInputStream, InputStream inputStream, int n2, Class clazz, String string, CodeBase codeBase) {
        Serializable serializable = null;
        if (clazz == null) {
            if (this.isArray(string)) {
                this.read_Array(iIOPInputStream, inputStream, null, codeBase, n2);
            } else {
                iIOPInputStream.simpleSkipObject(string, codeBase);
            }
            return serializable;
        }
        serializable = clazz.isArray() ? (Serializable)this.read_Array(iIOPInputStream, inputStream, clazz, codeBase, n2) : (Serializable)iIOPInputStream.simpleReadObject(clazz, string, codeBase, n2);
        if (serializable != null) {
            // empty if block
        }
        return serializable;
    }

    private static final class StreamFactory
    implements PrivilegedAction {
        private String className;

        public Object run() {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                Class clazz = classLoader.loadClass(this.className);
                return clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new InternalError("Error loading " + this.className + ": " + throwable.getClass().getName() + ": " + throwable.getMessage());
            }
        }

        public StreamFactory(String string) {
            this.className = string;
        }
    }
}

