/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DHTMarkerSegment
extends MarkerSegment {
    List tables = new ArrayList();

    void print() {
        this.printTag("DHT");
        System.out.println("Num tables: " + Integer.toString(this.tables.size()));
        for (int i2 = 0; i2 < this.tables.size(); ++i2) {
            Htable htable = (Htable)this.tables.get(i2);
            htable.print();
        }
        System.out.println();
    }

    DHTMarkerSegment(boolean bl2) {
        super(196);
        this.tables.add(new Htable(this, JPEGHuffmanTable.StdDCLuminance, true, 0));
        if (bl2) {
            this.tables.add(new Htable(this, JPEGHuffmanTable.StdDCChrominance, true, 1));
        }
        this.tables.add(new Htable(this, JPEGHuffmanTable.StdACLuminance, false, 0));
        if (bl2) {
            this.tables.add(new Htable(this, JPEGHuffmanTable.StdACChrominance, false, 1));
        }
    }

    DHTMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        Htable htable;
        for (int i2 = this.length; i2 > 0; i2 -= 17 + htable.values.length) {
            htable = new Htable(this, jPEGBuffer);
            this.tables.add(htable);
        }
        jPEGBuffer.bufAvail -= this.length;
    }

    protected Object clone() {
        DHTMarkerSegment dHTMarkerSegment = (DHTMarkerSegment)super.clone();
        dHTMarkerSegment.tables = new ArrayList(this.tables.size());
        Iterator iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            Htable htable = (Htable)iterator.next();
            dHTMarkerSegment.tables.add(htable.clone());
        }
        return dHTMarkerSegment;
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dht");
        for (int i2 = 0; i2 < this.tables.size(); ++i2) {
            Htable htable = (Htable)this.tables.get(i2);
            iIOMetadataNode.appendChild(htable.getNativeNode());
        }
        return iIOMetadataNode;
    }

    void addHtable(JPEGHuffmanTable jPEGHuffmanTable, boolean bl2, int n2) {
        this.tables.add(new Htable(this, jPEGHuffmanTable, bl2, n2));
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    DHTMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(196);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        if (n2 < 1 || n2 > 4) {
            throw new IIOInvalidTreeException("Invalid DHT node", node);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tables.add(new Htable(this, nodeList.item(i2)));
        }
    }

    Htable getHtableFromNode(Node node) throws IIOInvalidTreeException {
        return new Htable(this, node);
    }

    DHTMarkerSegment(JPEGHuffmanTable[] jPEGHuffmanTableArray, JPEGHuffmanTable[] jPEGHuffmanTableArray2) {
        super(196);
        int n2;
        for (n2 = 0; n2 < jPEGHuffmanTableArray.length; ++n2) {
            this.tables.add(new Htable(this, jPEGHuffmanTableArray[n2], true, n2));
        }
        for (n2 = 0; n2 < jPEGHuffmanTableArray2.length; ++n2) {
            this.tables.add(new Htable(this, jPEGHuffmanTableArray2[n2], false, n2));
        }
    }

    class Htable
    implements Cloneable {
        int tableClass;
        int tableID;
        private static final int NUM_LENGTHS = 16;
        short[] numCodes;
        short[] values;
        private final DHTMarkerSegment this$0;

        void print() {
            System.out.println("Huffman Table");
            System.out.println("table class: " + (this.tableClass == 0 ? "DC" : "AC"));
            System.out.println("table id: " + Integer.toString(this.tableID));
            new JPEGHuffmanTable(this.numCodes, this.values).toString();
        }

        protected Object clone() {
            Htable htable = null;
            try {
                htable = (Htable)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (this.numCodes != null) {
                htable.numCodes = (short[])this.numCodes.clone();
            }
            if (this.values != null) {
                htable.values = (short[])this.values.clone();
            }
            return htable;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dhtable");
            iIOMetadataNode.setAttribute("class", Integer.toString(this.tableClass));
            iIOMetadataNode.setAttribute("htableId", Integer.toString(this.tableID));
            iIOMetadataNode.setUserObject(new JPEGHuffmanTable(this.numCodes, this.values));
            return iIOMetadataNode;
        }

        Htable(DHTMarkerSegment dHTMarkerSegment, JPEGBuffer jPEGBuffer) {
            int n2;
            int n3;
            this.this$0 = dHTMarkerSegment;
            this.numCodes = new short[16];
            this.tableClass = jPEGBuffer.buf[jPEGBuffer.bufPtr] >>> 4;
            this.tableID = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xF;
            for (n3 = 0; n3 < 16; ++n3) {
                this.numCodes[n3] = (short)(jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF);
            }
            n3 = 0;
            for (n2 = 0; n2 < 16; ++n2) {
                n3 += this.numCodes[n2];
            }
            this.values = new short[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.values[n2] = (short)(jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF);
            }
        }

        Htable(DHTMarkerSegment dHTMarkerSegment, JPEGHuffmanTable jPEGHuffmanTable, boolean bl2, int n2) {
            this.this$0 = dHTMarkerSegment;
            this.numCodes = new short[16];
            this.tableClass = bl2 ? 0 : 1;
            this.tableID = n2;
            this.numCodes = jPEGHuffmanTable.getLengths();
            this.values = jPEGHuffmanTable.getValues();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Htable(DHTMarkerSegment dHTMarkerSegment, Node node) throws IIOInvalidTreeException {
            this.this$0 = dHTMarkerSegment;
            this.numCodes = new short[16];
            if (!node.getNodeName().equals("dhtable")) throw new IIOInvalidTreeException("Invalid node, expected dqtable", node);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n2 = namedNodeMap.getLength();
            if (n2 != 2) {
                throw new IIOInvalidTreeException("dhtable node must have 2 attributes", node);
            }
            this.tableClass = MarkerSegment.getAttributeValue(node, namedNodeMap, "class", 0, 1, true);
            this.tableID = MarkerSegment.getAttributeValue(node, namedNodeMap, "htableId", 0, 3, true);
            if (!(node instanceof IIOMetadataNode)) throw new IIOInvalidTreeException("dhtable node must have user object", node);
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
            JPEGHuffmanTable jPEGHuffmanTable = (JPEGHuffmanTable)iIOMetadataNode.getUserObject();
            if (jPEGHuffmanTable == null) {
                throw new IIOInvalidTreeException("dhtable node must have user object", node);
            }
            this.numCodes = jPEGHuffmanTable.getLengths();
            this.values = jPEGHuffmanTable.getValues();
        }
    }
}

