/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicMenuBarUI
extends MenuBarUI {
    protected JMenuBar menuBar = null;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;
    private PropertyChangeListener propertyChangeListener;

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 2));
        }
        this.menuBar.setOpaque(true);
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuBar, actionMap);
    }

    protected void installListeners() {
        this.containerListener = this.createContainerListener();
        this.changeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        for (int i2 = 0; i2 < this.menuBar.getMenuCount(); ++i2) {
            JMenu jMenu = this.menuBar.getMenu(i2);
            if (jMenu == null) continue;
            jMenu.getModel().addChangeListener(this.changeListener);
        }
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
        if (this.menuBar != null) {
            LookAndFeel.uninstallBorder(this.menuBar);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, null);
        SwingUtilities.replaceUIActionMap(this.menuBar, null);
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        for (int i2 = 0; i2 < this.menuBar.getMenuCount(); ++i2) {
            JMenu jMenu = this.menuBar.getMenu(i2);
            if (jMenu == null) continue;
            jMenu.getModel().removeChangeListener(this.changeListener);
        }
        this.containerListener = null;
        this.changeListener = null;
        this.propertyChangeListener = null;
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler(this, null);
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this, null);
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("takeFocus", new TakeFocus());
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("MenuBar.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("MenuBar.actionMap", actionMap);
        }
        return actionMap;
    }

    InputMap getInputMap(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])UIManager.get("MenuBar.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.menuBar, objectArray);
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.menuBar = (JMenuBar)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    protected ChangeListener createChangeListener() {
        return new ChangeHandler(this, null);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuBarUI();
    }

    static class 1 {
    }

    private class ChangeHandler
    implements ChangeListener {
        private final BasicMenuBarUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            int n2 = this.this$0.menuBar.getMenuCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                JMenu jMenu = this.this$0.menuBar.getMenu(i2);
                if (jMenu == null || !jMenu.isSelected()) continue;
                this.this$0.menuBar.getSelectionModel().setSelectedIndex(i2);
                break;
            }
        }

        private ChangeHandler(BasicMenuBarUI basicMenuBarUI) {
            this.this$0 = basicMenuBarUI;
        }

        ChangeHandler(BasicMenuBarUI basicMenuBarUI, 1 var2_2) {
            this(basicMenuBarUI);
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private final BasicMenuBarUI this$0;

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().addChangeListener(this.this$0.changeListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().removeChangeListener(this.this$0.changeListener);
            }
        }

        private ContainerHandler(BasicMenuBarUI basicMenuBarUI) {
            this.this$0 = basicMenuBarUI;
        }

        ContainerHandler(BasicMenuBarUI basicMenuBarUI, 1 var2_2) {
            this(basicMenuBarUI);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private final BasicMenuBarUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation") && this.this$0.menuBar.getLayout() instanceof UIResource) {
                this.this$0.menuBar.setLayout(new DefaultMenuLayout(this.this$0.menuBar, 2));
            }
        }

        private PropertyChangeHandler(BasicMenuBarUI basicMenuBarUI) {
            this.this$0 = basicMenuBarUI;
        }

        PropertyChangeHandler(BasicMenuBarUI basicMenuBarUI, 1 var2_2) {
            this(basicMenuBarUI);
        }
    }

    private static class TakeFocus
    extends AbstractAction {
        TakeFocus() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }
    }
}

