/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;

public class OutputProperties
extends ElemTemplateElement
implements Cloneable {
    static final String S_XSLT_PREFIX = "xslt.output.";
    static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    static final String S_XALAN_PREFIX = "org.apache.xslt.";
    static final int S_XALAN_PREFIX_LEN = "org.apache.xslt.".length();
    static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xalan}";
    static final String S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    static final int S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN = "{http://xml.apache.org/xslt}".length();
    private transient Hashtable m_propertiesLevels;
    private Properties m_properties = null;
    public static final String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    public static final String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xalan}content-handler";
    public static final String S_KEY_ENTITIES = "{http://xml.apache.org/xalan}entities";
    public static final String S_USE_URL_ESCAPING = "{http://xml.apache.org/xalan}use-url-escaping";
    public static final String S_OMIT_META_TAG = "{http://xml.apache.org/xalan}omit-meta-tag";
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private static Integer m_synch_object = new Integer(1);
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJS = new Object[0];
    static Class class$java$lang$Thread;
    static Class class$org$apache$xalan$templates$OutputProperties;

    public OutputProperties() {
        this("xml");
    }

    static Class[] access$000() {
        return NO_CLASSES;
    }

    public Object clone() {
        try {
            OutputProperties outputProperties = (OutputProperties)super.clone();
            outputProperties.m_properties = (Properties)outputProperties.m_properties.clone();
            return outputProperties;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static Object[] access$100() {
        return NO_OBJS;
    }

    public int getIntProperty(String string) {
        return OutputProperties.getIntProperty(string, this.m_properties);
    }

    public OutputProperties(String string) {
        this.m_properties = new Properties(OutputProperties.getDefaultMethodProperties(string));
    }

    public void setMethodDefaults(String string) {
        String string2 = this.m_properties.getProperty("method");
        if (null == string2 || !string2.equals(string)) {
            Properties properties = this.m_properties;
            Properties properties2 = OutputProperties.getDefaultMethodProperties(string);
            this.m_properties = new Properties(properties2);
            this.copyFrom(properties, false);
        }
    }

    public boolean getBooleanProperty(String string) {
        return OutputProperties.getBooleanProperty(string, this.m_properties);
    }

    public boolean isLegalPropertyKey(String string) {
        return string.equals("cdata-section-elements") || string.equals("doctype-public") || string.equals("doctype-system") || string.equals("encoding") || string.equals("indent") || string.equals("media-type") || string.equals("method") || string.equals("omit-xml-declaration") || string.equals("standalone") || string.equals("version") || string.length() > 0 && string.charAt(0) == '{';
    }

    public void setIntProperty(String string, int n2) {
        this.m_properties.put(string, Integer.toString(n2));
    }

    public void setBooleanProperty(String string, boolean bl2) {
        this.m_properties.put(string, bl2 ? "yes" : "no");
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public OutputProperties(Properties properties) {
        this.m_properties = new Properties(properties);
    }

    public void copyFrom(Properties properties) {
        this.copyFrom(properties, true);
    }

    public void copyFrom(Properties properties, boolean bl2) {
        Enumeration enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isLegalPropertyKey(string)) {
                throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{string}));
            }
            Object object = this.m_properties.get(string);
            if (null == object) {
                String string2 = (String)properties.get(string);
                if (bl2 && string.equals("method")) {
                    this.setMethodDefaults(string2);
                }
                this.m_properties.put(string, string2);
                continue;
            }
            if (!string.equals("cdata-section-elements")) continue;
            this.m_properties.put(string, (String)object + " " + (String)properties.get(string));
        }
    }

    private void checkDuplicates(OutputProperties outputProperties) throws TransformerException {
        if (null == this.m_propertiesLevels) {
            this.m_propertiesLevels = new Hashtable();
        }
        int n2 = outputProperties.getStylesheetComposed().getImportCountComposed();
        Properties properties = outputProperties.getProperties();
        Enumeration enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("cdata-section-elements")) continue;
            Integer n3 = (Integer)this.m_propertiesLevels.get(string);
            if (null == n3) {
                this.m_propertiesLevels.put(string, new Integer(n2));
                continue;
            }
            if (n2 < n3) continue;
            String string2 = (String)this.m_properties.get(string);
            String string3 = (String)outputProperties.m_properties.get(string);
            if ((string2 != null || string3 == null) && string2.equals(string3)) continue;
            String string4 = string + " can not be multiply defined at the same " + "import level! Old value = " + string2 + "; New value = " + string3;
            throw new TransformerException(string4, outputProperties);
        }
    }

    public void copyFrom(OutputProperties outputProperties) throws TransformerException {
        this.checkDuplicates(outputProperties);
        this.copyFrom(outputProperties.getProperties());
    }

    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        super.compose(stylesheetRoot);
        this.m_propertiesLevels = null;
    }

    public void recompose(StylesheetRoot stylesheetRoot) throws TransformerException {
        stylesheetRoot.recomposeOutput(this);
    }

    public int getIntProperty(QName qName) {
        return this.getIntProperty(qName.toNamespacedString());
    }

    public boolean getBooleanProperty(QName qName) {
        return this.getBooleanProperty(qName.toNamespacedString());
    }

    public void setIntProperty(QName qName, int n2) {
        this.setIntProperty(qName.toNamespacedString(), n2);
    }

    public void setBooleanProperty(QName qName, boolean bl2) {
        this.m_properties.put(qName.toNamespacedString(), bl2 ? "yes" : "no");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public String getProperty(String string) {
        if (string.startsWith(S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL)) {
            string = S_BUILTIN_EXTENSIONS_UNIVERSAL + string.substring(S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN);
        }
        return this.m_properties.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        if (string.equals("method")) {
            this.setMethodDefaults(string2);
        }
        if (string.startsWith(S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL)) {
            string = S_BUILTIN_EXTENSIONS_UNIVERSAL + string.substring(S_BUILTIN_OLD_EXTENSIONS_UNIVERSAL_LEN);
        }
        this.m_properties.put(string, string2);
    }

    private static String fixupPropertyString(String string, boolean bl2) {
        int n2;
        if (bl2 && string.startsWith(S_XSLT_PREFIX)) {
            string = string.substring(S_XSLT_PREFIX_LEN);
        }
        if (string.startsWith(S_XALAN_PREFIX)) {
            string = S_BUILTIN_EXTENSIONS_UNIVERSAL + string.substring(S_XALAN_PREFIX_LEN);
        }
        if ((n2 = string.indexOf("\\u003a")) > 0) {
            String string2 = string.substring(n2 + 6);
            string = string.substring(0, n2) + ":" + string2;
        }
        return string;
    }

    public String getProperty(QName qName) {
        return this.m_properties.getProperty(qName.toNamespacedString());
    }

    public void setProperty(QName qName, String string) {
        this.setProperty(qName.toNamespacedString(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getDefaultMethodProperties(String string) {
        String string2 = null;
        Properties properties = null;
        try {
            Object object = m_synch_object;
            synchronized (object) {
                if (null == m_xml_properties) {
                    string2 = "output_xml.properties";
                    m_xml_properties = OutputProperties.loadPropertiesFile(string2, null);
                }
            }
            if (string.equals("xml")) {
                properties = m_xml_properties;
            } else if (string.equals("html")) {
                if (null == m_html_properties) {
                    string2 = "output_html.properties";
                    m_html_properties = OutputProperties.loadPropertiesFile(string2, m_xml_properties);
                }
                properties = m_html_properties;
            } else if (string.equals("text")) {
                if (null == m_text_properties && null == (m_text_properties = OutputProperties.loadPropertiesFile(string2 = "output_text.properties", m_xml_properties)).getProperty("encoding")) {
                    object = Encodings.getMimeEncoding(null);
                    m_text_properties.put("encoding", object);
                }
                properties = m_text_properties;
            } else {
                properties = m_xml_properties;
            }
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException("Output method is " + string + " could not load " + string2 + " (check CLASSPATH)", iOException);
        }
        return properties;
    }

    public static int getIntProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (null == string2) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    public static boolean getBooleanProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        return null != string2 && string2.equals("yes");
    }

    public Vector getQNameProperties(String string) {
        return OutputProperties.getQNameProperties(string, this.m_properties);
    }

    public void setQNameProperties(String string, Vector vector) {
        int n2 = vector.size();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(9, 9);
        for (int i2 = 0; i2 < n2; ++i2) {
            QName qName = (QName)vector.elementAt(i2);
            fastStringBuffer.append(qName.toNamespacedString());
            if (i2 >= n2 - 1) continue;
            fastStringBuffer.append(' ');
        }
        this.m_properties.put(string, fastStringBuffer.toString());
    }

    public Vector getQNameProperties(QName qName) {
        return this.getQNameProperties(qName.toNamespacedString());
    }

    public void setQNameProperties(QName qName, Vector vector) {
        this.setQNameProperties(qName.toNamespacedString(), vector);
    }

    public QName getQNameProperty(String string) {
        return OutputProperties.getQNameProperty(string, this.m_properties);
    }

    public void setQNameProperty(String string, QName qName) {
        this.setProperty(string, qName.toNamespacedString());
    }

    public QName getQNameProperty(QName qName) {
        return this.getQNameProperty(qName.toNamespacedString());
    }

    public void setQNameProperty(QName qName, QName qName2) {
        this.setQNameProperty(qName.toNamespacedString(), qName2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadPropertiesFile(String string, Properties properties) throws IOException {
        String string2;
        InputStream inputStream;
        Properties properties2;
        block20: {
            properties2 = new Properties(properties);
            inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    try {
                        inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(string){
                            private final String val$resourceName;

                            public Object run() {
                                try {
                                    Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = OutputProperties.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", OutputProperties.access$000());
                                    if (method != null) {
                                        ClassLoader classLoader = (ClassLoader)method.invoke(Thread.currentThread(), OutputProperties.access$100());
                                        return classLoader.getResourceAsStream("org/apache/xalan/templates/" + this.val$resourceName);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return null;
                            }
                            {
                                this.val$resourceName = string;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (inputStream == null) {
                        inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(string){
                            private final String val$resourceName;

                            public Object run() {
                                return (class$org$apache$xalan$templates$OutputProperties == null ? (class$org$apache$xalan$templates$OutputProperties = OutputProperties.class$("org.apache.xalan.templates.OutputProperties")) : class$org$apache$xalan$templates$OutputProperties).getResourceAsStream(this.val$resourceName);
                            }
                            {
                                this.val$resourceName = string;
                            }
                        });
                    }
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    properties2.load(bufferedInputStream);
                }
                catch (IOException iOException) {
                    if (properties == null) {
                        throw iOException;
                    }
                    throw new WrappedRuntimeException(XSLMessages.createMessage("ER_COULD_NOT_LOAD_RESOURCE", new Object[]{string}), iOException);
                }
                catch (SecurityException securityException) {
                    if (properties == null) {
                        throw securityException;
                    }
                    throw new WrappedRuntimeException(XSLMessages.createMessage("ER_COULD_NOT_LOAD_RESOURCE", new Object[]{string}), securityException);
                }
                string2 = null;
                if (bufferedInputStream == null) break block20;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            bufferedInputStream.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        Enumeration enumeration = ((Properties)properties2.clone()).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            string2 = null;
            try {
                string2 = System.getProperty(string3);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string2 == null) {
                string2 = (String)properties2.get(string3);
            }
            String string4 = OutputProperties.fixupPropertyString(string3, true);
            String string5 = null;
            try {
                string5 = System.getProperty(string4);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string5 = string5 == null ? OutputProperties.fixupPropertyString(string2, false) : OutputProperties.fixupPropertyString(string5, false);
            if (string3 == string4 && string2 == string5) continue;
            properties2.remove(string3);
            properties2.put(string4, string5);
        }
        return properties2;
    }

    public static Vector getQNameProperties(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (null != string2) {
            Vector vector = new Vector();
            int n2 = string2.length();
            boolean bl2 = false;
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string2.charAt(i2);
                if (Character.isWhitespace(c2)) {
                    if (!bl2) {
                        if (fastStringBuffer.length() <= 0) continue;
                        QName qName = QName.getQNameFromString(fastStringBuffer.toString());
                        vector.addElement(qName);
                        fastStringBuffer.reset();
                        continue;
                    }
                } else if ('{' == c2) {
                    bl2 = true;
                } else if ('}' == c2) {
                    bl2 = false;
                }
                fastStringBuffer.append(c2);
            }
            if (fastStringBuffer.length() > 0) {
                QName qName = QName.getQNameFromString(fastStringBuffer.toString());
                vector.addElement(qName);
                fastStringBuffer.reset();
            }
            return vector;
        }
        return null;
    }

    public static QName getQNameProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (null != string2) {
            return QName.getQNameFromString(string2);
        }
        return null;
    }
}

