/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;

public class Gregorian
implements CalendarSystem {
    public static final int EPOCH_DATE = 719163;
    private static final int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static final boolean isLeapYear(int n2) {
        if (n2 >= 0) {
            return n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
        }
        return Gregorian.mod(n2, 4) == 0 && (Gregorian.mod(n2, 100) != 0 || Gregorian.mod(n2, 400) == 0);
    }

    private static final int floorDivide(int n2, int n3) {
        return n2 >= 0 ? n2 / n3 : (n2 + 1) / n3 - 1;
    }

    public static int getMonthLength(int n2, int n3) {
        int n4 = days_in_month[n3];
        if (n3 == 1 && Gregorian.isLeapYear(n2)) {
            ++n4;
        }
        return n4;
    }

    private static final int mod(int n2, int n3) {
        return n2 - n3 * Gregorian.floorDivide(n2, n3);
    }

    public static final long getFixedDate(int n2, int n3, int n4) {
        int n5 = n2 - 1;
        long l2 = n5 >= 0 ? 365L * (long)n5 + (long)(n5 / 4) - (long)(n5 / 100) + (long)(n5 / 400) + (long)((367 * n3 - 362) / 12) + (long)n4 : 365L * (long)n5 + (long)Gregorian.floorDivide(n5, 4) - (long)Gregorian.floorDivide(n5, 100) + (long)Gregorian.floorDivide(n5, 400) + (long)Gregorian.floorDivide(367 * ++n3 - 362, 12) + (long)n4;
        if (n3 > 2) {
            l2 -= Gregorian.isLeapYear(n2) ? 1L : 2L;
        }
        return l2;
    }

    public static long dateToMillis(int n2, int n3, int n4, int n5) {
        long l2 = Gregorian.getFixedDate(n2, n3, n4);
        return (l2 - 719163L) * 86400000L + (long)n5;
    }

    private static final int getDayOfWeekFromFixedDate(long l2) {
        if (l2 >= 0L) {
            return (int)(l2 % 7L) + 1;
        }
        return (int)Gregorian.mod(l2, 7L) + 1;
    }

    private static final int getYear(long l2) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (l2 >= 0L) {
            long l3 = l2 - 1L;
            n5 = (int)(l3 / 146097L);
            int n6 = (int)(l3 % 146097L);
            n4 = n6 / 36524;
            int n7 = n6 % 36524;
            n3 = n7 / 1461;
            int n8 = n7 % 1461;
            n2 = n8 / 365;
            int n9 = n8 % 365 + 1;
        } else {
            long l4 = l2 - 1L;
            n5 = (int)Gregorian.floorDivide(l4, 146097L);
            int n10 = (int)Gregorian.mod(l4, 146097L);
            n4 = Gregorian.floorDivide(n10, 36524);
            int n11 = Gregorian.mod(n10, 36524);
            n3 = Gregorian.floorDivide(n11, 1461);
            int n12 = Gregorian.mod(n11, 1461);
            n2 = Gregorian.floorDivide(n12, 365);
            int n13 = Gregorian.mod(n12, 365) + 1;
        }
        int n14 = 400 * n5 + 100 * n4 + 4 * n3 + n2;
        if (n4 != 4 && n2 != 4) {
            ++n14;
        }
        return n14;
    }

    private static final long floorDivide(long l2, long l3) {
        return l2 >= 0L ? l2 / l3 : (l2 + 1L) / l3 - 1L;
    }

    private static final long mod(long l2, long l3) {
        return l2 - l3 * Gregorian.floorDivide(l2, l3);
    }

    public static CalendarDate getCalendarDate(long l2) {
        long l3 = l2 / 86400000L;
        int n2 = (int)(l2 % 86400000L);
        if (n2 < 0) {
            n2 += 86400000;
            --l3;
        }
        CalendarDate calendarDate = Gregorian.getCalendarDateFromFixedDate(l3 += 719163L);
        calendarDate.setTimeOfDay(n2);
        return calendarDate;
    }

    public static CalendarDate getCalendarDateFromFixedDate(long l2) {
        int n2 = Gregorian.getYear(l2);
        int n3 = (int)(l2 - Gregorian.getFixedDate(n2, 0, 1));
        int n4 = 2;
        long l3 = Gregorian.getFixedDate(n2, 2, 1);
        if (l2 < l3) {
            n4 = 0;
        } else if (l2 >= l3 && Gregorian.isLeapYear(n2)) {
            n4 = 1;
        }
        int n5 = Gregorian.floorDivide(12 * (n3 + n4) + 373, 367) - 1;
        int n6 = (int)(l2 - Gregorian.getFixedDate(n2, n5, 1) + 1L);
        int n7 = Gregorian.getDayOfWeekFromFixedDate(l2);
        CalendarDate calendarDate = new CalendarDate(n2, n5, n6);
        calendarDate.setDayOfWeek(n7);
        return calendarDate;
    }

    public static int getDayOfWeek(CalendarDate calendarDate) {
        long l2 = Gregorian.getFixedDate(calendarDate.getYear(), calendarDate.getMonth(), calendarDate.getDate());
        return Gregorian.getDayOfWeekFromFixedDate(l2);
    }

    public static long dateToMillis(CalendarDate calendarDate) {
        long l2 = Gregorian.getFixedDate(calendarDate.getYear(), calendarDate.getMonth(), calendarDate.getDate());
        return (l2 - 719163L) * 86400000L + (long)calendarDate.getTimeOfDay();
    }

    public static boolean validate(CalendarDate calendarDate) {
        int n2 = calendarDate.getMonth();
        if (n2 < 0 || n2 > 11) {
            return false;
        }
        int n3 = Gregorian.getMonthLength(calendarDate.getYear(), n2);
        return calendarDate.getDate() > 0 && calendarDate.getDate() <= n3;
    }
}

