/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.ssh;

import com.isnetworks.ssh.FileBrowser;
import com.isnetworks.ssh.FileList;
import com.isnetworks.ssh.FileListItem;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.sshcommon.SSHFileTransferDialog;
import com.mindbright.util.ArraySort;
import com.mindbright.util.StringUtil;
import com.mindbright.util.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class FileDisplay
extends Panel {
    public static final int BUT_CHDIR = 0;
    public static final int BUT_MKDIR = 1;
    public static final int BUT_RENAME = 2;
    public static final int BUT_DELETE = 3;
    public static final int BUT_REFRESH = 4;
    public static final int ACT_DBLCLICK = 5;
    private FileBrowser mBrowser;
    private Button mChgDirButton;
    private Button mDeleteButton;
    private Panel mFileButtonsInnerPanel;
    private Panel mFileButtonsPanel;
    private Panel mFileHeaderPanel;
    private FileList mFileList;
    private Label mMachineDescriptionLabel;
    private String mMachineDescriptionText;
    private Label mFileSystemLocationLabel;
    private Button mMkDirButton;
    private Button mRefreshButton;
    private Button mRenameButton;
    private Frame mOwnerFrame;
    private SSHFileTransferDialog mFileXferDialog;

    public FileDisplay(Frame frame, String string, SSHFileTransferDialog sSHFileTransferDialog) {
        this.mOwnerFrame = frame;
        this.mFileXferDialog = sSHFileTransferDialog;
        this.mMachineDescriptionLabel = new Label(string);
        this.mMachineDescriptionText = string;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.add("North", this.getFileHeaderPanel());
        this.add("Center", this.getFileList());
        this.add("South", this.getFileButtonsPanel());
    }

    private Panel getFileHeaderPanel() {
        if (this.mFileHeaderPanel == null) {
            this.mFileHeaderPanel = new Panel(new BorderLayout());
            this.mFileHeaderPanel.add("North", this.getMachineDescriptionLabel());
            this.mFileHeaderPanel.add("South", this.getFileSystemLocationLabel());
        }
        return this.mFileHeaderPanel;
    }

    private Label getMachineDescriptionLabel() {
        return this.mMachineDescriptionLabel;
    }

    private Label getFileSystemLocationLabel() {
        if (this.mFileSystemLocationLabel == null) {
            this.mFileSystemLocationLabel = new Label("");
        }
        return this.mFileSystemLocationLabel;
    }

    private Panel getFileButtonsPanel() {
        if (this.mFileButtonsPanel == null) {
            this.mFileButtonsPanel = new Panel(new BorderLayout());
            this.mFileButtonsPanel.add("North", this.getFileButtonsInnerPanel());
        }
        return this.mFileButtonsPanel;
    }

    private Panel getFileButtonsInnerPanel() {
        if (this.mFileButtonsInnerPanel == null) {
            this.mFileButtonsInnerPanel = new Panel(new GridLayout(1, 5));
            this.mFileButtonsInnerPanel.add(this.getChgDirButton());
            this.mFileButtonsInnerPanel.add(this.getMkDirButton());
            this.mFileButtonsInnerPanel.add(this.getRenameButton());
            this.mFileButtonsInnerPanel.add(this.getDeleteButton());
            this.mFileButtonsInnerPanel.add(this.getRefreshButton());
        }
        return this.mFileButtonsInnerPanel;
    }

    private Button getChgDirButton() {
        if (this.mChgDirButton == null) {
            this.mChgDirButton = new Button("ChgDir");
            this.mChgDirButton.addActionListener(new Actions(0));
        }
        return this.mChgDirButton;
    }

    private Button getMkDirButton() {
        if (this.mMkDirButton == null) {
            this.mMkDirButton = new Button("MkDir");
            this.mMkDirButton.addActionListener(new Actions(1));
        }
        return this.mMkDirButton;
    }

    private Button getRenameButton() {
        if (this.mRenameButton == null) {
            this.mRenameButton = new Button("Rename");
            this.mRenameButton.addActionListener(new Actions(2));
        }
        return this.mRenameButton;
    }

    private Button getDeleteButton() {
        if (this.mDeleteButton == null) {
            this.mDeleteButton = new Button("Delete");
            this.mDeleteButton.addActionListener(new Actions(3));
        }
        return this.mDeleteButton;
    }

    private Button getRefreshButton() {
        if (this.mRefreshButton == null) {
            this.mRefreshButton = new Button("Refresh");
            this.mRefreshButton.addActionListener(new Actions(4));
        }
        return this.mRefreshButton;
    }

    private FileList getFileList() {
        if (this.mFileList == null) {
            this.mFileList = new FileList();
            this.mFileList.setMultipleMode(true);
            this.mFileList.addActionListener(new Actions(5));
            this.mFileList.addItemListener(new Actions(-1));
            this.mFileList.setBackground(Color.white);
        }
        return this.mFileList;
    }

    private void enableButtons() {
        this.mRenameButton.setEnabled(this.mFileList.getSelectionCount() == 1);
        this.mDeleteButton.setEnabled(this.mFileList.getSelectionCount() > 0);
    }

    public String getFileSystemLocationLabelText() {
        return this.getFileSystemLocationLabel().getText();
    }

    public void setFileSystemLocationLabelText(String string) {
        this.getFileSystemLocationLabel().setText(string);
    }

    public void setFileList(Vector vector, Vector vector2, String string, String string2) {
        Object object;
        int n;
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        this.setFileSystemLocationLabelText(string);
        int n2 = vector.size();
        int n3 = vector2.size();
        long l = 0L;
        ArraySort.Comparable[] comparableArray = new FileListItem[n2 + n3];
        for (n = 0; n < n2; ++n) {
            comparableArray[n] = (FileListItem)vector.elementAt(n);
        }
        for (n = 0; n < n3; ++n) {
            comparableArray[n + n2] = object = (FileListItem)vector2.elementAt(n);
            l += ((FileListItem)object).getSize();
        }
        object = "";
        if (l > 0L) {
            object = " (" + StringUtil.nBytesToString(l, 4) + ")";
        }
        this.getMachineDescriptionLabel().setText(this.mMachineDescriptionText + " : " + n3 + " file" + (n3 > 1 ? "s" : "") + (String)object);
        ArraySort.sort(comparableArray, 0, n2);
        ArraySort.sort(comparableArray, n2, n2 + n3);
        vector.setSize(0);
        vector2.setSize(0);
        this.mFileList.setListItems((FileListItem[])comparableArray);
        this.enableButtons();
    }

    public void setFileBrowser(FileBrowser fileBrowser) {
        this.mBrowser = fileBrowser;
    }

    public FileListItem getSelectedFile() {
        return this.mFileList.getSelectedFileListItem();
    }

    public FileListItem[] getSelectedFiles() {
        return this.mFileList.getSelectedFileListItems();
    }

    private class Actions
    implements ActionListener,
    ItemListener {
        private int action;

        public Actions(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Util.isNetscapeJava()) {
                try {
                    PrivilegeManager.enablePrivilege("UniversalFileAccess");
                }
                catch (ForbiddenTargetException forbiddenTargetException) {
                    // empty catch block
                }
            }
            try {
                switch (this.action) {
                    case 0: {
                        String string = SSHMiscDialogs.textInput("Change directory", "Directory", FileDisplay.this.mOwnerFrame, FileDisplay.this.getFileSystemLocationLabelText());
                        if (string == null) break;
                        FileDisplay.this.mBrowser.changeDirectory(string);
                        break;
                    }
                    case 1: {
                        String string = SSHMiscDialogs.textInput("Make directory relative to current path", "Directory name", FileDisplay.this.mOwnerFrame);
                        if (string == null) break;
                        FileDisplay.this.mBrowser.makeDirectory(string);
                        break;
                    }
                    case 2: {
                        FileListItem fileListItem = FileDisplay.this.getSelectedFile();
                        String string = SSHMiscDialogs.textInput("Rename file", "New file name", FileDisplay.this.mOwnerFrame, fileListItem.getName());
                        if (string == null) break;
                        FileDisplay.this.mBrowser.rename(fileListItem, string);
                        break;
                    }
                    case 3: {
                        FileDisplay.this.mBrowser.delete(FileDisplay.this.getSelectedFiles());
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        String string = actionEvent.getActionCommand();
                        FileListItem fileListItem = FileDisplay.this.mFileList.getFileListItem(string);
                        if (fileListItem == null) break;
                        FileDisplay.this.mBrowser.fileDoubleClicked(fileListItem);
                    }
                }
                FileDisplay.this.mBrowser.refresh();
            }
            catch (Exception exception) {
                FileDisplay.this.mFileXferDialog.logError(exception);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            FileDisplay.this.enableButtons();
        }
    }
}

