/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.ssh;

import com.isnetworks.ssh.FileListItem;
import com.mindbright.util.StringUtil;
import java.awt.List;

public class FileList
extends List {
    private FileListItem[] mListItems;

    public void setListItems(FileListItem[] fileListItemArray) {
        this.removeAll();
        this.mListItems = fileListItemArray;
        for (int i = 0; i < fileListItemArray.length; ++i) {
            FileListItem fileListItem = fileListItemArray[i];
            if (fileListItem.isDirectory()) {
                this.add("[" + fileListItem.getName() + "]");
                continue;
            }
            long l = fileListItem.getSize();
            this.add(fileListItem.getName() + (l >= 0L ? " (" + StringUtil.nBytesToString(l, 4) + ")" : ""));
        }
    }

    public FileListItem getSelectedFileListItem() {
        FileListItem fileListItem = null;
        if (this.getSelectedIndex() != -1) {
            fileListItem = this.mListItems[this.getSelectedIndex()];
        }
        return fileListItem;
    }

    public FileListItem[] getSelectedFileListItems() {
        int[] nArray = this.getSelectedIndexes();
        boolean bl = this.isIndexSelected(0) && this.mListItems[0].getName().equals("..");
        FileListItem[] fileListItemArray = new FileListItem[this.getSelectionCount()];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0 && bl) continue;
            fileListItemArray[n++] = this.mListItems[nArray[i]];
        }
        return fileListItemArray;
    }

    public int getSelectionCount() {
        int[] nArray = this.getSelectedIndexes();
        if (this.isIndexSelected(0) && this.mListItems[0].getName().equals("..")) {
            return nArray.length - 1;
        }
        return nArray.length;
    }

    public FileListItem getFileListItem(String string) {
        if (string != null) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!string.equals(this.getItem(i))) continue;
                return this.mListItems[i];
            }
        }
        return null;
    }
}

