/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.ssh;

import com.isnetworks.ssh.AbstractFileBrowser;
import com.isnetworks.ssh.FileDisplay;
import com.isnetworks.ssh.FileListItem;
import java.io.File;
import java.io.IOException;

public class LocalFileBrowser
extends AbstractFileBrowser {
    private File cwd;

    public LocalFileBrowser(FileDisplay fileDisplay, String string) {
        super(fileDisplay);
        try {
            this.changeDirectory(string);
        }
        catch (Exception exception) {
            this.cwd = new File(".");
        }
    }

    public void initialize() throws Exception {
        this.refresh();
    }

    public void refresh() throws Exception {
        boolean bl;
        String[] stringArray = this.cwd.list();
        boolean bl2 = bl = this.cwd.getParent() == null;
        if (!bl) {
            this.dirs.addElement(new FileListItem("..", "", true, File.separator));
        }
        String string = null;
        try {
            string = this.cwd.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new Exception("Unable to refresh file list");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(this.cwd, stringArray[i]);
                FileListItem fileListItem = new FileListItem(stringArray[i], string, file.isDirectory(), File.separator, file.length());
                if (file.isDirectory()) {
                    this.dirs.addElement(fileListItem);
                    continue;
                }
                this.files.addElement(fileListItem);
            }
        }
        this.mFileDisplay.setFileList(this.dirs, this.files, string, File.separator);
    }

    public void makeDirectory(String string) throws Exception {
        File file = new File(this.cwd, string);
        if (!file.mkdirs()) {
            throw new Exception("Unable to make directory: " + file.getAbsolutePath());
        }
    }

    public void delete(FileListItem[] fileListItemArray) throws Exception {
        for (int i = 0; i < fileListItemArray.length; ++i) {
            File file = new File(fileListItemArray[i].getParent(), fileListItemArray[i].getName());
            if (file.delete()) continue;
            throw new Exception("Unable to delete " + fileListItemArray[i].getAbsolutePath() + " - may not have permission or directory may not be empty");
        }
    }

    public void changeDirectory(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception("Directory " + string + " does not exist or you do not have permission to access it.");
        }
        if (file.isFile()) {
            throw new Exception(string + " a file, not a directory.");
        }
        this.cwd = file;
    }

    public void rename(FileListItem fileListItem, String string) throws Exception {
        File file = new File(fileListItem.getParent(), fileListItem.getName());
        File file2 = null;
        file2 = !string.startsWith(File.separator) ? new File(this.cwd, string) : new File(string);
        if (!file.renameTo(file2)) {
            throw new Exception("Unable to rename file " + fileListItem.getAbsolutePath() + " to " + string);
        }
    }

    public void fileDoubleClicked(FileListItem fileListItem) throws Exception {
        if (fileListItem.isDirectory()) {
            File file = null;
            file = fileListItem.getName().equals("..") ? new File(this.cwd.getParent()) : new File(fileListItem.getParent(), fileListItem.getName());
            if (!file.exists() || !file.isDirectory()) {
                throw new Exception("Unable to open directory: " + file.getAbsolutePath());
            }
            this.cwd = file;
        }
    }
}

