/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.application;

import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHMenuHandler;
import com.mindbright.ssh.SSHPropertyHandler;
import com.mindbright.ssh.SSHSCPClient;
import com.mindbright.ssh.SSHStdIO;
import com.mindbright.sshcommon.SSHSCPStdoutProgress;
import com.mindbright.terminal.GlobalClipboard;
import com.mindbright.terminal.TerminalDefProps;
import com.mindbright.terminal.TerminalMenuHandler;
import com.mindbright.terminal.TerminalWin;
import com.mindbright.terminal.TerminalXTerm;
import com.mindbright.util.Util;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.PopupMenu;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class MindTerm
extends Applet
implements Runnable,
WindowListener {
    static Properties paramTermProps = new Properties();
    static Properties paramSSHProps = new Properties();
    public static String javaVersion = "<unknown>";
    public static String javaVendor = "<unknown>";
    public static String osName = "<unknown>";
    public static String osArch = "<unknown>";
    public static String osVersion = "<unknown>";
    Frame frame;
    TerminalWin term;
    SSHInteractiveClient client;
    SSHInteractiveClient sshClone;
    SSHStdIO console;
    Thread clientThread;
    boolean mergedTermProps;
    Properties sshProps;
    Properties termProps;
    String[] cmdLineArgs;
    String commandLine = null;
    String sshHomeDir = null;
    String propsFile = null;
    boolean usePopMenu = false;
    boolean haveMenus = true;
    boolean haveGUI = true;
    boolean exitOnLogout = false;
    boolean quiet = true;
    boolean doSCP = false;
    boolean recursiveSCP = false;
    boolean toRemote = true;
    int firstArg = 0;
    boolean autoSaveProps = true;
    boolean autoLoadProps = true;
    boolean savePasswords = false;
    int popButtonNum = 3;
    boolean isClosing = false;
    boolean separateFrame = true;
    public boolean weAreAnApplet = false;
    static Hashtable terminals = new Hashtable();
    boolean confirmedClose = false;

    static synchronized boolean isLastTerminal() {
        return terminals.isEmpty();
    }

    static synchronized void addTerminal(MindTerm mindTerm) {
        terminals.put(mindTerm, mindTerm);
    }

    static synchronized void removeTerminal(MindTerm mindTerm) {
        terminals.remove(mindTerm);
    }

    public MindTerm() {
        this.sshProps = paramSSHProps;
        this.termProps = paramTermProps;
        MindTerm.addTerminal(this);
    }

    public MindTerm(Properties properties, Properties properties2) {
        this.sshProps = properties;
        this.termProps = properties2;
        MindTerm.addTerminal(this);
    }

    public static void main(String[] stringArray) {
        MindTerm mindTerm = new MindTerm(paramSSHProps, paramTermProps);
        mindTerm.cmdLineArgs = stringArray;
        try {
            mindTerm.getApplicationParams();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            System.exit(1);
        }
        try {
            mindTerm.run();
        }
        catch (Exception exception) {
            System.out.println("Error, please email the stack trace below to mt-support@appgate.com");
            exception.printStackTrace();
        }
    }

    public void init() {
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("TerminalEmulator");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        this.weAreAnApplet = true;
        this.autoSaveProps = false;
        this.autoLoadProps = false;
        this.savePasswords = false;
        this.getAppletParams();
        new Thread((Runnable)this, "MindTerm.init").start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block36: {
            try {
                String string;
                Object object;
                String[] stringArray;
                if (this.sshClone != null) {
                    if (this.sshClone.isSSH2) {
                        this.client = null;
                        this.sshClone.newShell();
                        MindTerm.removeTerminal(this);
                        return;
                    }
                    this.client = new SSHInteractiveClient(this.sshClone);
                    this.sshClone = null;
                } else {
                    if (this.commandLine != null && this.sshProps.getProperty("force-pty") == null) {
                        ((Hashtable)this.sshProps).put("force-pty", "false");
                    }
                    stringArray = new SSHPropertyHandler(this.sshProps, true);
                    if (this.propsFile != null) {
                        try {
                            stringArray = SSHPropertyHandler.fromFile(this.propsFile, "");
                        }
                        catch (SSHClient.AuthFailException authFailException) {
                            throw new Exception("Sorry, can only use passwordless settings files for now");
                        }
                        stringArray.mergeProperties(this.sshProps);
                    }
                    this.client = new SSHInteractiveClient(this.quiet, this.exitOnLogout, (SSHPropertyHandler)stringArray);
                }
                if (this.weAreAnApplet && this.client.getPropertyHandler().getDefaultProperty("server") == null) {
                    this.client.getPropertyHandler().setDefaultProperty("server", this.getCodeBase().getHost());
                }
                if (this.client.getPropertyHandler().getDefaultProperty("username") == null) {
                    try {
                        this.client.getPropertyHandler().setDefaultProperty("username", System.getProperty("user.name", ""));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.console = (SSHStdIO)this.client.getConsole();
                if (this.client.getPropertyHandler().getInitTerminalProperties() != null) {
                    stringArray = new Properties(this.client.getPropertyHandler().getInitTerminalProperties());
                    if (this.termProps != null && !((Hashtable)this.termProps).isEmpty()) {
                        object = ((Hashtable)this.termProps).keys();
                        while (object.hasMoreElements()) {
                            string = (String)object.nextElement();
                            stringArray.put(string, this.termProps.getProperty(string));
                        }
                        this.mergedTermProps = true;
                    }
                    this.termProps = stringArray;
                }
                if (this.haveGUI) {
                    this.initGUI();
                    this.console.setTerminal(this.term);
                    this.console.setOwnerContainer(this.frame);
                    this.console.setOwnerName(SSH.VER_MINDTERM);
                    this.console.updateTitle();
                    try {
                        while (!this.frame.isShowing()) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.separateFrame) {
                        this.term.emulateComponentShown();
                    }
                }
                if (!this.client.getPropertyHandler().setSSHHomeDir(this.sshHomeDir)) {
                    throw new Exception("License not accepted, exiting");
                }
                this.client.getPropertyHandler().setAutoSaveProps(this.autoLoadProps);
                this.client.getPropertyHandler().setAutoLoadProps(this.autoSaveProps);
                this.client.getPropertyHandler().setSavePasswords(this.savePasswords);
                this.client.updateMenus();
                if (this.commandLine != null) {
                    if (!this.doSCP) {
                        this.client.doSingleCommand(this.commandLine);
                        break block36;
                    }
                    if (this.cmdLineArgs.length - this.firstArg < 2) {
                        throw new Exception("scp must have at least two arguments (<source> <destination>)");
                    }
                    stringArray = new String[this.cmdLineArgs.length - this.firstArg - 1];
                    string = this.commandLine.substring(0, this.commandLine.lastIndexOf(32));
                    for (int i = this.firstArg; i < this.cmdLineArgs.length - 1; ++i) {
                        stringArray[i - this.firstArg] = this.cmdLineArgs[i];
                    }
                    object = this.cmdLineArgs[this.cmdLineArgs.length - 1];
                    String string2 = this.client.getPropertyHandler().getSrvHost();
                    int n = this.client.getPropertyHandler().getSrvPort();
                    SSHSCPClient sSHSCPClient = new SSHSCPClient(string2, n, this.client.getPropertyHandler(), SSH.DEBUG ? this.client : null, new File("."), SSH.DEBUG);
                    if (SSH.DEBUG) {
                        sSHSCPClient.scp1().setProgress(new SSHSCPStdoutProgress());
                    }
                    if (this.toRemote) {
                        sSHSCPClient.scp1().copyToRemote(stringArray, (String)object, this.recursiveSCP);
                        break block36;
                    } else {
                        sSHSCPClient.scp1().copyToLocal((String)object, string, this.recursiveSCP);
                    }
                    break block36;
                }
                try {
                    this.clientThread = new Thread((Runnable)this.client, "MindTerm");
                    this.clientThread.start();
                    this.clientThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.client != null) {
                    this.client.alert(illegalArgumentException.getMessage());
                }
                System.out.println(illegalArgumentException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Settings-file not found: " + fileNotFoundException.getMessage());
            }
            catch (Exception exception) {
                if (this.client != null) {
                    this.client.alert("Error: " + exception.getMessage());
                }
                System.out.println("Error: " + exception.getMessage());
                if (!SSH.DEBUGMORE) break block36;
                System.out.println("Please send the below stack-trace to mt-support@appgate.com");
                exception.printStackTrace();
            }
        }
        this.windowClosing(null);
        if (MindTerm.isLastTerminal()) {
            this.doExit();
        }
    }

    public void getAppletParams() {
        String string;
        String string2;
        int n;
        try {
            this.separateFrame = new Boolean(this.getParameter("sepframe"));
        }
        catch (Exception exception) {
            this.separateFrame = true;
        }
        try {
            SSH.DEBUG = new Boolean(this.getParameter("verbose"));
        }
        catch (Exception exception) {
            SSH.DEBUG = false;
        }
        try {
            SSH.DEBUG = SSH.DEBUGMORE = new Boolean(this.getParameter("debug")).booleanValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.quiet = new Boolean(this.getParameter("quiet"));
        }
        catch (Exception exception) {
            this.quiet = true;
        }
        try {
            this.exitOnLogout = new Boolean(this.getParameter("exit-on-logout"));
        }
        catch (Exception exception) {
            this.exitOnLogout = false;
        }
        try {
            this.savePasswords = new Boolean(this.getParameter("savepasswords"));
        }
        catch (Exception exception) {
            this.savePasswords = false;
        }
        String string3 = this.getParameter("menus");
        if (string3 != null) {
            if (string3.equals("no")) {
                this.haveMenus = false;
            } else if (string3.startsWith("pop")) {
                this.getPopupButtonNumber(string3);
                this.usePopMenu = true;
            }
        }
        if ((string3 = this.getParameter("autoprops")) != null) {
            if (string3.equals("save")) {
                this.autoSaveProps = true;
                this.autoLoadProps = false;
            } else if (string3.equals("load")) {
                this.autoSaveProps = false;
                this.autoLoadProps = true;
            } else if (string3.equals("both")) {
                this.autoSaveProps = true;
                this.autoLoadProps = true;
            }
        }
        this.sshHomeDir = this.getParameter("sshhome");
        this.propsFile = this.getParameter("propsfile");
        this.commandLine = this.getParameter("commandline");
        this.getDefaultParams();
        for (n = 0; n < SSHPropertyHandler.defaultPropDesc.length; ++n) {
            string2 = SSHPropertyHandler.defaultPropDesc[n][0];
            string = this.getParameter(string2);
            if (string == null) continue;
            ((Hashtable)paramSSHProps).put(string2, string);
        }
        n = 0;
        while ((string = this.getParameter("local" + n)) != null) {
            ((Hashtable)paramSSHProps).put("local" + n, string);
            ++n;
        }
        n = 0;
        while ((string = this.getParameter("remote" + n)) != null) {
            ((Hashtable)paramSSHProps).put("remote" + n, string);
            ++n;
        }
        for (n = 0; n < TerminalDefProps.defaultPropDesc.length; ++n) {
            string2 = TerminalDefProps.defaultPropDesc[n][0];
            string = this.getParameter(string2);
            if (string == null) continue;
            ((Hashtable)this.termProps).put(string2, string);
        }
        string3 = this.getParameter("appletbg");
        if (string3 != null) {
            Color color;
            try {
                color = TerminalWin.getTermColor(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    color = TerminalWin.getTermRGBColor(string3);
                }
                catch (Throwable throwable) {
                    color = null;
                }
            }
            if (color != null) {
                this.setBackground(color);
            }
        }
    }

    public AppletContext getAppletContext() {
        AppletContext appletContext = null;
        if (this.weAreAnApplet) {
            appletContext = super.getAppletContext();
        }
        return appletContext;
    }

    public void getApplicationParams() throws Exception {
        int n;
        String string;
        int n2;
        try {
            String string2;
            block18: for (n2 = 0; n2 < this.cmdLineArgs.length && (string2 = this.cmdLineArgs[n2]).startsWith("--"); ++n2) {
                switch (string2.charAt(2)) {
                    case 'h': {
                        this.sshHomeDir = this.cmdLineArgs[++n2];
                        continue block18;
                    }
                    case 'f': {
                        this.propsFile = this.cmdLineArgs[++n2];
                        continue block18;
                    }
                    case 'd': {
                        this.haveGUI = false;
                        continue block18;
                    }
                    case 'e': {
                        this.exitOnLogout = true;
                        continue block18;
                    }
                    case 'm': {
                        String string3 = this.cmdLineArgs[++n2];
                        if (string3.equals("no")) {
                            this.haveMenus = false;
                            continue block18;
                        }
                        if (string3.startsWith("pop")) {
                            this.getPopupButtonNumber(string3);
                            this.usePopMenu = true;
                            continue block18;
                        }
                        throw new Exception("value of '--m' must be 'no', 'pop1', 'pop2', or 'pop3'");
                    }
                    case 'p': {
                        String string3 = this.cmdLineArgs[++n2];
                        if (string3.equals("save")) {
                            this.autoSaveProps = true;
                            continue block18;
                        }
                        if (string3.equals("load")) {
                            this.autoLoadProps = true;
                            continue block18;
                        }
                        if (string3.equals("both")) {
                            this.autoSaveProps = true;
                            this.autoLoadProps = true;
                            continue block18;
                        }
                        if (string3.equals("none")) {
                            this.autoSaveProps = false;
                            this.autoLoadProps = false;
                            continue block18;
                        }
                        throw new Exception("value of '--p' must be 'save', 'load', 'both', or 'none'");
                    }
                    case 'q': {
                        String string3 = this.cmdLineArgs[++n2];
                        if (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("false")) {
                            this.quiet = Boolean.valueOf(string3);
                            continue block18;
                        }
                        throw new Exception("value of '--q' must be 'true' or 'false'");
                    }
                    case 'r': {
                        this.recursiveSCP = true;
                        continue block18;
                    }
                    case 's': {
                        this.haveGUI = false;
                        this.doSCP = true;
                        String string4 = this.cmdLineArgs[++n2];
                        if (string4.equalsIgnoreCase("toremote")) {
                            this.toRemote = true;
                            continue block18;
                        }
                        if (string4.equalsIgnoreCase("tolocal")) {
                            this.toRemote = false;
                            continue block18;
                        }
                        throw new Exception("value of '--s' must be 'toremote' or 'tolocal'");
                    }
                    case 'v': {
                        System.out.println("verbose mode selected...");
                        SSH.DEBUG = true;
                        continue block18;
                    }
                    case 'x': {
                        this.savePasswords = true;
                        continue block18;
                    }
                    case 'V': {
                        System.out.println(SSH.VER_MINDTERM);
                        System.out.println("SSH protocol version 1.5");
                        System.exit(0);
                        continue block18;
                    }
                    case 'D': {
                        SSH.DEBUG = true;
                        SSH.DEBUGMORE = true;
                        continue block18;
                    }
                    case '?': {
                        this.printHelp();
                        System.exit(0);
                    }
                    default: {
                        throw new Exception("unknown parameter '" + string2 + "'");
                    }
                }
            }
        }
        catch (Exception exception) {
            this.printHelp();
            throw exception;
        }
        this.getDefaultParams();
        for (n2 = n = n2; n2 < this.cmdLineArgs.length && (string = this.cmdLineArgs[n2]).charAt(0) == '-' && n2 + 1 != this.cmdLineArgs.length; n2 += 2) {
            string = string.substring(1);
            String string5 = this.cmdLineArgs[n2 + 1];
            if (SSHPropertyHandler.isProperty(string)) {
                ((Hashtable)paramSSHProps).put(string, string5);
                continue;
            }
            if (TerminalDefProps.isProperty(string)) {
                ((Hashtable)paramTermProps).put(string, string5);
                continue;
            }
            System.out.println("Unknown property '" + string + "'");
        }
        if (n2 < this.cmdLineArgs.length) {
            this.firstArg = n2;
            this.commandLine = "";
            while (n2 < this.cmdLineArgs.length) {
                this.commandLine = this.commandLine + this.cmdLineArgs[n2] + " ";
                ++n2;
            }
            this.commandLine = this.commandLine.trim();
        }
    }

    void printHelp() {
        System.out.println("usage: MindTerm [options] [properties] [commandline]");
        System.out.println("Options:");
        System.out.println("  --d            No terminal-window, only dumb command-line and port-forwarding.");
        System.out.println("  --e            Exit MindTerm after logout (i.e. single session).");
        System.out.println("  --f <file>     Use settings from the given file as default.");
        System.out.println("  --h dir        Name of the MindTerm home-dir (default: ~/mindterm/).");
        System.out.println("  --m <no | pop | popN>");
        System.out.println("                 Use no menus or popup (on mouse-button N) menu.");
        System.out.println("  --p <save | load | both | none>");
        System.out.println("                 Sets automatic save/load flags for property-files.");
        System.out.println("  --q <true | false>");
        System.out.println("                 Quiet; don't query for server/username if given.");
        System.out.println("  --v            Verbose; display verbose messages.");
        System.out.println("  --x            Save passwords in encrypted property-files.");
        System.out.println("  --D            Debug; display extra debug info.");
        System.out.println("  --V            Version; display version number only.");
        System.out.println("  --?            Help; display this help.");
    }

    void getPopupButtonNumber(String string) {
        if (string.length() == 4) {
            try {
                this.popButtonNum = Integer.valueOf(string.substring(3));
                if (this.popButtonNum < 1 || this.popButtonNum > 3) {
                    this.popButtonNum = 3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void getDefaultParams() {
        try {
            if (this.sshHomeDir == null) {
                String string = System.getProperty("user.home");
                if (string == null) {
                    string = System.getProperty("user.dir");
                }
                if (string == null) {
                    string = System.getProperty("java.home");
                }
                this.sshHomeDir = string + File.separator + "mindterm" + File.separator;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            javaVersion = System.getProperty("java.version");
            javaVendor = System.getProperty("java.vendor");
            osName = System.getProperty("os.name");
            osArch = System.getProperty("os.arch");
            osVersion = System.getProperty("os.version");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void initGUI() {
        Object object;
        Container container;
        MenuBar menuBar = null;
        if (this.separateFrame) {
            this.frame = new Frame();
            this.frame.addWindowListener(this);
            container = this.frame;
            if (this.haveMenus && !this.usePopMenu) {
                menuBar = new MenuBar();
                this.frame.setMenuBar(menuBar);
                this.frame.addNotify();
                this.frame.validate();
            }
        } else {
            object = this;
            while (!((object = ((Component)object).getParent()) instanceof Frame)) {
            }
            this.frame = (Frame)object;
            container = this;
        }
        object = this.termProps.getProperty("font-name");
        String string = this.termProps.getProperty("font-size");
        int n = 12;
        if (string != null) {
            n = Integer.parseInt(string);
        }
        if (object == null) {
            object = TerminalDefProps.defaultFont();
        }
        container.setFont(new Font((String)object, 0, n));
        this.term = new TerminalWin(this.frame, new TerminalXTerm(), this.termProps, this.sshClone == null);
        if (this.mergedTermProps) {
            this.term.setPropsChanged(true);
        }
        if (this.haveMenus) {
            try {
                Class<?> clazz = Class.forName("com.mindbright.ssh.SSHMenuHandlerFull");
                SSHMenuHandler sSHMenuHandler = (SSHMenuHandler)clazz.newInstance();
                sSHMenuHandler.init(this, this.client, this.frame, this.term);
                clazz = Class.forName("com.mindbright.terminal.TerminalMenuHandlerFull");
                TerminalMenuHandler terminalMenuHandler = (TerminalMenuHandler)clazz.newInstance();
                terminalMenuHandler.setTerminalWin(this.term);
                this.term.setMenus(terminalMenuHandler);
                this.client.setMenus(sSHMenuHandler);
                if (menuBar == null) {
                    PopupMenu popupMenu = this.term.getPopupMenu("MindTerm Menu");
                    sSHMenuHandler.preparePopupMenu(popupMenu);
                    sSHMenuHandler.setPopupButton(this.popButtonNum);
                } else {
                    sSHMenuHandler.prepareMenuBar(menuBar);
                }
                terminalMenuHandler.setTerminalMenuListener(sSHMenuHandler);
                this.term.setClipboard(GlobalClipboard.getClipboardHandler(terminalMenuHandler));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.out.println("Full menus can't be enabled since classes are missing");
                this.term.setMenus(null);
                this.client.setMenus(null);
                this.term.setClipboard(GlobalClipboard.getClipboardHandler());
            }
        } else {
            this.term.setClipboard(GlobalClipboard.getClipboardHandler());
        }
        SSH.randomSeed().addEntropyGenerator(this.term);
        container.setLayout(new BorderLayout());
        container.add((Component)this.term.getPanelWithScrollbar(), "Center");
        this.frame.pack();
        this.frame.show();
        this.term.requestFocus();
    }

    public void doExit() {
        System.out.println("Thank you for using MindTerm...");
        if (!this.separateFrame && this.term != null) {
            this.term.clearScreen();
            this.term.setAttribute(1, true);
            this.term.write("Thank you for using MindTerm...");
        }
        if (!this.weAreAnApplet) {
            System.exit(0);
        }
    }

    public boolean confirmClose() {
        if (this.client != null && !this.confirmedClose) {
            try {
                this.client.getPropertyHandler().checkSave();
            }
            catch (IOException iOException) {
                this.client.alert("Error saving settings: " + iOException.getMessage());
            }
            this.confirmedClose = !this.client.isOpened() || this.client.askConfirmation("Do you really want to disconnect from " + this.client.getPropertyHandler().getProperty("server") + "?", false);
        }
        return this.confirmedClose;
    }

    void initParams(MindTerm mindTerm) {
        this.sshHomeDir = mindTerm.sshHomeDir;
        this.propsFile = mindTerm.propsFile;
        this.usePopMenu = mindTerm.usePopMenu;
        this.haveMenus = mindTerm.haveMenus;
        this.haveGUI = mindTerm.haveGUI;
        this.exitOnLogout = mindTerm.exitOnLogout;
        this.quiet = mindTerm.quiet;
        this.separateFrame = true;
        this.weAreAnApplet = mindTerm.weAreAnApplet;
        this.autoLoadProps = mindTerm.autoLoadProps;
        this.popButtonNum = mindTerm.popButtonNum;
    }

    public void cloneWindow() {
        MindTerm mindTerm = new MindTerm(this.sshProps, this.termProps);
        mindTerm.initParams(this);
        mindTerm.sshClone = this.client;
        new Thread((Runnable)mindTerm, "MindTerm.clone").start();
    }

    public void newWindow() {
        MindTerm mindTerm = new MindTerm(paramSSHProps, paramTermProps);
        mindTerm.initParams(this);
        new Thread((Runnable)mindTerm, "MindTerm.window").start();
    }

    public void close() {
        if (!this.confirmClose()) {
            return;
        }
        if (this.client.isSSH2) {
            this.client.transport.normalDisconnect("User closed connection");
        }
        if (this.clientThread != null) {
            this.clientThread.stop();
        }
    }

    public void exit() {
        if (!this.confirmClose()) {
            return;
        }
        Enumeration enumeration = terminals.elements();
        while (enumeration.hasMoreElements()) {
            MindTerm mindTerm = (MindTerm)enumeration.nextElement();
            if (mindTerm.client != null && mindTerm.client.isSSH2) {
                mindTerm.client.transport.normalDisconnect("User exited");
            }
            if (mindTerm.clientThread == null) continue;
            mindTerm.clientThread.stop();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public synchronized void windowClosing(WindowEvent windowEvent) {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        if (!this.confirmClose()) {
            this.isClosing = false;
            return;
        }
        if (this.separateFrame && this.haveGUI && this.frame != null) {
            this.frame.dispose();
        }
        if (this.clientThread != null && this.clientThread.isAlive()) {
            this.clientThread.stop();
        }
        MindTerm.removeTerminal(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.term.requestFocus();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

