/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.application;

import com.mindbright.application.MindTermApp;
import com.mindbright.application.MindTermModule;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.terminal.GlobalClipboard;
import com.mindbright.terminal.TerminalFrameTitle;
import com.mindbright.terminal.TerminalMenuHandler;
import com.mindbright.terminal.TerminalMenuListener;
import com.mindbright.terminal.TerminalWin;
import com.mindbright.terminal.TerminalXTerm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ModuleBaseTerminal
extends WindowAdapter
implements MindTermModule,
Runnable,
TerminalMenuListener {
    protected MindTermApp mindterm;
    protected Thread myThread;
    private Vector instances;

    public void init(MindTermApp mindTermApp) {
        this.mindterm = mindTermApp;
    }

    protected boolean haveMenus() {
        return Boolean.valueOf(this.mindterm.getProperty("havemenus"));
    }

    protected boolean useChaff() {
        return Boolean.valueOf(this.mindterm.getProperty("key-timing-noise"));
    }

    public void activate(MindTermApp mindTermApp) {
        if (this.instances == null) {
            this.instances = new Vector();
        }
        ModuleBaseTerminal moduleBaseTerminal = this.newInstance();
        this.instances.addElement(moduleBaseTerminal);
        moduleBaseTerminal.init(mindTermApp);
        moduleBaseTerminal.myThread = new Thread((Runnable)moduleBaseTerminal, "Terminal_" + this.getClass());
        moduleBaseTerminal.myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Frame frame = this.haveMenus() ? AWTConvenience.newFrameWithMenuBar() : new Frame();
        TerminalWin terminalWin = new TerminalWin(frame, new TerminalXTerm(), this.mindterm.getProperties());
        this.mindterm.getRandomSeed().addEntropyGenerator(terminalWin);
        frame.setLayout(new BorderLayout());
        frame.add((Component)terminalWin.getPanelWithScrollbar(), "Center");
        TerminalFrameTitle terminalFrameTitle = new TerminalFrameTitle(frame, this.getTitle());
        terminalFrameTitle.attach(terminalWin);
        TerminalMenuHandler terminalMenuHandler = null;
        if (this.haveMenus()) {
            try {
                terminalMenuHandler = (TerminalMenuHandler)Class.forName("com.mindbright.terminal.TerminalMenuHandlerFull").newInstance();
                terminalMenuHandler.setTitleName(this.mindterm.getAppName());
                terminalMenuHandler.addBasicMenus(terminalWin, frame);
                terminalMenuHandler.setTerminalMenuListener(this);
            }
            catch (Throwable throwable) {}
        } else {
            terminalWin.setClipboard(GlobalClipboard.getClipboardHandler());
        }
        frame.addWindowListener(this);
        frame.pack();
        frame.show();
        try {
            this.runTerminal(this.mindterm, terminalWin, frame, terminalFrameTitle);
            Object var7_6 = null;
            frame.dispose();
            if (this.haveMenus() && terminalMenuHandler != null) {
                GlobalClipboard.getClipboardHandler().removeMenuHandler(terminalMenuHandler);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            frame.dispose();
            if (this.haveMenus() && terminalMenuHandler != null) {
                GlobalClipboard.getClipboardHandler().removeMenuHandler(terminalMenuHandler);
            }
            throw throwable;
        }
    }

    public void connected(MindTermApp mindTermApp) {
    }

    public void disconnected(MindTermApp mindTermApp) {
        if (this.instances != null) {
            Enumeration enumeration = this.instances.elements();
            while (enumeration.hasMoreElements()) {
                ModuleBaseTerminal moduleBaseTerminal = (ModuleBaseTerminal)enumeration.nextElement();
                if (!moduleBaseTerminal.closeOnDisconnect()) continue;
                moduleBaseTerminal.doClose();
                this.instances.removeElement(moduleBaseTerminal);
            }
        }
    }

    public String description(MindTermApp mindTermApp) {
        return null;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doClose();
    }

    public void close(TerminalMenuHandler terminalMenuHandler) {
        this.doClose();
    }

    public void update() {
    }

    protected abstract void runTerminal(MindTermApp var1, TerminalWin var2, Frame var3, TerminalFrameTitle var4);

    protected abstract boolean closeOnDisconnect();

    protected abstract String getTitle();

    protected abstract void doClose();

    protected abstract ModuleBaseTerminal newInstance();

    public abstract /* synthetic */ boolean isAvailable(MindTermApp var1);
}

