/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.application;

import com.mindbright.application.MindTermApp;
import com.mindbright.application.MindTermModule;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.ssh2.SSH2FTPOverSFTP;
import com.mindbright.util.Util;
import java.applet.AppletContext;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class ModuleFTPOverSFTP
implements MindTermModule,
ActionListener,
Runnable {
    Dialog ftpdDialog;
    TextField ftpHost;
    TextField ftpPort;
    Label lblStatus;
    Button startBut;
    Button closeBut;
    Button browseBut;
    ServerSocket ftpdListen;
    MindTermApp mindterm;
    Thread ftpd;

    public void ftpdDialog() {
    }

    public void init(MindTermApp mindTermApp) {
        this.mindterm = mindTermApp;
    }

    public void activate(MindTermApp mindTermApp) {
        Object object;
        Object object2;
        if (this.ftpdDialog == null) {
            this.ftpdDialog = new Dialog(mindTermApp.getParentFrame(), mindTermApp.getAppName() + " - FTP To SFTP Bridge", false);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(this.ftpdDialog);
            object2 = new Label("Listen address:");
            aWTGridBagContainer.add((Component)object2, 0, 1);
            object2 = new Label("Listen port:");
            aWTGridBagContainer.add((Component)object2, 0, 1);
            this.ftpHost = new TextField("127.0.0.1", 20);
            aWTGridBagContainer.add(this.ftpHost, 1, 1);
            this.ftpPort = new TextField("21", 5);
            aWTGridBagContainer.add(this.ftpPort, 1, 1);
            aWTGridBagContainer.getConstraints().anchor = 10;
            this.lblStatus = new Label("Bridge disabled...", 1);
            aWTGridBagContainer.add(this.lblStatus, 2, 2);
            object = new Panel(new FlowLayout());
            this.startBut = new Button("Enable");
            ((Container)object).add(this.startBut);
            this.startBut.addActionListener(this);
            if (mindTermApp.isApplet()) {
                this.browseBut = new Button("Browser...");
                ((Container)object).add(this.browseBut);
                this.browseBut.addActionListener(this);
            }
            this.closeBut = new Button("Close Dialog");
            ((Container)object).add(this.closeBut);
            this.closeBut.addActionListener(new AWTConvenience.CloseAction(this.ftpdDialog));
            aWTGridBagContainer.add((Component)object, 3, 0);
            this.ftpdDialog.addWindowListener(new AWTConvenience.CloseAdapter(this.closeBut));
            AWTConvenience.setBackgroundOfChildren(this.ftpdDialog);
            AWTConvenience.setKeyListenerOfChildren(this.ftpdDialog, new AWTConvenience.OKCancelAdapter(this.startBut, this.closeBut), null);
            this.ftpdDialog.setResizable(true);
            this.ftpdDialog.pack();
        }
        object2 = mindTermApp.getProperty("sftpbridge-host");
        object = mindTermApp.getProperty("sftpbridge-port");
        if (object2 != null && !((String)object2).equals("")) {
            this.ftpHost.setText((String)object2);
        }
        if (object != null && !((String)object).equals("")) {
            this.ftpPort.setText((String)object);
        }
        this.updateFtpdDialog(false);
        AWTConvenience.placeDialog(this.ftpdDialog);
        ((Component)this.ftpdDialog).setVisible(true);
    }

    public boolean isAvailable(MindTermApp mindTermApp) {
        return mindTermApp.isConnected() && mindTermApp.getConnection() != null;
    }

    public void connected(MindTermApp mindTermApp) {
        String string = mindTermApp.getProperty("sftpbridge-host");
        String string2 = mindTermApp.getProperty("sftpbridge-port");
        if (string != null && string.trim().length() > 0) {
            try {
                this.startFtpdLoop(string, string2);
                mindTermApp.alert("Starting ftp to sftp bridge on " + string + ":" + string2);
            }
            catch (Exception exception) {
                mindTermApp.alert("Error starting ftp to sftp bridge on " + string + ":" + string2 + " - " + exception.getMessage());
            }
        }
    }

    public void disconnected(MindTermApp mindTermApp) {
        this.stopFtpdLoop();
    }

    public String description(MindTermApp mindTermApp) {
        return null;
    }

    private void updateFtpdDialog(boolean bl) {
        if (this.ftpdListen == null) {
            if (!bl) {
                this.lblStatus.setText("Bridge disabled...");
            }
            this.ftpPort.setEnabled(true);
            this.ftpHost.setEnabled(true);
            if (this.browseBut != null) {
                this.browseBut.setEnabled(false);
            }
            this.startBut.setLabel("Enable");
        } else {
            if (!bl) {
                this.lblStatus.setText("Bridge enabled: " + this.ftpHost.getText() + ":" + this.ftpPort.getText());
            }
            this.ftpPort.setEnabled(false);
            this.ftpHost.setEnabled(false);
            if (this.browseBut != null) {
                this.browseBut.setEnabled(true);
            }
            this.startBut.setLabel("Disable");
        }
    }

    public void run() {
        this.ftpdLoop(this.ftpdListen);
    }

    public void startFtpdLoop(String string, String string2) throws Exception {
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("TerminalEmulator");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        int n = Integer.parseInt(string2);
        this.ftpdListen = new ServerSocket(n, 32, InetAddress.getByName(string));
        this.ftpd = new Thread((Runnable)this, "FTPOverSFTP");
        this.ftpd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFtpdLoop() {
        if (this.ftpdListen != null) {
            try {
                this.ftpdListen.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ftpdListen = null;
            }
        }
        if (this.ftpd != null && this.ftpd.isAlive()) {
            this.ftpd.stop();
        }
        this.ftpd = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ftpdLoop(ServerSocket serverSocket) {
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("TerminalEmulator");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        Socket socket = null;
        try {
            while (true) {
                socket = null;
                socket = serverSocket.accept();
                try {
                    SSH2FTPOverSFTP sSH2FTPOverSFTP = new SSH2FTPOverSFTP(this.mindterm.getConnection(), socket.getInputStream(), socket.getOutputStream(), this.mindterm.getAppName() + ", FTP To SFTP Bridge");
                }
                catch (Throwable throwable) {
                    this.mindterm.alert("Failed to start FTP over SFTP bridge: " + throwable.getMessage());
                    throwable.printStackTrace();
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {}
                }
            }
        }
        catch (Exception exception) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            exception.printStackTrace();
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Browser...")) {
            AppletContext appletContext = this.mindterm.getAppletContext();
            String string = this.ftpHost.getText();
            if ("0.0.0.0".equals(string)) {
                string = "127.0.0.1";
            }
            String string2 = "ftp://" + string + ":" + this.ftpPort.getText();
            try {
                appletContext.showDocument(new URL(string2), "_blank");
            }
            catch (Exception exception) {
                this.mindterm.alert("Error running ftp browser: " + exception);
            }
        } else if (this.ftpd != null) {
            this.startBut.setLabel("Enable");
            this.stopFtpdLoop();
            this.updateFtpdDialog(false);
            this.mindterm.setProperty("sftpbridge-host", "");
            this.mindterm.setProperty("sftpbridge-port", "");
        } else {
            boolean bl = false;
            this.lblStatus.setText("");
            try {
                String string = this.ftpHost.getText();
                String string3 = this.ftpPort.getText();
                this.startFtpdLoop(string, string3);
                this.mindterm.setProperty("sftpbridge-host", string);
                this.mindterm.setProperty("sftpbridge-port", string3);
            }
            catch (Exception exception) {
                bl = true;
                this.ftpdListen = null;
                this.lblStatus.setText("Error: " + exception.getMessage());
            }
            this.updateFtpdDialog(bl);
        }
    }
}

