/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.application;

import com.mindbright.application.MindTermApp;
import com.mindbright.application.ModuleBaseTerminal;
import com.mindbright.net.telnet.TelnetTerminalAdapter;
import com.mindbright.ssh2.SSH2InternalChannel;
import com.mindbright.terminal.LineReaderTerminal;
import com.mindbright.terminal.Terminal;
import com.mindbright.terminal.TerminalFrameTitle;
import com.mindbright.terminal.TerminalWin;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class ModuleTelnetImpl
extends ModuleBaseTerminal {
    private String remoteHost;
    private int remotePort;
    private SSH2InternalChannel channel;
    private TelnetTerminalAdapter telnetAdapter;
    private InputStream telnetIn;
    private OutputStream telnetOut;
    private LineReaderTerminal lineReader;
    private boolean localConnect;
    private Socket socket;

    public void runTerminal(MindTermApp mindTermApp, TerminalWin terminalWin, Frame frame, TerminalFrameTitle terminalFrameTitle) {
        try {
            int n;
            this.remoteHost = mindTermApp.getProperty("module.telnet.host");
            this.remotePort = this.getPort(mindTermApp.getProperty("module.telnet.port"));
            this.localConnect = true;
            if (this.remoteHost == null) {
                if (!mindTermApp.isConnected() || mindTermApp.getConnection() == null) {
                    terminalWin.write("Not connected to ssh2 server, can only make direct connections.\r\n");
                } else {
                    terminalWin.write("Prefix hostname with '|' to make a tunneled connection.\r\n");
                }
                this.lineReader = new LineReaderTerminal(terminalWin);
                this.remoteHost = this.lineReader.promptLine("\r\nremote host[:port] : ", null, false);
                if (this.remoteHost.trim().length() == 0) {
                    return;
                }
                if (this.remoteHost.charAt(0) == '|') {
                    this.localConnect = false;
                    this.remoteHost = this.remoteHost.substring(1, this.remoteHost.length());
                }
                this.lineReader.detach();
            }
            if ((n = this.remoteHost.indexOf(58)) != -1) {
                this.remotePort = this.getPort(this.remoteHost.substring(n + 1));
                this.remoteHost = this.remoteHost.substring(0, n);
            }
            if (this.localConnect) {
                try {
                    this.socket = new Socket(this.remoteHost, this.remotePort);
                    this.telnetIn = this.socket.getInputStream();
                    this.telnetOut = this.socket.getOutputStream();
                }
                catch (Exception exception) {
                    mindTermApp.alert("Local connection failed: " + exception.getMessage());
                    return;
                }
            } else {
                this.channel = mindTermApp.getConnection().newLocalInternalForward(this.remoteHost, this.remotePort);
                if (this.channel.openStatus() != 1) {
                    mindTermApp.alert("Failed to open tunnel for telnet");
                    return;
                }
                this.telnetIn = this.channel.getInputStream();
                this.telnetOut = this.channel.getOutputStream();
            }
            terminalFrameTitle.setTitleName("telnet@" + this.remoteHost + (this.remotePort != 23 ? ":" + this.remotePort : ""));
            this.telnetAdapter = new ChaffedTelnet(this.telnetIn, this.telnetOut, terminalWin);
            if (this.useChaff()) {
                this.telnetAdapter.startChaff();
            }
            this.telnetAdapter.getTelnetNVT().getThread().join();
            if (this.telnetAdapter.isBuffered()) {
                this.lineReader = new LineReaderTerminal(terminalWin);
                this.lineReader.promptLine("\n\rTelnet session was closed, press <return> to close window", null, false);
            }
            this.telnetAdapter.stopChaff();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean closeOnDisconnect() {
        return !this.localConnect;
    }

    private int getPort(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 23;
        }
        return n;
    }

    public String getTitle() {
        return this.mindterm.getAppName() + " - " + "Telnet (not connected)";
    }

    public boolean isAvailable(MindTermApp mindTermApp) {
        return true;
    }

    protected boolean haveMenus() {
        return Boolean.valueOf(this.mindterm.getProperty("module.telnet.havemenus"));
    }

    public void doClose() {
        if (this.telnetOut != null) {
            try {
                this.telnetOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.telnetIn != null) {
            try {
                this.telnetIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.lineReader != null) {
            this.lineReader.breakPromptLine("");
        }
    }

    protected ModuleBaseTerminal newInstance() {
        return new ModuleTelnetImpl();
    }

    protected class ChaffedTelnet
    extends TelnetTerminalAdapter {
        public ChaffedTelnet(InputStream inputStream, OutputStream outputStream, Terminal terminal) {
            super(inputStream, outputStream, terminal);
        }

        protected void sendFakeChar() {
            if (ModuleTelnetImpl.this.channel != null) {
                byte[] byArray = new byte[]{1, 2, 3, 4, 5};
                ModuleTelnetImpl.this.channel.getConnection().getTransport().sendIgnore(byArray);
            }
        }
    }
}

