/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.application;

import com.mindbright.application.MindTermApp;
import com.mindbright.application.MindTermModule;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.ssh2.SSH2TelnetProxyListener;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ModuleTelnetProxy
implements MindTermModule,
ActionListener {
    private MindTermApp mindterm;
    private Dialog telnetDialog;
    private TextField proxyHost;
    private TextField proxyPort;
    private Label lblStatus;
    private Button startBut;
    private Button closeBut;
    private SSH2TelnetProxyListener telnetProxy;

    public void init(MindTermApp mindTermApp) {
        this.mindterm = mindTermApp;
    }

    public void activate(MindTermApp mindTermApp) {
        Object object;
        Object object2;
        if (this.telnetDialog == null) {
            this.telnetDialog = new Dialog(mindTermApp.getParentFrame(), mindTermApp.getAppName() + " - Telnet Proxy", false);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(this.telnetDialog);
            object2 = new Label("Listen address:");
            aWTGridBagContainer.add((Component)object2, 0, 1);
            object2 = new Label("Listen port:");
            aWTGridBagContainer.add((Component)object2, 0, 1);
            this.proxyHost = new TextField("127.0.0.1", 20);
            aWTGridBagContainer.add(this.proxyHost, 1, 1);
            this.proxyPort = new TextField("23", 5);
            aWTGridBagContainer.add(this.proxyPort, 1, 1);
            aWTGridBagContainer.getConstraints().anchor = 10;
            this.lblStatus = new Label("Proxy disabled...", 1);
            aWTGridBagContainer.add(this.lblStatus, 2, 2);
            object = new Panel(new FlowLayout());
            this.startBut = new Button("Enable");
            ((Container)object).add(this.startBut);
            this.startBut.addActionListener(this);
            this.closeBut = new Button("Close Dialog");
            ((Container)object).add(this.closeBut);
            this.closeBut.addActionListener(new AWTConvenience.CloseAction(this.telnetDialog));
            aWTGridBagContainer.add((Component)object, 3, 0);
            this.telnetDialog.addWindowListener(new AWTConvenience.CloseAdapter(this.closeBut));
            AWTConvenience.setBackgroundOfChildren(this.telnetDialog);
            AWTConvenience.setKeyListenerOfChildren(this.telnetDialog, new AWTConvenience.OKCancelAdapter(this.startBut, this.closeBut), null);
            this.telnetDialog.setResizable(true);
            this.telnetDialog.pack();
        }
        object2 = mindTermApp.getProperty("module.telnetproxy.host");
        object = mindTermApp.getProperty("module.telnetproxy.port");
        if (object2 != null && !((String)object2).equals("")) {
            this.proxyHost.setText((String)object2);
        }
        if (object != null && !((String)object).equals("")) {
            this.proxyPort.setText((String)object);
        }
        this.updateTelnetDialog(false);
        AWTConvenience.placeDialog(this.telnetDialog);
        ((Component)this.telnetDialog).setVisible(true);
    }

    public boolean isAvailable(MindTermApp mindTermApp) {
        return mindTermApp.isConnected() && mindTermApp.getConnection() != null;
    }

    public void connected(MindTermApp mindTermApp) {
        String string = mindTermApp.getProperty("module.telnetproxy.host");
        String string2 = mindTermApp.getProperty("module.telnetproxy.port");
        if (string != null && string.trim().length() > 0) {
            try {
                int n = Integer.parseInt(string2);
                this.telnetProxy = new SSH2TelnetProxyListener(string, n, mindTermApp.getConnection());
                mindTermApp.alert("Starting telnet proxy on " + string + ":" + n);
            }
            catch (Exception exception) {
                mindTermApp.alert("Error starting telnet proxy on " + string + ":" + string2 + " - " + exception.getMessage());
            }
        }
    }

    public void disconnected(MindTermApp mindTermApp) {
        if (this.telnetProxy != null) {
            this.telnetProxy.stop();
            this.telnetProxy = null;
        }
    }

    public String description(MindTermApp mindTermApp) {
        return null;
    }

    private void updateTelnetDialog(boolean bl) {
        if (this.telnetProxy == null) {
            if (!bl) {
                this.lblStatus.setText("Proxy disabled...");
            }
            this.proxyPort.setEnabled(true);
            this.proxyHost.setEnabled(true);
            this.startBut.setLabel("Enable");
        } else {
            if (!bl) {
                this.lblStatus.setText("Proxy running: " + this.proxyHost.getText() + ":" + this.proxyPort.getText());
            }
            this.proxyPort.setEnabled(false);
            this.proxyHost.setEnabled(false);
            this.startBut.setLabel("Disable");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.telnetProxy != null) {
            this.startBut.setLabel("Enable");
            this.disconnected(this.mindterm);
            this.updateTelnetDialog(false);
            this.mindterm.setProperty("module.telnetproxy.host", "");
            this.mindterm.setProperty("module.telnetproxy.port", "");
        } else {
            boolean bl = false;
            this.lblStatus.setText("");
            try {
                String string = this.proxyHost.getText();
                String string2 = this.proxyPort.getText();
                this.mindterm.setProperty("module.telnetproxy.host", string);
                this.mindterm.setProperty("module.telnetproxy.port", string2);
                this.connected(this.mindterm);
            }
            catch (Exception exception) {
                bl = true;
                this.disconnected(this.mindterm);
                this.lblStatus.setText("Error: " + exception.getMessage());
            }
            this.updateTelnetDialog(bl);
        }
    }
}

