/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.asn1;

import com.mindbright.asn1.ASN1Decoder;
import com.mindbright.asn1.ASN1Encoder;
import com.mindbright.asn1.ASN1Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1DynamicType
extends ASN1Object {
    protected ASN1Object value;

    protected ASN1DynamicType() {
        super(0);
    }

    public final void setValue(ASN1Object aSN1Object) {
        this.value = aSN1Object;
        this.tag = aSN1Object.getTag();
        this.setValue();
    }

    public final ASN1Object getValue() {
        return this.value;
    }

    public String getType() {
        if (this.value != null) {
            return this.value.getType();
        }
        return "Unbound dynamic type";
    }

    public void setValue() {
        super.setValue();
        if (this.value != null) {
            this.value.setValue();
        }
    }

    public int encodeValue(ASN1Encoder aSN1Encoder, OutputStream outputStream) throws IOException {
        if (this.value == null) {
            throw new IOException("Value of " + this.getType() + " not set");
        }
        return this.value.encodeValue(aSN1Encoder, outputStream);
    }

    public void decodeValue(ASN1Decoder aSN1Decoder, InputStream inputStream, int n, int n2) throws IOException {
        ASN1Object aSN1Object = this.bindType(n);
        this.setValue(aSN1Object);
        aSN1Decoder.decodeValue(inputStream, aSN1Object.tag != 0 ? aSN1Object.tag : n, n2, aSN1Object);
    }

    protected abstract ASN1Object bindType(int var1) throws IOException;
}

