/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.asn1;

import com.mindbright.asn1.ASN1Decoder;
import com.mindbright.asn1.ASN1Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1Object {
    protected int tag;
    protected boolean isSet;

    protected ASN1Object(int n) {
        this.tag = n;
    }

    public final int getTag() {
        return this.tag;
    }

    public String getType() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void setValue() {
        this.isSet = true;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void decodeValue(ASN1Decoder aSN1Decoder, InputStream inputStream, int n, int n2) throws IOException {
        if (n != this.tag) {
            throw new IOException("Invalid encoding, tag mismatch when decoding " + this.getType() + " (expected: " + this.tag + ", got: " + n + ")");
        }
        this.decodeValue(aSN1Decoder, inputStream, n2);
    }

    protected void decodeValue(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        throw new IOException("ASN1 decoder " + aSN1Decoder + " couldn't decode " + this.getType());
    }

    public abstract int encodeValue(ASN1Encoder var1, OutputStream var2) throws IOException;
}

