/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.gui;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.List;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public abstract class AWTConvenience {
    public static final void placeDialog(Dialog dialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = dialog.getSize();
        int n = dimension.width / 2 - dimension2.width / 2;
        int n2 = dimension.height / 2 - dimension2.height / 2;
        ((Component)dialog).setLocation(n, n2);
    }

    public static final void setBackgroundOfChildren(Container container) {
        Component[] componentArray = container.getComponents();
        container.setBackground(SystemColor.menu);
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Choice) continue;
            componentArray[i].setBackground(SystemColor.menu);
            if (componentArray[i] instanceof Container) {
                AWTConvenience.setBackgroundOfChildren((Container)componentArray[i]);
                continue;
            }
            if (componentArray[i] instanceof Choice) continue;
            if (componentArray[i] instanceof TextField || componentArray[i] instanceof List) {
                componentArray[i].setBackground(SystemColor.text);
                continue;
            }
            componentArray[i].setBackground(SystemColor.menu);
        }
    }

    public static final void setKeyListenerOfChildren(Container container, KeyListener keyListener, Class clazz) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Choice) continue;
            if (componentArray[i] instanceof Container) {
                AWTConvenience.setKeyListenerOfChildren((Container)componentArray[i], keyListener, clazz);
                continue;
            }
            if (componentArray[i] == null || clazz != null && !clazz.isInstance(componentArray[i])) continue;
            componentArray[i].addKeyListener(keyListener);
        }
    }

    public static final Choice newChoice(String[] stringArray) {
        Choice choice = new Choice();
        for (int i = 0; i < stringArray.length; ++i) {
            choice.add(stringArray[i]);
        }
        return choice;
    }

    public static final Frame newFrameWithMenuBar() {
        MenuBar menuBar = new MenuBar();
        Frame frame = new Frame();
        frame.setMenuBar(menuBar);
        frame.addNotify();
        frame.validate();
        return frame;
    }

    public static class OKCancelAdapter
    extends KeyAdapter {
        protected static boolean isMRJ = false;
        Button butOK;
        Button butCancel;

        public OKCancelAdapter(Button button, Button button2) {
            this.butOK = button;
            this.butCancel = button2;
        }

        protected void pushButton(Button button) {
            if (isMRJ) {
                button.dispatchEvent(new KeyEvent(button, 401, System.currentTimeMillis(), 0, 10, '\n'));
            } else {
                button.dispatchEvent(new ActionEvent(button, 1001, button.getActionCommand()));
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    if (this.butOK == null) break;
                    this.pushButton(this.butOK);
                    break;
                }
                case 27: {
                    if (this.butCancel == null) break;
                    this.pushButton(this.butCancel);
                }
            }
        }

        static {
            try {
                isMRJ = System.getProperty("mrj.version") != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class CloseAdapter
    extends WindowAdapter {
        Object source;
        String action;

        public CloseAdapter(MenuItem menuItem) {
            this(menuItem, menuItem.getLabel());
        }

        public CloseAdapter(Button button) {
            this(button, button.getActionCommand());
        }

        private CloseAdapter(Object object, String string) {
            this.source = object;
            this.action = string;
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (this.source instanceof Component) {
                ((Component)this.source).dispatchEvent(new ActionEvent(this.source, 1001, this.action));
            } else if (this.source instanceof MenuComponent) {
                ((MenuComponent)this.source).dispatchEvent(new ActionEvent(this.source, 1001, this.action));
            }
        }
    }

    public static class CloseAction
    implements ActionListener {
        Dialog dialog;

        public CloseAction(Dialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)this.dialog).setVisible(false);
        }
    }
}

