/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jca.security;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.KeyFactorySpi;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.spec.InvalidKeySpecException;
import com.mindbright.jca.security.spec.KeySpec;

public class KeyFactory {
    private KeyFactorySpi keyFactorySpi;
    private Provider provider;
    private String algorithm;

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String string) {
        this.keyFactorySpi = keyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("KeyFactory", string);
            return KeyFactory.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static KeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("KeyFactory", string, string2);
        return new KeyFactory((KeyFactorySpi)providerLookup.getImpl(), providerLookup.getProvider(), string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFactorySpi.engineGeneratePublic(keySpec);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFactorySpi.engineGeneratePrivate(keySpec);
    }

    public final KeySpec getKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return this.keyFactorySpi.engineGetKeySpec(key, clazz);
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.keyFactorySpi.engineTranslateKey(key);
    }
}

