/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class RFC822Head {
    Hashtable fields = new Hashtable();

    public RFC822Head() {
    }

    public RFC822Head(String string) throws IOException {
        this(new ByteArrayInputStream(string.getBytes()));
    }

    public RFC822Head(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while (true) {
            if ((n = inputStream.read()) == -1) {
                throw new IOException("RFC822Head: corrupt header, input stream closed");
            }
            if (n == 10) continue;
            if (n != 13) {
                stringBuffer.append((char)n);
                continue;
            }
            if (stringBuffer.length() == 0) break;
            String string2 = stringBuffer.toString();
            string = this.processLine(string2, string);
            stringBuffer.setLength(0);
        }
        n = inputStream.read();
    }

    private final String processLine(String string, String string2) throws IOException {
        String string3;
        String string4;
        char c = string.charAt(0);
        if (c == ' ' || c == '\t') {
            string4 = string2;
            string3 = this.getHeaderField(string2) + " " + string.trim();
        } else {
            int n = string.indexOf(58);
            if (n == -1) {
                throw new IOException("RFC822Head: corrupt header-field: '" + string + "'");
            }
            string4 = string.substring(0, n).toLowerCase();
            string3 = string.substring(n + 1).trim();
        }
        this.setHeaderField(string4, string3);
        return string4;
    }

    public Hashtable getHeaderFields() {
        return this.fields;
    }

    public Enumeration getHeaderFieldNames() {
        return this.fields.keys();
    }

    public String getHeaderField(String string) {
        return (String)this.fields.get(string.toLowerCase());
    }

    public void setHeaderField(String string, String string2) {
        this.fields.put(string.toLowerCase(), string2);
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.fields.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2 + ": " + this.fields.get(string2) + "\r\n";
        }
        string = string + "\r\n";
        return string;
    }

    public static String extractParamValue(String string, String string2) {
        int n = string.indexOf(string2);
        String string3 = null;
        if (n != -1 && (n = (string = string.substring(n + string2.length())).indexOf(61)) != -1) {
            if ((n = (string = string.substring(n + 1)).indexOf(59)) != -1) {
                string = string.substring(0, n);
            }
            if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            string3 = string;
        }
        return string3;
    }
}

