/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.cipher;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.security.cipher.BlockCipher;
import com.mindbright.security.cipher.DES;

public final class DES3
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private DES des1 = new DES();
    private DES des2 = new DES();
    private DES des3 = new DES();

    public int getBlockSize() {
        return 8;
    }

    public synchronized void initializeKey(byte[] byArray) throws InvalidKeyException {
        if (byArray.length < 24) {
            throw new InvalidKeyException("Key too short for 3des");
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        this.des1.initializeKey(byArray2);
        System.arraycopy(byArray, 8, byArray2, 0, 8);
        this.des2.initializeKey(byArray2);
        System.arraycopy(byArray, 16, byArray2, 0, 8);
        this.des3.initializeKey(byArray2);
    }

    public void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int[] nArray = new int[]{BlockCipher.getIntLSBO(byArray, n), BlockCipher.getIntLSBO(byArray, n + 4)};
        DES.initPerm(nArray);
        int n4 = nArray[1] << 1 | nArray[1] >>> 31;
        nArray[1] = nArray[0] << 1 | nArray[0] >>> 31;
        nArray[0] = n4;
        for (n3 = 0; n3 < 32; n3 += 4) {
            this.des1.desCipher1(nArray, n3);
            this.des1.desCipher2(nArray, n3 + 2);
        }
        for (n3 = 30; n3 > 0; n3 -= 4) {
            this.des2.desCipher2(nArray, n3);
            this.des2.desCipher1(nArray, n3 - 2);
        }
        for (n3 = 0; n3 < 32; n3 += 4) {
            this.des3.desCipher1(nArray, n3);
            this.des3.desCipher2(nArray, n3 + 2);
        }
        nArray[0] = nArray[0] >>> 1 | nArray[0] << 31;
        nArray[1] = nArray[1] >>> 1 | nArray[1] << 31;
        DES.finalPerm(nArray);
        BlockCipher.putIntLSBO(nArray[0], byArray2, n2);
        BlockCipher.putIntLSBO(nArray[1], byArray2, n2 + 4);
    }

    public void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int[] nArray = new int[]{BlockCipher.getIntLSBO(byArray, n), BlockCipher.getIntLSBO(byArray, n + 4)};
        DES.initPerm(nArray);
        int n4 = nArray[1] << 1 | nArray[1] >>> 31;
        nArray[1] = nArray[0] << 1 | nArray[0] >>> 31;
        nArray[0] = n4;
        for (n3 = 30; n3 > 0; n3 -= 4) {
            this.des3.desCipher1(nArray, n3);
            this.des3.desCipher2(nArray, n3 - 2);
        }
        for (n3 = 0; n3 < 32; n3 += 4) {
            this.des2.desCipher2(nArray, n3);
            this.des2.desCipher1(nArray, n3 + 2);
        }
        for (n3 = 30; n3 > 0; n3 -= 4) {
            this.des1.desCipher1(nArray, n3);
            this.des1.desCipher2(nArray, n3 - 2);
        }
        nArray[0] = nArray[0] >>> 1 | nArray[0] << 31;
        nArray[1] = nArray[1] >>> 1 | nArray[1] << 31;
        DES.finalPerm(nArray);
        BlockCipher.putIntLSBO(nArray[0], byArray2, n2);
        BlockCipher.putIntLSBO(nArray[1], byArray2, n2 + 4);
    }
}

