/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.keystore;

import com.mindbright.asn1.ASN1DER;
import com.mindbright.asn1.ASN1OIDRegistry;
import com.mindbright.bdb.DBHash;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.KeyStoreException;
import com.mindbright.jca.security.KeyStoreSpi;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.UnrecoverableKeyException;
import com.mindbright.jca.security.cert.Certificate;
import com.mindbright.jca.security.cert.CertificateException;
import com.mindbright.jca.security.interfaces.DSAPublicKey;
import com.mindbright.jca.security.interfaces.RSAPublicKey;
import com.mindbright.jce.crypto.Cipher;
import com.mindbright.jce.crypto.Mac;
import com.mindbright.jce.crypto.ShortBufferException;
import com.mindbright.jce.crypto.spec.IvParameterSpec;
import com.mindbright.jce.crypto.spec.SecretKeySpec;
import com.mindbright.security.keystore.PKCS12KeyStore;
import com.mindbright.security.pkcs8.EncryptedPrivateKeyInfo;
import com.mindbright.security.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class NetscapeKeyStore
extends KeyStoreSpi {
    public static final int TYPE_VERSION = 0;
    public static final int TYPE_CERTIFICATE = 1;
    public static final int TYPE_NICKNAME = 2;
    public static final int TYPE_SUBJECT = 3;
    public static final int TYPE_REVOCATION = 4;
    public static final int TYPE_KEYREVOCATION = 5;
    public static final int TYPE_SMIMEPROFILE = 6;
    public static final int TYPE_CONTENTVER = 7;
    private static final String[] CERT_FILES = new String[]{"cert8.db", "cert7.db", "Certificates8", "Certificates7"};
    private static final String[] KEY_FILES = new String[]{"key3.db", "Key Database3"};
    private DBHash certdb;
    private DBHash keydb;
    private Hashtable certificates;

    public NetscapeKeyStore() {
        ASN1OIDRegistry.addModule("com.mindbright.security.pkcs12");
        ASN1OIDRegistry.register("1.2.840.113549.1.12.5.1.3", "com.mindbright.security.pkcs12.PKCS12PbeParams");
        this.certdb = new DBHash();
        this.keydb = new DBHash();
        this.certificates = new Hashtable();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyEntry keyEntry = this.getKeyEntry(string);
        if (!this.passwordCheck(cArray)) {
            throw new UnrecoverableKeyException("Invalid password");
        }
        if (keyEntry != null) {
            try {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo();
                ASN1DER aSN1DER = new ASN1DER();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(keyEntry.encryptedKey);
                aSN1DER.decode(byteArrayInputStream, encryptedPrivateKeyInfo);
                byte[] byArray = encryptedPrivateKeyInfo.encryptedData.getRaw();
                byte[] byArray2 = new byte[byArray.length];
                NetscapeKeyStore.do3DESCipher(1, cArray, byArray, 0, byArray.length, byArray2, this.globalSalt(), keyEntry.salt);
                byteArrayInputStream = new ByteArrayInputStream(byArray2);
                return PKCS12KeyStore.extractPrivateKey(byArray2);
            }
            catch (IOException iOException) {
                throw new UnrecoverableKeyException(iOException.getMessage());
            }
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        CertEntry certEntry = (CertEntry)this.certificates.get(string);
        if (certEntry != null) {
            return new X509Certificate(certEntry.certificate);
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        return null;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
    }

    public Enumeration engineAliases() {
        return this.certificates.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.certificates.get(string) != null;
    }

    public int engineSize() {
        return this.certificates.size();
    }

    public boolean engineIsKeyEntry(String string) {
        return this.getKeyEntry(string) != null;
    }

    public boolean engineIsCertificateEntry(String string) {
        return !this.engineIsKeyEntry(string) && this.certificates.get(string) != null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        int n;
        if (!(inputStream instanceof ByteArrayInputStream)) {
            throw new IOException("Parameter 'stream' must be a ByteArrayInputStream");
        }
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        String string = new String(byArray);
        String string2 = null;
        String string3 = null;
        for (n = 0; n < CERT_FILES.length; ++n) {
            if (!new File(string + File.separator + CERT_FILES[n]).exists()) continue;
            string2 = CERT_FILES[n];
            break;
        }
        for (n = 0; n < KEY_FILES.length; ++n) {
            if (!new File(string + File.separator + KEY_FILES[n]).exists()) continue;
            string3 = KEY_FILES[n];
            break;
        }
        this.certdb.loadAll(string + File.separator + string2);
        this.keydb.loadAll(string + File.separator + string3);
        Enumeration enumeration = this.certdb.keys();
        while (enumeration.hasMoreElements()) {
            DBHash.DBT dBT = (DBHash.DBT)enumeration.nextElement();
            if (dBT.key[0] != 1) continue;
            CertEntry certEntry = new CertEntry(dBT.data);
            this.certificates.put(certEntry.nickName, certEntry);
        }
        if (!this.passwordCheck(cArray)) {
            throw new IOException("Invalid password");
        }
    }

    private KeyEntry getKeyEntry(String string) {
        Certificate certificate = this.engineGetCertificate(string);
        KeyEntry keyEntry = null;
        if (certificate != null) {
            Object object;
            PublicKey publicKey = certificate.getPublicKey();
            byte[] byArray = null;
            if (publicKey instanceof RSAPublicKey) {
                object = (RSAPublicKey)publicKey;
                byArray = object.getModulus().toByteArray();
            } else if (publicKey instanceof DSAPublicKey) {
                object = (DSAPublicKey)publicKey;
                byArray = object.getY().toByteArray();
            }
            object = this.keydb.get(byArray);
            if (object == null && byArray != null && byArray[0] == 0) {
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                object = this.keydb.get(byArray2);
            }
            if (object != null) {
                keyEntry = new KeyEntry((byte[])object);
            }
        }
        return keyEntry;
    }

    private static byte[] deriveKey(char[] cArray, byte[] byArray, byte[] byArray2) throws InvalidKeyException, NoSuchAlgorithmException, ShortBufferException {
        Mac mac = Mac.getInstance("HmacSHA1");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        byte[] byArray3 = new byte[40];
        byte[] byArray4 = new byte[cArray.length];
        for (int i = 0; i < byArray4.length; ++i) {
            byArray4[i] = (byte)cArray[i];
        }
        messageDigest.update(byArray);
        messageDigest.update(byArray4);
        byte[] byArray5 = messageDigest.digest();
        byte[] byArray6 = new byte[20];
        System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
        messageDigest.update(byArray5);
        messageDigest.update(byArray2);
        byte[] byArray7 = messageDigest.digest();
        mac.init(new SecretKeySpec(byArray7, mac.getAlgorithm()));
        mac.update(byArray6);
        mac.update(byArray2);
        mac.doFinal(byArray3, 0);
        mac.update(byArray6);
        byte[] byArray8 = mac.doFinal();
        mac.update(byArray8);
        mac.update(byArray2);
        mac.doFinal(byArray3, 20);
        return byArray3;
    }

    private static void do3DESCipher(int n, char[] cArray, byte[] byArray, int n2, int n3, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws NoSuchAlgorithmException {
        try {
            Cipher cipher = Cipher.getInstance("3DES/CBC/PKCS5Padding");
            byte[] byArray5 = NetscapeKeyStore.deriveKey(cArray, byArray3, byArray4);
            byte[] byArray6 = new byte[24];
            byte[] byArray7 = new byte[8];
            System.arraycopy(byArray5, 0, byArray6, 0, 24);
            System.arraycopy(byArray5, 32, byArray7, 0, 8);
            cipher.init(n, new SecretKeySpec(byArray6, cipher.getAlgorithm()), new IvParameterSpec(byArray7));
            cipher.doFinal(byArray, n2, n3, byArray2, 0);
        }
        catch (Exception exception) {
            throw new Error("Error in NetscapeKeyStore.do3DESCipher: " + exception);
        }
    }

    private byte[] globalSalt() {
        return this.keydb.get("global-salt");
    }

    private boolean passwordCheck(char[] cArray) throws NoSuchAlgorithmException {
        if (cArray == null) {
            return true;
        }
        byte[] byArray = this.keydb.get("password-check");
        if (byArray == null) {
            return true;
        }
        KeyEntry keyEntry = new KeyEntry(byArray);
        if (keyEntry == null) {
            return true;
        }
        int n = keyEntry.encryptedKey.length - 16;
        byte[] byArray2 = new byte[16];
        NetscapeKeyStore.do3DESCipher(1, cArray, keyEntry.encryptedKey, n, 16, byArray2, this.globalSalt(), keyEntry.salt);
        return "password-check".equals(new String(byArray2, 0, 14));
    }

    public class KeyEntry
    extends DBEntry {
        public byte[] salt;
        public String nickName;
        public byte[] encryptedKey;

        public KeyEntry(byte[] byArray) {
            super(byArray);
            this.salt = this.readRaw(this.version);
            this.nickName = new String(this.readRaw(this.flags - 1));
            ++this.rPos;
            this.encryptedKey = this.readRaw(byArray.length - this.rPos);
        }
    }

    public class CertEntry
    extends DBEntry {
        public int sslFlags = this.readShort();
        public int emailFlags = this.readShort();
        public int oSignFlags = this.readShort();
        public byte[] certificate;
        public String nickName;

        public CertEntry(byte[] byArray) {
            super(byArray);
            int n = this.readShort();
            int n2 = this.readShort();
            this.certificate = this.readRaw(n);
            this.nickName = new String(this.readRaw(n2 - 1));
        }
    }

    public class DBEntry {
        protected byte[] data;
        public int type;
        public int version;
        public int flags;
        protected int rPos;

        protected DBEntry(byte[] byArray) {
            this.data = byArray;
            this.rPos = 0;
            this.type = this.readByte();
            this.version = this.readByte();
            this.flags = this.readByte();
        }

        public final int readByte() {
            return this.data[this.rPos++] & 0xFF;
        }

        public final int readShort() {
            int n = this.readByte();
            int n2 = this.readByte();
            return (n << 8) + (n2 << 0);
        }

        public final byte[] readRaw(int n) {
            byte[] byArray = new byte[n];
            this.readRaw(byArray, 0, n);
            return byArray;
        }

        public final void readRaw(byte[] byArray, int n, int n2) {
            System.arraycopy(this.data, this.rPos, byArray, n, n2);
            this.rPos += n2;
        }
    }
}

