/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.keystore;

import com.mindbright.asn1.ASN1CharString;
import com.mindbright.asn1.ASN1DER;
import com.mindbright.asn1.ASN1Integer;
import com.mindbright.asn1.ASN1OIDRegistry;
import com.mindbright.asn1.ASN1Object;
import com.mindbright.asn1.ASN1OctetString;
import com.mindbright.asn1.ASN1Sequence;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.KeyFactory;
import com.mindbright.jca.security.KeyStoreException;
import com.mindbright.jca.security.KeyStoreSpi;
import com.mindbright.jca.security.MessageDigest;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.UnrecoverableKeyException;
import com.mindbright.jca.security.cert.Certificate;
import com.mindbright.jca.security.cert.CertificateException;
import com.mindbright.jca.security.spec.DSAPrivateKeySpec;
import com.mindbright.jca.security.spec.RSAPrivateCrtKeySpec;
import com.mindbright.jce.crypto.Cipher;
import com.mindbright.jce.crypto.Mac;
import com.mindbright.jce.crypto.spec.IvParameterSpec;
import com.mindbright.jce.crypto.spec.SecretKeySpec;
import com.mindbright.security.pkcs1.DSAParams;
import com.mindbright.security.pkcs1.RSAPrivateKey;
import com.mindbright.security.pkcs12.AuthenticatedSafe;
import com.mindbright.security.pkcs12.CertBag;
import com.mindbright.security.pkcs12.PFX;
import com.mindbright.security.pkcs12.PKCS12PbeParams;
import com.mindbright.security.pkcs12.SafeBag;
import com.mindbright.security.pkcs12.SafeContents;
import com.mindbright.security.pkcs7.ContentInfo;
import com.mindbright.security.pkcs7.EncryptedData;
import com.mindbright.security.pkcs8.EncryptedPrivateKeyInfo;
import com.mindbright.security.pkcs8.PrivateKeyInfo;
import com.mindbright.security.x509.Attribute;
import com.mindbright.security.x509.X509Certificate;
import com.mindbright.util.HexDump;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PKCS12KeyStore
extends KeyStoreSpi {
    private Hashtable privateKeys;
    private Hashtable certificates;
    private Hashtable name2id;
    private Vector aliases;

    public PKCS12KeyStore() {
        ASN1OIDRegistry.addModule("com.mindbright.security.pkcs12");
        ASN1OIDRegistry.register("1.3.6.1.4.1.311.17.1", "ASN1BMPString");
        this.privateKeys = new Hashtable();
        this.certificates = new Hashtable();
        this.aliases = new Vector();
        this.name2id = new Hashtable();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = (String)this.name2id.get(string);
        if (string2 == null) {
            return null;
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (EncryptedPrivateKeyInfo)this.privateKeys.get(string2);
        return PKCS12KeyStore.extractPrivateKey(encryptedPrivateKeyInfo, cArray);
    }

    public Certificate[] engineGetCertificateChain(String string) {
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            return null;
        }
        X509Certificate x509Certificate = null;
        byte[] byArray = null;
        String string2 = (String)this.name2id.get(string);
        if (string2 == null) {
            string2 = string;
        }
        if ((byArray = (byte[])this.certificates.get(string2)) != null) {
            x509Certificate = new X509Certificate(byArray);
        }
        return x509Certificate;
    }

    public Date engineGetCreationDate(String string) {
        return null;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
    }

    public Enumeration engineAliases() {
        return this.aliases.elements();
    }

    public boolean engineContainsAlias(String string) {
        return this.aliases.contains(string);
    }

    public int engineSize() {
        return this.aliases.size();
    }

    public boolean engineIsKeyEntry(String string) {
        return this.name2id.get(string) != null;
    }

    public boolean engineIsCertificateEntry(String string) {
        return !this.engineIsKeyEntry(string) && this.certificates.get(string) != null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            ASN1DER aSN1DER = new ASN1DER();
            PFX pFX = new PFX();
            aSN1DER.decode(inputStream, pFX);
            this.checkMac(pFX, cArray);
            AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe();
            ASN1OctetString aSN1OctetString = pFX.getDataContent();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aSN1OctetString.getRaw());
            aSN1DER.decode(byteArrayInputStream, authenticatedSafe);
            for (int i = 0; i < authenticatedSafe.getCount(); ++i) {
                ContentInfo contentInfo = authenticatedSafe.getContentInfo(i);
                String string = contentInfo.contentType.getString();
                if (string.equals("1.2.840.113549.1.7.1")) {
                    aSN1OctetString = (ASN1OctetString)contentInfo.content.getValue();
                    this.processSafeContents(aSN1OctetString.getRaw());
                    continue;
                }
                if (string.equals("1.2.840.113549.1.7.6")) {
                    EncryptedData encryptedData = (EncryptedData)contentInfo.content.getValue();
                    String string2 = encryptedData.encryptedContentInfo.contentEncryptionAlgorithm.algorithmName();
                    byte[] byArray = encryptedData.encryptedContentInfo.encryptedContent.getRaw();
                    PKCS12PbeParams pKCS12PbeParams = (PKCS12PbeParams)encryptedData.encryptedContentInfo.contentEncryptionAlgorithm.parameters.getValue();
                    byte[] byArray2 = pKCS12PbeParams.salt.getRaw();
                    int n = pKCS12PbeParams.iterations.getValue().intValue();
                    byte[] byArray3 = new byte[byArray.length];
                    PKCS12KeyStore.doCipher(1, cArray, byArray, byArray.length, byArray3, byArray2, n, string2);
                    this.processSafeContents(byArray3);
                    continue;
                }
                throw new IOException("ContentInfo type not supported: " + string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    private void checkMac(PFX pFX, char[] cArray) throws CertificateException {
        if (!pFX.macData.isSet()) {
            return;
        }
        try {
            String string = pFX.macData.mac.digestAlgorithm.algorithm.getString();
            Mac mac = Mac.getInstance(string);
            byte[] byArray = pFX.getDataContent().getRaw();
            byte[] byArray2 = pFX.macData.mac.digest.getRaw();
            byte[] byArray3 = pFX.macData.macSalt.getRaw();
            int n = pFX.macData.getIterations();
            byte[] byArray4 = PKCS12KeyStore.deriveKey(cArray, 20, byArray3, n, 3, string);
            mac.init(new SecretKeySpec(byArray4, mac.getAlgorithm()));
            mac.update(byArray);
            byte[] byArray5 = mac.doFinal();
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray5[i] == byArray2[i]) continue;
                throw new CertificateException("MAC check failed");
            }
        }
        catch (Exception exception) {
            throw new CertificateException("Error when verifying MAC: " + exception.getMessage());
        }
    }

    private void processSafeContents(byte[] byArray) throws IOException, NoSuchAlgorithmException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SafeContents safeContents = new SafeContents();
        ASN1DER aSN1DER = new ASN1DER();
        aSN1DER.decode(byteArrayInputStream, safeContents);
        block4: for (int i = 0; i < safeContents.getCount(); ++i) {
            SafeBag safeBag = safeContents.getSafeBag(i);
            String string = this.getAttribute(safeBag, "1.2.840.113549.1.9.20");
            String string2 = this.getAttribute(safeBag, "1.2.840.113549.1.9.21");
            if (string != null) {
                if (string2 != null) {
                    this.name2id.put(string, string2);
                }
                if (!this.aliases.contains(string)) {
                    this.aliases.addElement(string);
                }
            } else if (string2 != null) {
                this.name2id.put(string2, string2);
                if (!this.aliases.contains(string2)) {
                    this.aliases.addElement(string2);
                }
            }
            switch (safeBag.getBagType()) {
                case 2: {
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (EncryptedPrivateKeyInfo)safeBag.bagValue.getValue();
                    this.privateKeys.put(string2, encryptedPrivateKeyInfo);
                    continue block4;
                }
                case 3: {
                    CertBag certBag = (CertBag)safeBag.bagValue.getValue();
                    byte[] byArray2 = ((ASN1OctetString)certBag.certValue.getValue()).getRaw();
                    if (string2 == null) {
                        string2 = string;
                    }
                    if (string2 == null) continue block4;
                    this.certificates.put(string2, byArray2);
                    continue block4;
                }
                default: {
                    throw new IOException("SafeBag type not supported: " + safeBag.bagId.getString());
                }
            }
        }
    }

    private static PrivateKey extractPrivateKey(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1DER aSN1DER = new ASN1DER();
        PKCS12PbeParams pKCS12PbeParams = (PKCS12PbeParams)encryptedPrivateKeyInfo.encryptionAlgorithm.parameters.getValue();
        String string = encryptedPrivateKeyInfo.encryptionAlgorithm.algorithmName();
        byte[] byArray = encryptedPrivateKeyInfo.encryptedData.getRaw();
        byte[] byArray2 = pKCS12PbeParams.salt.getRaw();
        int n = pKCS12PbeParams.iterations.getValue().intValue();
        byte[] byArray3 = new byte[byArray.length];
        PKCS12KeyStore.doCipher(1, cArray, byArray, byArray.length, byArray3, byArray2, n, string);
        return PKCS12KeyStore.extractPrivateKey(byArray3);
    }

    public static PrivateKey extractPrivateKey(byte[] byArray) throws UnrecoverableKeyException {
        ASN1DER aSN1DER = new ASN1DER();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo();
        try {
            ASN1Object aSN1Object;
            Object object;
            aSN1DER.decode(byteArrayInputStream, privateKeyInfo);
            boolean bl = true;
            try {
                object = privateKeyInfo.privateKeyAlgorithm.algorithmName().toLowerCase();
                if (((String)object).indexOf("dsa") >= 0) {
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            byteArrayInputStream = new ByteArrayInputStream(privateKeyInfo.privateKey.getRaw());
            if (bl) {
                object = new RSAPrivateKey();
                aSN1DER.decode(byteArrayInputStream, (ASN1Object)object);
                BigInteger bigInteger = ((RSAPrivateKey)object).modulus.getValue();
                BigInteger bigInteger2 = ((RSAPrivateKey)object).publicExponent.getValue();
                BigInteger bigInteger3 = ((RSAPrivateKey)object).privateExponent.getValue();
                BigInteger bigInteger4 = ((RSAPrivateKey)object).prime1.getValue();
                BigInteger bigInteger5 = ((RSAPrivateKey)object).prime2.getValue();
                BigInteger bigInteger6 = ((RSAPrivateKey)object).exponent1.getValue();
                BigInteger bigInteger7 = ((RSAPrivateKey)object).exponent2.getValue();
                BigInteger bigInteger8 = ((RSAPrivateKey)object).coefficient.getValue();
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
            }
            object = null;
            try {
                aSN1Object = new ASN1Integer();
                aSN1DER.decode(byteArrayInputStream, aSN1Object);
                object = aSN1Object.getValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (object == null) {
                aSN1Object = new DSAyx();
                aSN1DER.decode(new ByteArrayInputStream(privateKeyInfo.privateKey.getRaw()), aSN1Object);
                object = ((DSAyx)aSN1Object).x.getValue();
            }
            aSN1Object = (DSAParams)privateKeyInfo.privateKeyAlgorithm.parameters.getValue();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec((BigInteger)object, ((DSAParams)aSN1Object).p.getValue(), ((DSAParams)aSN1Object).q.getValue(), ((DSAParams)aSN1Object).g.getValue());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePrivate(dSAPrivateKeySpec);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
    }

    private String getAttribute(SafeBag safeBag, String string) {
        int n = safeBag.bagAttributes.getCount();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)safeBag.bagAttributes.getComponent(i);
            if (!string.equals(attribute.type.getString())) continue;
            ASN1Object aSN1Object = attribute.values.getComponent(0);
            string2 = aSN1Object instanceof ASN1CharString ? ((ASN1CharString)aSN1Object).getValue() : (aSN1Object instanceof ASN1OctetString ? HexDump.toString(((ASN1OctetString)aSN1Object).getRaw()) : aSN1Object.toString());
        }
        return string2;
    }

    private static byte[] deriveKey(char[] cArray, int n, byte[] byArray, int n2, int n3, String string) {
        try {
            int n4;
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            int n5 = messageDigest.getDigestLength();
            byte[] byArray2 = new byte[n5];
            byte[] byArray3 = new byte[n];
            int n6 = 64;
            byte[] byArray4 = new byte[cArray.length * 2 + 2];
            int n7 = (byArray.length + n6 - 1) / n6 * n6;
            int n8 = (byArray4.length + n6 - 1) / n6 * n6;
            byte[] byArray5 = new byte[n6];
            byte[] byArray6 = new byte[n7 + n8];
            byte[] byArray7 = new byte[n6];
            for (n4 = 0; n4 < cArray.length; ++n4) {
                byArray4[n4 * 2] = (byte)(cArray[n4] >>> 8);
                byArray4[n4 * 2 + 1] = (byte)(cArray[n4] & 0xFF);
            }
            for (n4 = 0; n4 < n6; ++n4) {
                byArray5[n4] = (byte)n3;
            }
            for (n4 = 0; n4 < n7; ++n4) {
                byArray6[n4] = byArray[n4 % byArray.length];
            }
            for (n4 = 0; n4 < n8; ++n4) {
                byArray6[n7 + n4] = byArray4[n4 % byArray4.length];
            }
            int n9 = 0;
            BigInteger bigInteger = BigInteger.valueOf(1L);
            byte[] byArray8 = new byte[n6];
            block6: while (true) {
                messageDigest.update(byArray5);
                messageDigest.update(byArray6);
                messageDigest.digest(byArray2, 0, n5);
                for (n4 = 1; n4 < n2; ++n4) {
                    messageDigest.update(byArray2);
                    messageDigest.digest(byArray2, 0, n5);
                }
                int n10 = n5 > n - n9 ? n - n9 : n5;
                System.arraycopy(byArray2, 0, byArray3, n9, n10);
                if ((n9 += n10) >= n) break;
                for (n4 = 0; n4 < n6; ++n4) {
                    byArray7[n4] = byArray2[n4 % n5];
                }
                BigInteger bigInteger2 = new BigInteger(1, byArray7).add(bigInteger);
                n4 = 0;
                while (true) {
                    if (n4 >= byArray6.length) continue block6;
                    System.arraycopy(byArray6, n4, byArray8, 0, n6);
                    BigInteger bigInteger3 = new BigInteger(1, byArray8);
                    bigInteger3 = bigInteger3.add(bigInteger2);
                    byArray8 = PKCS12KeyStore.unsignedBigIntToBytes(bigInteger3, n6);
                    System.arraycopy(byArray8, 0, byArray6, n4, n6);
                    n4 += n6;
                }
                break;
            }
            return byArray3;
        }
        catch (Exception exception) {
            throw new Error("Error in PKCS12.deriveKey: " + exception);
        }
    }

    private static byte[] unsignedBigIntToBytes(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = null;
        if (byArray.length > n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, byArray.length - n, byArray2, 0, n);
        } else if (byArray.length < n) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    private static byte[] deriveKeyPKCS5(char[] cArray, byte[] byArray, int n, int n2, String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray2 = new byte[cArray.length];
            for (int i = 0; i < cArray.length; ++i) {
                byArray2[i] = (byte)(cArray[i] & 0xFF);
            }
            messageDigest.update(byArray2);
            messageDigest.update(byArray);
            byte[] byArray3 = messageDigest.digest();
            int n3 = byArray3.length;
            for (int i = 1; i < n; ++i) {
                messageDigest.update(byArray3);
                messageDigest.digest(byArray3, 0, n3);
            }
            byte[] byArray4 = new byte[n2];
            System.arraycopy(byArray3, 0, byArray4, 0, n2);
            return byArray4;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static void doCipher(int n, char[] cArray, byte[] byArray, int n2, byte[] byArray2, byte[] byArray3, int n3, String string) throws NoSuchAlgorithmException {
        try {
            byte[] byArray4;
            byte[] byArray5;
            int n4 = 40;
            boolean bl = false;
            String string2 = "SHA";
            if (string.equals("pbeWithSHAAnd3-KeyTripleDES-CBC")) {
                n4 = 192;
                string = "3DES/CBC/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd2-KeyTripleDES-CBC")) {
                n4 = 128;
                string = "3DES/CBC/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd40BitRC2-CBC")) {
                string = "RC2/CBC/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd128BitRC2-CBC")) {
                n4 = 128;
                string = "RC2/CBC/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd40BitRC4")) {
                string = "RC4/OFB/PKCS5Padding";
            } else if (string.equals("pbeWithSHAAnd128BitRC4")) {
                n4 = 128;
                string = "RC4/OFB/PKCS5Padding";
            } else if (string.equals("pbeWithSHA1AndRC2-CBC")) {
                bl = true;
                n4 = 64;
                string = "RC2/CBC/PKCS5Padding";
                string2 = "SHA1";
            } else if (string.equals("pbeWithMD2AndRC2-CBC")) {
                bl = true;
                n4 = 64;
                string = "RC2/CBC/PKCS5Padding";
                string2 = "MD2";
            } else if (string.equals("pbeWithMD5AndRC2-CBC")) {
                bl = true;
                n4 = 64;
                string = "RC2/CBC/PKCS5Padding";
                string2 = "MD5";
            } else if (string.equals("pbeWithMD2AndDES-CBC")) {
                bl = true;
                n4 = 64;
                string = "DES/CBC/PKCS5Padding";
                string2 = "MD2";
            } else if (string.equals("pbeWithMD5AndDES-CBC")) {
                bl = true;
                n4 = 64;
                string = "DES/CBC/PKCS5Padding";
                string2 = "MD5";
            } else if (string.equals("pbeWithSHA1AndDES-CBC")) {
                bl = true;
                n4 = 64;
                string = "DES/CBC/PKCS5Padding";
                string2 = "SHA1";
            }
            n4 /= 8;
            Cipher cipher = Cipher.getInstance(string);
            string = cipher.getAlgorithm();
            if (bl) {
                byte[] byArray6 = PKCS12KeyStore.deriveKeyPKCS5(cArray, byArray3, n3, 16, string2);
                byArray5 = new byte[8];
                System.arraycopy(byArray6, 0, byArray5, 0, 8);
                byArray4 = new byte[8];
                System.arraycopy(byArray6, 8, byArray4, 0, 8);
            } else {
                byArray5 = PKCS12KeyStore.deriveKey(cArray, n4, byArray3, n3, 1, string2);
                byArray4 = PKCS12KeyStore.deriveKey(cArray, 8, byArray3, n3, 2, string2);
            }
            cipher.init(n, new SecretKeySpec(byArray5, string), new IvParameterSpec(byArray4));
            cipher.doFinal(byArray, 0, n2, byArray2, 0);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Error("Invalid key derived in PKCS12KeyStore.doCipher: " + invalidKeyException);
        }
    }

    public static class DSAyx
    extends ASN1Sequence {
        public ASN1Integer x;
        public ASN1Integer y = new ASN1Integer();

        public DSAyx() {
            this.x = new ASN1Integer();
            this.addComponent(this.y);
            this.addComponent(this.x);
        }
    }
}

