/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.KeyFactorySpi;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.spec.InvalidKeySpecException;
import com.mindbright.jca.security.spec.KeySpec;
import com.mindbright.jce.crypto.spec.DHPrivateKeySpec;
import com.mindbright.jce.crypto.spec.DHPublicKeySpec;
import com.mindbright.security.publickey.DHPrivateKey;
import com.mindbright.security.publickey.DHPublicKey;

public final class DHKeyFactory
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof DHPublicKeySpec)) {
            throw new InvalidKeySpecException("KeySpec " + keySpec + ", not supported");
        }
        DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)keySpec;
        return new DHPublicKey(dHPublicKeySpec.getY(), dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof DHPrivateKeySpec)) {
            throw new InvalidKeySpecException("KeySpec " + keySpec + ", not supported");
        }
        DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)keySpec;
        return new DHPrivateKey(dHPrivateKeySpec.getX(), dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        throw new Error("DHKeyFactory.engineGetKeySpec() not implemented");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new Error("DHKeyFactory.engineTranslateKey() not implemented");
    }
}

