/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.publickey;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.KeyFactorySpi;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.spec.InvalidKeySpecException;
import com.mindbright.jca.security.spec.KeySpec;
import com.mindbright.jca.security.spec.RSAPrivateCrtKeySpec;
import com.mindbright.jca.security.spec.RSAPrivateKeySpec;
import com.mindbright.jca.security.spec.RSAPublicKeySpec;
import com.mindbright.security.publickey.RSAPrivateCrtKey;
import com.mindbright.security.publickey.RSAPrivateKey;
import com.mindbright.security.publickey.RSAPublicKey;

public class RSAKeyFactory
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof RSAPublicKeySpec)) {
            throw new InvalidKeySpecException("KeySpec " + keySpec + ", not supported");
        }
        RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
        return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof RSAPrivateKeySpec)) {
            throw new InvalidKeySpecException("KeySpec " + keySpec + ", not supported");
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        }
        RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
        return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return null;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }
}

