/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHChannel;
import com.mindbright.ssh.SSHChannelListener;
import com.mindbright.ssh.SSHCipher;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHCompressor;
import com.mindbright.ssh.SSHConnectChannel;
import com.mindbright.ssh.SSHConsole;
import com.mindbright.ssh.SSHInteractor;
import com.mindbright.ssh.SSHListenChannel;
import com.mindbright.ssh.SSHPdu;
import com.mindbright.ssh.SSHPduInputStream;
import com.mindbright.ssh.SSHPduOutputStream;
import com.mindbright.ssh.SSHProtocolPlugin;
import com.mindbright.ssh.SSHRxChannel;
import com.mindbright.ssh.SSHTunnel;
import com.mindbright.ssh.SSHTxChannel;
import com.mindbright.util.Queue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public final class SSHChannelController
extends SSH
implements SSHChannelListener {
    protected SSHTxChannel txChan;
    protected SSHRxChannel rxChan;
    protected SSHConnectChannel cnChan;
    protected Queue txQueue;
    protected Queue cnQueue;
    protected int totalTunnels;
    protected int nextEmptyChan;
    protected Object[] tunnels;
    protected Vector listenChannels;
    protected SSH sshHook;
    protected SSHConsole console;
    protected SSHCipher sndCipher;
    protected SSHCompressor sndComp;
    protected SSHCipher rcvCipher;
    protected SSHCompressor rcvComp;

    public SSHChannelController(SSH sSH, InputStream inputStream, OutputStream outputStream, SSHCipher sSHCipher, SSHCompressor sSHCompressor, SSHCipher sSHCipher2, SSHCompressor sSHCompressor2, SSHConsole sSHConsole, boolean bl) {
        this.sndCipher = sSHCipher;
        this.sndComp = sSHCompressor;
        this.rcvCipher = sSHCipher2;
        this.rcvComp = sSHCompressor2;
        this.sshHook = sSH;
        this.console = sSHConsole;
        this.tunnels = new Object[16];
        this.nextEmptyChan = 0;
        this.totalTunnels = 0;
        this.listenChannels = new Vector();
        this.txChan = new SSHTxChannel(outputStream, -1);
        this.rxChan = new SSHRxChannel(inputStream, -1);
        this.rxChan.setSSHChannelListener(this);
        this.txChan.setSSHChannelListener(this);
        this.rxChan.setSSHPduFactory(new SSHPduInputStream(-1, sSHCipher2, sSHCompressor2));
        this.txQueue = this.txChan.getQueue();
        if (bl) {
            this.cnChan = new SSHConnectChannel(this);
            this.cnChan.setSSHChannelListener(this);
            this.cnQueue = this.cnChan.getQueue();
        } else {
            this.cnQueue = new Queue();
        }
    }

    public void start() {
        this.txChan.start();
        this.rxChan.start();
        if (this.cnChan != null) {
            this.cnChan.start();
        }
    }

    public void waitForExit() throws InterruptedException {
        this.waitForExit(0L);
    }

    public void waitForExit(long l) throws InterruptedException {
        if (this.rxChan != null) {
            this.rxChan.join(l);
        }
        Thread.sleep(100L);
        this.killAll();
    }

    public void killAll() {
        this.killAllTunnels();
        this.killListenChannels();
        if (this.rxChan != null && this.rxChan.isAlive()) {
            this.rxChan.stop();
        }
        if (this.txChan != null && this.txChan.isAlive()) {
            this.txChan.stop();
        }
        if (this.cnChan != null && this.cnChan.isAlive()) {
            this.cnChan.stop();
        }
        this.rxChan = null;
        this.txChan = null;
        this.cnChan = null;
        System.runFinalization();
    }

    public synchronized int newChannelId() {
        int n = this.nextEmptyChan;
        if (this.nextEmptyChan < this.tunnels.length) {
            int n2;
            for (n2 = this.nextEmptyChan + 1; n2 < this.tunnels.length && this.tunnels[n2] != null; ++n2) {
            }
            this.nextEmptyChan = n2;
        } else {
            Object[] objectArray = new Object[this.tunnels.length + 16];
            System.arraycopy(this.tunnels, 0, objectArray, 0, this.tunnels.length);
            this.tunnels = objectArray;
            ++this.nextEmptyChan;
        }
        return n;
    }

    public synchronized String[] listTunnels() {
        int n = 0;
        String[] stringArray = new String[this.tunnels.length];
        for (int i = 0; i < this.tunnels.length; ++i) {
            if (this.tunnels[i] == null) continue;
            stringArray[n++] = ((SSHTunnel)this.tunnels[i]).getDescription();
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public synchronized void closeTunnelFromList(int n) {
        int n2;
        for (n2 = 0; n2 < this.tunnels.length && (this.tunnels[n2] == null || --n >= 0); ++n2) {
        }
        if (n2 < this.tunnels.length) {
            ((SSHTunnel)this.tunnels[n2]).terminateNow();
        }
    }

    public synchronized void killAllTunnels() {
        for (int i = 0; i < this.tunnels.length; ++i) {
            if (this.tunnels[i] == null) continue;
            ((SSHTunnel)this.tunnels[i]).openFailure();
            this.tunnels[i] = null;
        }
        this.tunnels = new Object[16];
    }

    public synchronized void addTunnel(SSHTunnel sSHTunnel) throws IOException {
        ++this.totalTunnels;
        this.tunnels[sSHTunnel.channelId] = sSHTunnel;
    }

    public synchronized SSHTunnel delTunnel(int n) {
        SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels[n];
        this.tunnels[n] = null;
        this.nextEmptyChan = n < this.nextEmptyChan ? n : this.nextEmptyChan;
        --this.totalTunnels;
        return sSHTunnel;
    }

    public boolean haveHostInFwdOpen() {
        return this.sshHook.isProtocolFlagSet(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSHListenChannel newListenChannel(String string, int n, String string2, int n2, String string3) throws IOException {
        SSHListenChannel sSHListenChannel = null;
        sSHListenChannel = SSHProtocolPlugin.getPlugin(string3).localListener(string, n, string2, n2, this);
        sSHListenChannel.setSSHChannelListener(this);
        sSHListenChannel.start();
        Vector vector = this.listenChannels;
        synchronized (vector) {
            this.listenChannels.addElement(sSHListenChannel);
        }
        return sSHListenChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killListenChannel(String string, int n) {
        Vector vector = this.listenChannels;
        synchronized (vector) {
            for (int i = 0; i < this.listenChannels.size(); ++i) {
                SSHListenChannel sSHListenChannel = (SSHListenChannel)this.listenChannels.elementAt(i);
                if (sSHListenChannel.getListenPort() != n || !sSHListenChannel.getListenHost().equals(string)) continue;
                this.listenChannels.removeElementAt(i);
                sSHListenChannel.forceClose();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killListenChannels() {
        Vector vector = this.listenChannels;
        synchronized (vector) {
            while (this.listenChannels.size() > 0) {
                SSHListenChannel sSHListenChannel = (SSHListenChannel)this.listenChannels.elementAt(0);
                sSHListenChannel.forceClose();
                this.listenChannels.removeElementAt(0);
            }
        }
    }

    public SSHPdu prepare(SSHPdu sSHPdu) {
        return sSHPdu;
    }

    public void transmit(SSHPdu sSHPdu) {
        this.txQueue.putLast(sSHPdu);
    }

    public void receive(SSHPdu sSHPdu) {
        SSHPduInputStream sSHPduInputStream = (SSHPduInputStream)sSHPdu;
        try {
            switch (sSHPduInputStream.type) {
                case 17: {
                    if (this.console != null) {
                        this.console.stdoutWriteString(sSHPduInputStream.readStringAsBytes());
                    }
                    break;
                }
                case 18: {
                    if (this.console != null) {
                        this.console.stderrWriteString(sSHPduInputStream.readStringAsBytes());
                    }
                    break;
                }
                case 20: {
                    SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(33, this.sndCipher, this.sndComp, SSH.secureRandom());
                    int n = sSHPduInputStream.readInt();
                    if (this.console != null) {
                        if (n != 0) {
                            this.console.serverDisconnect(this.sshAsClient().getServerAddr().getHostName() + " disconnected: " + n);
                        } else {
                            this.console.serverDisconnect("Connection to " + this.sshAsClient().getServerAddr().getHostName() + " closed.");
                        }
                    }
                    this.transmit(sSHPduOutputStream);
                    this.sshAsClient().disconnect(true);
                    break;
                }
                case 27: 
                case 29: {
                    this.cnQueue.putLast(sSHPduInputStream);
                    break;
                }
                case 23: {
                    int n = sSHPduInputStream.readInt();
                    SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels[n];
                    if (sSHTunnel != null) {
                        sSHTunnel.transmit(sSHPdu);
                        break;
                    }
                    throw new Exception("Data on nonexistent channel: " + n);
                }
                case 21: {
                    int n = sSHPduInputStream.readInt();
                    SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels[n];
                    if (sSHTunnel != null) {
                        if (!sSHTunnel.setRemoteChannelId(sSHPduInputStream.readInt())) {
                            throw new Exception("Open confirmation on allready opened channel!");
                        }
                        sSHTunnel.start();
                        break;
                    }
                    throw new Exception("Open confirm on nonexistent: " + n);
                }
                case 22: {
                    int n = sSHPduInputStream.readInt();
                    SSHTunnel sSHTunnel = this.delTunnel(n);
                    if (sSHTunnel != null) {
                        this.alert("Channel open failure on " + sSHTunnel.remoteDesc);
                        sSHTunnel.openFailure();
                        break;
                    }
                    throw new Exception("Open failure on nonexistent channel: " + n);
                }
                case 24: {
                    int n = sSHPduInputStream.readInt();
                    SSHTunnel sSHTunnel = (SSHTunnel)this.tunnels[n];
                    if (sSHTunnel != null) {
                        sSHTunnel.receiveInputEOF();
                        break;
                    }
                    throw new Exception("Input eof on nonexistent channel: " + n);
                }
                case 25: {
                    SSHTunnel sSHTunnel;
                    int n = sSHPduInputStream.readInt();
                    if (n < this.tunnels.length && (sSHTunnel = (SSHTunnel)this.tunnels[n]) != null) {
                        sSHTunnel.receiveOutputClosed();
                        break;
                    }
                    throw new Exception("Output closed on nonexistent channel: " + n);
                }
                case 1: {
                    this.disconnect("Peer disconnected: " + sSHPduInputStream.readString());
                    break;
                }
                case 11: {
                    break;
                }
                case 16: {
                    break;
                }
                case 19: {
                    System.out.println("!!! EOF received...");
                    break;
                }
                case 33: {
                    break;
                }
                default: {
                    throw new Exception("Unknown packet type (" + sSHPduInputStream.type + "), disconnecting...");
                }
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            System.out.println("\nplease send a mail to mt-support@appgate.com with:");
            System.out.println("(I found a bug in MindTerm!), error: " + exception.getMessage());
            System.out.println(stringWriter.toString());
            this.sendDisconnect("please send a mail to mt-support@appgate.com with:\n\r(I found a bug in MindTerm!), error: " + exception.getMessage() + "\n\r" + SSHChannelController.kludgeLF2CRLFMap(stringWriter.toString()));
        }
    }

    static String kludgeLF2CRLFMap(String string) {
        int n;
        int n2 = 0;
        String string2 = "";
        while ((n = string.indexOf(10, n2)) != -1) {
            string2 = string2 + string.substring(n2, n) + "\n\r";
            n2 = n + 1;
        }
        string2 = string2 + string.substring(n2);
        return string2;
    }

    public void close(SSHChannel sSHChannel) {
        if (sSHChannel instanceof SSHConnectChannel) {
            SSH.logExtra("Controller connect-channel closed");
        } else if (sSHChannel instanceof SSHTxChannel) {
            SSH.logExtra("Controller TX-channel closed");
        } else if (sSHChannel instanceof SSHRxChannel) {
            SSH.logExtra("Controller RX-channel closed");
            if (this.txChan != null) {
                this.txChan.setClosePending();
            }
        } else if (sSHChannel instanceof SSHListenChannel) {
            SSH.logExtra("Listen channel for port " + ((SSHListenChannel)sSHChannel).getListenPort() + " closed");
        } else {
            this.alert("Bug in SSHChannelController.close 'chan' is: " + sSHChannel);
        }
    }

    public void disconnect(String string) {
        if (this.sshHook.isAnSSHClient) {
            this.sshAsClient().disconnect(false);
        }
        if (this.txChan != null) {
            this.txChan.setClosePending();
        }
        if (this.console != null) {
            this.console.serverDisconnect("\r\nDisconnecting, " + string);
        } else {
            SSH.log("\r\nDisconnecting, " + string);
        }
        if (!this.sshHook.isAnSSHClient && this.rxChan != null) {
            this.rxChan.forceClose();
        }
    }

    public void sendDisconnect(String string) {
        try {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(1, this.sndCipher, this.sndComp, SSH.secureRandom());
            sSHPduOutputStream.writeString(string);
            if (this.txQueue != null) {
                this.txQueue.putFirst(sSHPduOutputStream);
            }
            Thread.sleep(300L);
            this.disconnect(string);
        }
        catch (Exception exception) {
            this.alert("Error in sendDisconnect: " + exception.toString());
        }
    }

    public void alert(String string) {
        if (this.sshHook.isAnSSHClient) {
            SSHInteractor sSHInteractor = this.sshAsClient().user.getInteractor();
            if (sSHInteractor != null) {
                sSHInteractor.alert(string);
            }
        } else {
            SSH.log(string);
        }
    }

    protected SSHClient sshAsClient() {
        return (SSHClient)this.sshHook;
    }

    public Queue getCnQueue() {
        return this.cnQueue;
    }

    public void addHostMapTemporary(String string, String string2, int n) {
        this.cnChan.addHostMapTemporary(string, string2, n);
    }

    public void addHostMapPermanent(String string, String string2, int n) {
        this.cnChan.addHostMapPermanent(string, string2, n);
    }

    public void delHostMap(String string) {
        this.cnChan.delHostMap(string);
    }

    public Vector getHostMap(String string) {
        return this.cnChan.getHostMap(string);
    }
}

