/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.gui.ProgressBar;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.KeyPairGenerator;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.interfaces.RSAPrivateCrtKey;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh2.SSH2AccessDeniedException;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2KeyPairFile;
import com.mindbright.ssh2.SSH2PublicKeyFile;
import com.mindbright.terminal.TerminalWin;
import com.mindbright.util.RandomSeed;
import com.mindbright.util.Util;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public final class SSHKeyGenerationDialog {
    private static final String keyGenerationHelp = "The key is generated using a random number generator, which is seeded by mouse movement in the field containing this text. Please move the mouse around in here until the progress bar below registers 100%.\n\nThis will create a publickey identity which can be used with the publickey authentication method. Your identity will consist of two parts: public and private keys. Your private key will be saved in the location which you specify; the corresponding public key is saved in a file with an identical name but with an extension of '.pub' added to it.\n\nYour private key is protected by encryption, if you entered a password. If you left the password field blank, the key will not be encrypted. This should only be used in protected environments where unattended logins are desired. The contents of the 'comment' field are stored with your key, and displayed each time you are prompted for the key's password.";
    private static final String keyGenerationComplete = "Key Generation Complete\n\nTo use the key, you must transfer the '.pub' public key file to an SSH server and add it to the set of authorized keys. See your server documentation for details on this.\n\nFor convenience, your public key has been copied to the clipboard.\n\nExamples:\nIn ssh2 the '.pub' file should be pointed out in the file 'authorization' in the config directory (e.g. ~/.ssh2)\n\nIn OpenSSH's ssh2 the contents of the '.pub' file should be added to the file 'authorized_keys2' in your config directory (e.g. ~/.ssh) on the server.\n\nIn ssh1 the contents of the '.pub' file should be added to the file 'authorized_keys' in your ssh directory (e.g. ~/.ssh).\n\nPress 'Back' to generate a new keypair.";
    private static Dialog keyGenerationDialog;
    private static FileDialog keyGenFD;
    private static Choice choiceBits;
    private static Choice choiceType;
    private static TextField fileText;
    private static TextField pwdText;
    private static TextField pwdText2;
    private static TextField commText;
    private static TextArea descText;
    private static ProgressBar progBar;
    private static Button okBut;
    private static Checkbox cbOpenSSH;
    private static Panel cardPanel;
    private static CardLayout cardLayout;
    private static Frame parent;
    private static boolean generatedAndSaved;
    private static SSHInteractiveClient client;
    private static Dialog editKeyDialog;
    private static FileDialog editKeyLoad;
    private static TextField fileTextEd;
    private static TextField pwdTextEd;
    private static TextField pwdText2Ed;
    private static TextField subjTextEd;
    private static TextField commTextEd;
    private static Label typeLbl;
    private static Label bitLbl;
    private static Checkbox cbOpenSSHEd;
    private static Checkbox cbSSHComEd;
    private static Button okButEd;
    private static Button cancButEd;
    private static SSH2KeyPairFile kpf;
    private static SSH2PublicKeyFile pkf;

    public static void show(Frame frame, SSHInteractiveClient sSHInteractiveClient) {
        Object object;
        client = sSHInteractiveClient;
        parent = frame;
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        if (keyGenerationDialog == null) {
            keyGenerationDialog = new Dialog(parent, "MindTerm - Publickey Keypair Generation", true);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(keyGenerationDialog);
            keyGenFD = new FileDialog(parent, "MindTerm - Select file to save identity to", 1);
            keyGenFD.setDirectory(SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir());
            SSHKeyGenerationDialog.createCardPanel();
            aWTGridBagContainer.add(cardPanel, 0, 0);
            aWTGridBagContainer.getConstraints().anchor = 10;
            Panel panel = new Panel(new FlowLayout());
            okBut = new Button("Generate");
            panel.add(okBut);
            okBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (generatedAndSaved) {
                        SSHKeyGenerationDialog.resetValues();
                    } else if (SSHKeyGenerationDialog.checkValues(pwdText.getText(), pwdText2.getText(), fileText.getText())) {
                        cardLayout.show(cardPanel, "second");
                        okBut.setEnabled(false);
                    }
                }
            });
            object = new Button("Close");
            panel.add((Component)object);
            ((Button)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)keyGenerationDialog).setVisible(false);
                    SSHKeyGenerationDialog.resetValues();
                }
            });
            aWTGridBagContainer.add(panel, 2, 0);
            keyGenerationDialog.addWindowListener(new AWTConvenience.CloseAdapter((Button)object));
            AWTConvenience.setBackgroundOfChildren(keyGenerationDialog);
            keyGenerationDialog.setResizable(true);
            keyGenerationDialog.pack();
        }
        SSHKeyGenerationDialog.resetValues();
        object = SSH.randomSeed();
        ((RandomSeed)object).addEntropyGenerator(descText);
        AWTConvenience.placeDialog(keyGenerationDialog);
        choiceBits.requestFocus();
        ((Component)keyGenerationDialog).setVisible(true);
    }

    private static void alert(String string) {
        SSHMiscDialogs.alert("MindTerm - Alert", string, parent);
    }

    private static void setDefaultFileName(SSHInteractiveClient sSHInteractiveClient) {
        try {
            String string = sSHInteractiveClient.propsHandler.getSSHHomeDir() + "identity";
            File file = new File(string);
            int n = 0;
            while (file.exists()) {
                string = sSHInteractiveClient.propsHandler.getSSHHomeDir() + "identity" + n;
                file = new File(string);
                ++n;
            }
            fileText.setText("identity" + (--n >= 0 ? String.valueOf(n) : ""));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void createCardPanel() {
        cardPanel = new Panel();
        cardLayout = new CardLayout();
        cardPanel.setLayout(cardLayout);
        Panel panel = new Panel();
        AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(panel);
        aWTGridBagContainer.getConstraints().fill = 1;
        descText = new TextArea(keyGenerationHelp, 12, 34, 1);
        descText.setEditable(false);
        aWTGridBagContainer.add(descText, 2, 8);
        descText.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (progBar.isFinished()) {
                    try {
                        client;
                        SSH.randomSeed().removeProgress();
                        progBar.setValue(0);
                        int n = Integer.valueOf(choiceBits.getSelectedItem());
                        String string = choiceType.getSelectedItem().substring(0, 3);
                        descText.setText("Generating keypair, please wait...");
                        Thread.yield();
                        KeyPair keyPair = SSHKeyGenerationDialog.generateKeyPair(string, n);
                        SSHKeyGenerationDialog.saveKeyPair(keyPair);
                        okBut.setEnabled(true);
                        okBut.setLabel("Back");
                        descText.setText(SSHKeyGenerationDialog.keyGenerationComplete);
                        generatedAndSaved = true;
                    }
                    catch (Throwable throwable) {
                        SSHKeyGenerationDialog.alert("Error while generating/saving key pair: " + throwable.getMessage());
                        cardLayout.show(cardPanel, "first");
                    }
                }
            }
        });
        aWTGridBagContainer.getConstraints().fill = 0;
        aWTGridBagContainer.getConstraints().anchor = 10;
        progBar = new ProgressBar(512L, 150, 20);
        aWTGridBagContainer.add(progBar, 3, 8);
        cardPanel.add((Component)panel, "second");
        panel = new Panel();
        aWTGridBagContainer = new AWTGridBagContainer(panel);
        Label label = new Label("Key type/format:");
        aWTGridBagContainer.add(label, 0, 2);
        choiceType = AWTConvenience.newChoice(new String[]{"DSA (ssh2)", "RSA (ssh2)", "RSA (ssh1)"});
        aWTGridBagContainer.add(choiceType, 0, 2);
        label = new Label("Key length (bits):");
        aWTGridBagContainer.add(label, 1, 2);
        choiceBits = AWTConvenience.newChoice(new String[]{"768", "1024", "1536"});
        aWTGridBagContainer.add(choiceBits, 1, 2);
        label = new Label("Identity file:");
        aWTGridBagContainer.add(label, 2, 2);
        fileText = new TextField("", 18);
        aWTGridBagContainer.add(fileText, 2, 2);
        Button button = new Button("...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)keyGenFD).setVisible(true);
                if (keyGenFD.getFile() != null && keyGenFD.getFile().length() > 0) {
                    fileText.setText(keyGenFD.getDirectory() + keyGenFD.getFile());
                }
            }
        });
        aWTGridBagContainer.getConstraints().fill = 0;
        aWTGridBagContainer.add(button, 2, 1);
        aWTGridBagContainer.getConstraints().fill = 2;
        label = new Label("Password:");
        aWTGridBagContainer.add(label, 3, 2);
        pwdText = new TextField("", 18);
        pwdText.setEchoChar('*');
        aWTGridBagContainer.add(pwdText, 3, 2);
        label = new Label("Password again:");
        aWTGridBagContainer.add(label, 4, 2);
        pwdText2 = new TextField("", 18);
        pwdText2.setEchoChar('*');
        aWTGridBagContainer.add(pwdText2, 4, 2);
        label = new Label("Comment:");
        aWTGridBagContainer.add(label, 5, 2);
        commText = new TextField("", 18);
        aWTGridBagContainer.add(commText, 5, 2);
        cbOpenSSH = new Checkbox("OpenSSH .pub format");
        aWTGridBagContainer.add(cbOpenSSH, 6, 4);
        cardPanel.add((Component)panel, "first");
    }

    public static KeyPair generateKeyPair(String string, int n) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string);
        keyPairGenerator.initialize(n, (SecureRandom)SSH.secureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    private static void saveKeyPair(KeyPair keyPair) throws IOException, SSH2Exception, NoSuchAlgorithmException {
        Object object;
        String string = pwdText.getText();
        String string2 = fileText.getText();
        String string3 = SSHKeyGenerationDialog.client.propsHandler.getProperty("usrname");
        String string4 = commText.getText();
        String string5 = null;
        if (string3 == null) {
            string3 = SSH.VER_MINDTERM;
        }
        if ("RSA (ssh1)".equals(choiceType.getSelectedItem())) {
            string5 = SSH.generateKeyFiles((RSAPrivateCrtKey)keyPair.getPrivate(), SSHKeyGenerationDialog.expandFileName(string2), string, string4);
        } else {
            object = new SSH2PublicKeyFile(keyPair.getPublic(), string3, string4);
            if (string == null || string.length() == 0) {
                string3 = null;
                string4 = null;
            }
            SSH2KeyPairFile sSH2KeyPairFile = new SSH2KeyPairFile(keyPair, string3, string4);
            sSH2KeyPairFile.store(SSHKeyGenerationDialog.expandFileName(string2), SSH.secureRandom(), string);
            string5 = ((SSH2PublicKeyFile)object).store(SSHKeyGenerationDialog.expandFileName(string2 + ".pub"), !cbOpenSSH.getState());
        }
        object = SSHKeyGenerationDialog.client.sshStdIO.getTerminal();
        if (object instanceof TerminalWin) {
            ((TerminalWin)object).getClipboard().setSelection(string5);
        }
        okBut.setEnabled(true);
        pwdText.setText("");
        pwdText2.setText("");
        progBar.setValue(0);
        SSHKeyGenerationDialog.setDefaultFileName(client);
    }

    private static void resetValues() {
        okBut.setEnabled(true);
        choiceBits.select("1024");
        SSHKeyGenerationDialog.setDefaultFileName(client);
        generatedAndSaved = false;
        pwdText.setText("");
        pwdText2.setText("");
        descText.setText(keyGenerationHelp);
        okBut.setLabel("Generate");
        cardLayout.show(cardPanel, "first");
        RandomSeed randomSeed = SSH.randomSeed();
        randomSeed.resetEntropyCount();
        progBar.setValue(0);
        randomSeed.addProgress(progBar);
    }

    private static boolean checkValues(String string, String string2, String string3) {
        if (!string.equals(string2)) {
            SSHKeyGenerationDialog.alert("Please give same password twice");
            return false;
        }
        if (string3.length() == 0) {
            SSHKeyGenerationDialog.alert("Filename can't be empty");
            return false;
        }
        OutputStream outputStream = SSHKeyGenerationDialog.getOutput(string3);
        if (outputStream == null) {
            SSHKeyGenerationDialog.alert("Can't open '" + string3 + "' for saving.");
            return false;
        }
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static OutputStream getOutput(String string) {
        string = SSHKeyGenerationDialog.expandFileName(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            return fileOutputStream;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String expandFileName(String string) {
        if (string.indexOf(File.separator) == -1) {
            string = SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir() + string;
        }
        return string;
    }

    public static void editKeyDialog(Frame frame, SSHInteractiveClient sSHInteractiveClient) {
        parent = frame;
        client = sSHInteractiveClient;
        if (editKeyLoad == null) {
            editKeyLoad = new FileDialog(parent, "MindTerm - Select key file to edit", 0);
        }
        editKeyLoad.setDirectory(SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir());
        ((Component)editKeyLoad).setVisible(true);
        String string = editKeyLoad.getFile();
        String string2 = editKeyLoad.getDirectory();
        String string3 = null;
        kpf = new SSH2KeyPairFile();
        pkf = new SSH2PublicKeyFile();
        if (string != null && string.length() > 0) {
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            string = string2 + string;
            try {
                pkf.load(string + ".pub");
            }
            catch (Exception exception) {
                pkf = null;
            }
            boolean bl = false;
            do {
                try {
                    kpf.load(string, string3);
                    break;
                }
                catch (SSH2AccessDeniedException sSH2AccessDeniedException) {
                    bl = true;
                }
                catch (Exception exception) {
                    SSHKeyGenerationDialog.alert("Error loading key file: " + exception.getMessage());
                }
            } while ((string3 = SSHMiscDialogs.password("MindTerm - File Password", "Please give password for " + string, parent)) != null);
            if (bl && string3 == null) {
                return;
            }
        } else {
            return;
        }
        if (pkf == null) {
            pkf = new SSH2PublicKeyFile(kpf.getKeyPair().getPublic(), kpf.getSubject(), kpf.getComment());
        }
        if (editKeyDialog == null) {
            editKeyDialog = new Dialog(parent, "MindTerm - Publickey Keypair Edit", true);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(editKeyDialog);
            Label label = new Label("Key type/format:");
            aWTGridBagContainer.add(label, 0, 2);
            typeLbl = new Label("DSA");
            aWTGridBagContainer.add(typeLbl, 0, 2);
            label = new Label("Key length (bits):");
            aWTGridBagContainer.add(label, 1, 2);
            bitLbl = new Label("1024");
            aWTGridBagContainer.add(bitLbl, 1, 2);
            label = new Label("Identity file:");
            aWTGridBagContainer.add(label, 2, 2);
            fileTextEd = new TextField("", 18);
            aWTGridBagContainer.add(fileTextEd, 2, 2);
            aWTGridBagContainer.getConstraints().fill = 2;
            label = new Label("Password:");
            aWTGridBagContainer.add(label, 3, 2);
            pwdTextEd = new TextField("", 18);
            pwdTextEd.setEchoChar('*');
            aWTGridBagContainer.add(pwdTextEd, 3, 2);
            label = new Label("Password again:");
            aWTGridBagContainer.add(label, 4, 2);
            pwdText2Ed = new TextField("", 18);
            pwdText2Ed.setEchoChar('*');
            aWTGridBagContainer.add(pwdText2Ed, 4, 2);
            label = new Label("Subject:");
            aWTGridBagContainer.add(label, 5, 2);
            subjTextEd = new TextField("", 18);
            aWTGridBagContainer.add(subjTextEd, 5, 2);
            label = new Label("Comment:");
            aWTGridBagContainer.add(label, 6, 2);
            commTextEd = new TextField("", 18);
            aWTGridBagContainer.add(commTextEd, 6, 2);
            cbSSHComEd = new Checkbox("SSH Comm. private file format");
            aWTGridBagContainer.add(cbSSHComEd, 7, 4);
            cbOpenSSHEd = new Checkbox("OpenSSH public public format");
            aWTGridBagContainer.add(cbOpenSSHEd, 8, 4);
            Panel panel = new Panel(new FlowLayout());
            okButEd = new Button("Save");
            panel.add(okButEd);
            okButEd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = fileTextEd.getText();
                    String string2 = pwdTextEd.getText();
                    if (SSHKeyGenerationDialog.checkValues(string2, pwdText2Ed.getText(), string)) {
                        string = SSHKeyGenerationDialog.expandFileName(string);
                        try {
                            String string3 = subjTextEd.getText();
                            String string4 = commTextEd.getText();
                            pkf.setSubject(string3);
                            pkf.setComment(string4);
                            pkf.store(string + ".pub", !cbOpenSSHEd.getState());
                            if (!(cbSSHComEd.getState() || string2 != null && string2.length() != 0)) {
                                string3 = null;
                                string4 = null;
                            }
                            kpf.setSubject(string3);
                            kpf.setComment(string4);
                            kpf.store(string, SSH.secureRandom(), string2, cbSSHComEd.getState());
                            ((Component)editKeyDialog).setVisible(false);
                        }
                        catch (Exception exception) {
                            SSHKeyGenerationDialog.alert("Error saving files: " + exception.getMessage());
                        }
                    }
                }
            });
            cancButEd = new Button("Cancel");
            panel.add(cancButEd);
            cancButEd.addActionListener(new AWTConvenience.CloseAction(editKeyDialog));
            aWTGridBagContainer.add(panel, 9, 0);
            editKeyDialog.addWindowListener(new AWTConvenience.CloseAdapter(cancButEd));
            AWTConvenience.setBackgroundOfChildren(editKeyDialog);
            AWTConvenience.setKeyListenerOfChildren(editKeyDialog, new AWTConvenience.OKCancelAdapter(okButEd, cancButEd), null);
            editKeyDialog.pack();
        }
        fileTextEd.setText(string);
        pwdTextEd.setText(string3);
        pwdText2Ed.setText(string3);
        typeLbl.setText(kpf.getAlgorithmName());
        bitLbl.setText(String.valueOf(kpf.getBitLength()));
        subjTextEd.setText(kpf.getSubject());
        commTextEd.setText(kpf.getComment());
        cbSSHComEd.setState(kpf.isSSHComFormat());
        cbOpenSSHEd.setState(!pkf.isSSHComFormat());
        AWTConvenience.placeDialog(editKeyDialog);
        ((Component)editKeyDialog).setVisible(true);
    }

    static {
        kpf = new SSH2KeyPairFile();
        pkf = new SSH2PublicKeyFile();
    }
}

