/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.application.MindTerm;
import com.mindbright.application.MindTermModule;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.gui.Logo;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHKeyGenerationDialog;
import com.mindbright.ssh.SSHMenuHandler;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh.SSHPropertyHandler;
import com.mindbright.ssh.SSHProxyDialog;
import com.mindbright.ssh.SSHTunnelDialog;
import com.mindbright.ssh.Version;
import com.mindbright.ssh2.SSH2ListUtil;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.terminal.TerminalMenuHandlerFull;
import com.mindbright.terminal.TerminalMenuListener;
import com.mindbright.terminal.TerminalWin;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public final class SSHMenuHandlerFull
extends SSHMenuHandler
implements ActionListener,
ItemListener,
TerminalMenuListener {
    protected static final int ACT_CLICK_LIST = 0;
    protected static final int ACT_SETTINGS2 = 1;
    protected static final int ACT_PROXY = 2;
    protected static final int ACT_PREFS = 3;
    protected static final int ACT_CONNECT = 4;
    protected static final int ACT_IDFILE = 5;
    protected static final int ACT_CLOSE_TUNNEL = 6;
    protected static final int ACT_REFRESH = 7;
    protected static final int ACT_LOCALADD = 8;
    protected static final int ACT_LOCALDEL = 9;
    protected static final int ACT_REMOTEADD = 10;
    protected static final int ACT_REMOTEDEL = 11;
    protected static final int ACT_CONNECT2 = 12;
    protected static final int ACT_NEWSERVER = 13;
    protected static final int ACT_UPDATE2 = 14;
    protected static final int ACT_CIPHER = 15;
    protected static final int ACT_MAC = 16;
    protected static final int ACT_COMP = 17;
    protected static final int ACT_UPDATE = 18;
    protected static final int ACT_MOD_BASE = 32;
    SSHInteractiveClient client;
    Frame parent;
    TerminalWin term;
    MindTerm mindterm;
    MenuItem[] modMenuItems;
    MindTermModule[] modules;
    int modCnt;
    static final int MENU_FILE = 0;
    static final int MENU_SETTINGS = 1;
    static final int MENU_TUNNELS = 2;
    static final int MENU_HELP = 3;
    static final int M_FILE_NEW = 1;
    static final int M_FILE_CLONE = 2;
    static final int M_FILE_CONN = 3;
    static final int M_FILE_DISC = 4;
    static final int M_FILE_LOAD = 6;
    static final int M_FILE_SAVE = 7;
    static final int M_FILE_SAVEAS = 8;
    static final int M_FILE_CREATID = 10;
    static final int M_FILE_EDITPKI = 11;
    static final int M_FILE_CAPTURE = 13;
    static final int M_FILE_SEND = 14;
    static final int M_FILE_CLOSE = 16;
    static final int M_FILE_EXIT = 17;
    static final int M_SET_SSH_NEW = 1;
    static final int M_SET_SSH_PREF = 2;
    static final int M_SET_TERM = 3;
    static final int M_SET_TERM_MSC = 4;
    static final int M_SET_TERM_COL = 5;
    static final int M_SET_PROXY = 6;
    static final int M_SET_RESET = 7;
    static final int M_SET_AUTOSAVE = 9;
    static final int M_SET_AUTOLOAD = 10;
    static final int M_SET_SAVEPWD = 11;
    static final int M_TUNL_SIMPLE = 1;
    static final int M_TUNL_ADVANCED = 2;
    static final int M_TUNL_CURRENT = 4;
    static final int M_HELP_TOPICS = 1;
    static final int M_HELP_ABOUT = 2;
    static final String[][] menuTexts = new String[][]{{"File", "New Terminal", "Clone Terminal", "Connect...", "Disconnect", null, "Load Settings...", "Save Settings", "Save Settings As...", null, "Create Keypair...", "Edit/Convert Keypair...", null, "_Capture To File...", "Send ASCII File...", null, "Close", "Exit"}, {"Settings", "New Server...", "Preferences...", "Terminal...", "Terminal Misc...", "Terminal Colors...", "Proxy...", "Reset To Defaults", null, "_Auto Save Settings", "_Auto Load Settings", "_Save Passwords"}, {"Tunnels", "Basic...", "Advanced...", null, "Current Connections..."}, {"Help", "Help Topics...", "About MindTerm"}};
    static final int NO_SHORTCUT = -1;
    static final int[][] menuShortCuts = new int[][]{{-1, 78, 79, 67, -1, -1, -1, 83, -1, -1, -1, -1, -1, -1, -1, -1, 69, 88}, {-1, 72, -1, 84, 77, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    Object[][] menuItems;
    int popButtonNum = 3;
    Dialog settingsDialog2 = null;
    Choice choiceCipherC2S;
    Choice choiceCipherS2C;
    Choice choiceMacC2S;
    Choice choiceMacS2C;
    Choice choiceCompC2S;
    Choice choiceCompS2C;
    Choice choiceProto;
    Choice choiceHKey;
    Checkbox cbX11;
    Checkbox cbIdHost;
    Checkbox cbKeyNoise;
    Checkbox cbLocHst;
    Checkbox cbAlive;
    Checkbox cbForcPty;
    TextField textDisp;
    TextField textMtu;
    TextField textAlive;
    TextField textRealAddr;
    TextField textLocHost;
    String[] hktypes;
    String[] ciphers;
    String[] macs;
    static final String[] compc2s = new String[]{"none", "low", "medium", "high"};
    static final String[] comps2c = new String[]{"none", "medium"};
    static final String[] lvl2comp = new String[]{"none", "low", "low", "low", "medium", "medium", "medium", "high", "high", "high"};
    static final String[] protos = new String[]{"auto", "ssh2", "ssh1"};
    static final int[] comp2lvl = new int[]{0, 2, 6, 9};
    Dialog settingsDialog = null;
    Choice choiceAuthTyp;
    Checkbox cbSaveAlias;
    TextField textSrv;
    TextField textPort;
    TextField textUser;
    TextField textAlias;
    TextField textId;
    TextField textAuthList;
    TextField textPwd;
    FileDialog idFileFD;
    Button idFileBut;
    Button advButton;
    CardLayout authCL;
    Panel authCP;
    public static final String[] authtyp = new String[]{"password", "publickey", "securid", "cryptocard", "tis", "kbd-interact", "custom list..."};
    Dialog currentTunnelsDialog = null;
    List currList;
    TunnelEditor localEdit = null;
    TunnelEditor remoteEdit = null;
    Dialog tunnelDialog = null;
    Dialog connectDialog = null;
    List hostList;
    boolean wantToRunSettingsDialog = false;
    FileDialog loadFileDialog = null;
    FileDialog saveAsFileDialog = null;
    public static final String aboutText = SSH.VER_MINDTERM + "\n" + Version.licenseMessage + "\n" + "\n" + Version.copyright + "\n" + "\thttp://www.appgate.com/mindterm/\n" + "\n" + "Includes parts of JZlib,\n" + "Copyright (c) 2000,2001,2002,2003 ymnk, JCraft,Inc. All rights reserved.\n" + "\n" + "JVM vendor:\t" + MindTerm.javaVendor + "\n" + "JVM version:\t" + MindTerm.javaVersion + "\n" + "OS name:\t\t" + MindTerm.osName + "\n" + "OS architecture:\t" + MindTerm.osArch + "\n" + "OS version:\t" + MindTerm.osVersion + "\n";

    public void init(MindTerm mindTerm, SSHInteractiveClient sSHInteractiveClient, Frame frame, TerminalWin terminalWin) {
        String string;
        this.mindterm = mindTerm;
        this.client = sSHInteractiveClient;
        this.parent = frame;
        this.term = terminalWin;
        this.modules = new MindTermModule[32];
        this.modMenuItems = new MenuItem[32];
        this.modCnt = 0;
        for (int i = 0; i < this.modules.length && (string = sSHInteractiveClient.propsHandler.getProperty("module" + i)) != null; ++i) {
            try {
                this.modules[i] = (MindTermModule)Class.forName(string).newInstance();
                this.modules[i].init(sSHInteractiveClient);
                ++this.modCnt;
                continue;
            }
            catch (Exception exception) {
                this.alertDialog("Module class '" + string + "' not found");
            }
        }
    }

    public void setPopupButton(int n) {
        this.term.setPopupButton(n);
        this.popButtonNum = n;
    }

    public int getPopupButton() {
        return this.popButtonNum;
    }

    Menu getMenu(int n) {
        Menu menu = new Menu(menuTexts[n][0]);
        int n2 = menuTexts[n].length;
        if (this.menuItems == null) {
            this.menuItems = new Object[menuTexts.length][];
        }
        if (this.menuItems[n] == null) {
            this.menuItems[n] = new Object[menuTexts[n].length];
        }
        for (int i = 1; i < n2; ++i) {
            MenuItem menuItem;
            String string = menuTexts[n][i];
            if (string == null) {
                menu.addSeparator();
                continue;
            }
            if (string.charAt(0) == '_') {
                string = string.substring(1);
                menuItem = new CheckboxMenuItem(string);
                ((CheckboxMenuItem)menuItem).addItemListener(this);
            } else {
                menuItem = new MenuItem(string);
                menuItem.addActionListener(this);
            }
            if (menuShortCuts[n][i] != -1) {
                menuItem.setShortcut(new MenuShortcut(menuShortCuts[n][i], true));
            }
            this.menuItems[n][i] = menuItem;
            menu.add(menuItem);
        }
        return menu;
    }

    Menu getPluginMenu() {
        Menu menu = null;
        if (this.modCnt > 0) {
            int n;
            menu = new Menu("Plugins");
            for (n = 0; n < this.modCnt; ++n) {
                MenuItem menuItem;
                String string = this.getModuleLabel(n);
                if (string == null) continue;
                this.modMenuItems[n] = menuItem = new MenuItem(string);
                menuItem.addActionListener(new Actions(32 + n));
                menu.add(menuItem);
            }
            if (n == 0) {
                menu = null;
            }
        }
        return menu;
    }

    String getModuleLabel(int n) {
        return this.client.propsHandler.getProperty("module" + n + ".label");
    }

    void modulesConnect() {
        for (int i = 0; i < this.modCnt; ++i) {
            this.modules[i].connected(this.client);
        }
    }

    void modulesDisconnect() {
        for (int i = 0; i < this.modCnt; ++i) {
            this.modules[i].disconnected(this.client);
        }
    }

    int[] mapAction(String string) {
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 0;
        block0: for (n = 0; n < menuTexts.length; ++n) {
            for (n2 = 1; n2 < menuTexts[n].length; ++n2) {
                String string2 = menuTexts[n][n2];
                if (string2 == null || !string.equals(string2)) continue;
                nArray[0] = n;
                nArray[1] = n2;
                n = menuTexts.length;
                continue block0;
            }
        }
        return nArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.mapAction(((MenuItem)actionEvent.getSource()).getLabel());
        this.handleMenuAction(nArray);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int[] nArray = this.mapAction("_" + (String)itemEvent.getItem());
        this.handleMenuAction(nArray);
    }

    public void handleMenuAction(int[] nArray) {
        block1 : switch (nArray[0]) {
            case 0: {
                switch (nArray[1]) {
                    case 1: {
                        this.mindterm.newWindow();
                        break;
                    }
                    case 2: {
                        this.mindterm.cloneWindow();
                        break;
                    }
                    case 3: {
                        this.connectDialog();
                        break;
                    }
                    case 4: {
                        if (!this.mindterm.confirmClose()) break;
                        this.client.forcedDisconnect();
                        this.client.quiet = this.client.initQuiet;
                        break;
                    }
                    case 6: {
                        this.loadFileDialog();
                        break;
                    }
                    case 7: {
                        try {
                            if (this.client.propsHandler.savePasswords && this.client.propsHandler.emptyPropertyPassword()) {
                                String string = this.setPasswordDialog("Please set password for alias " + this.client.propsHandler.currentAlias, "MindTerm - Set File Password");
                                if (string == null) {
                                    return;
                                }
                                this.client.propsHandler.setPropertyPassword(string);
                            }
                            this.client.propsHandler.saveCurrentFile();
                        }
                        catch (Throwable throwable) {
                            this.alertDialog("Error saving settings: " + throwable.getMessage());
                        }
                        break;
                    }
                    case 8: {
                        this.saveAsFileDialog();
                        break;
                    }
                    case 10: {
                        SSHKeyGenerationDialog.show(this.parent, this.client);
                        break;
                    }
                    case 11: {
                        SSHKeyGenerationDialog.editKeyDialog(this.parent, this.client);
                        break;
                    }
                    case 13: {
                        if (((CheckboxMenuItem)this.menuItems[0][13]).getState()) {
                            if (((TerminalMenuHandlerFull)this.term.getMenus()).captureToFileDialog()) break;
                            ((CheckboxMenuItem)this.menuItems[0][13]).setState(false);
                            break;
                        }
                        ((TerminalMenuHandlerFull)this.term.getMenus()).endCapture();
                        break;
                    }
                    case 14: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).sendFileDialog();
                        break;
                    }
                    case 16: {
                        this.mindterm.close();
                        break;
                    }
                    case 17: {
                        this.mindterm.exit();
                    }
                }
                break;
            }
            case 1: {
                switch (nArray[1]) {
                    case 1: {
                        this.sshSettingsDialog();
                        break;
                    }
                    case 2: {
                        this.sshSettingsDialog2();
                        break;
                    }
                    case 3: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).termSettingsDialog();
                        break;
                    }
                    case 5: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).termColorsDialog();
                        break;
                    }
                    case 4: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).termSettingsDialog2();
                        break;
                    }
                    case 6: {
                        SSHProxyDialog.show("MindTerm - Proxy Settings", this.parent, this.client.propsHandler);
                        break;
                    }
                    case 7: {
                        this.client.propsHandler.resetToDefaults();
                        break;
                    }
                    case 9: {
                        this.client.propsHandler.setAutoSaveProps(((CheckboxMenuItem)this.menuItems[1][9]).getState());
                        this.update();
                        break;
                    }
                    case 10: {
                        this.client.propsHandler.setAutoLoadProps(((CheckboxMenuItem)this.menuItems[1][10]).getState());
                        this.update();
                        break;
                    }
                    case 11: {
                        this.client.propsHandler.setSavePasswords(((CheckboxMenuItem)this.menuItems[1][11]).getState());
                        if (!this.client.propsHandler.savePasswords || !this.client.propsHandler.emptyPropertyPassword() || this.client.propsHandler.getAlias() == null) break;
                        String string = this.setPasswordDialog("Please set password for alias " + this.client.propsHandler.currentAlias, "MindTerm - Set File Password");
                        if (string == null) {
                            this.client.propsHandler.setSavePasswords(false);
                            this.update();
                            return;
                        }
                        this.client.propsHandler.setPropertyPassword(string);
                    }
                }
                break;
            }
            case 2: {
                switch (nArray[1]) {
                    case 1: {
                        SSHTunnelDialog.show("MindTerm - Basic Tunnels Setup", this.client, this.client.propsHandler, this.parent);
                        break;
                    }
                    case 2: {
                        this.advancedTunnelsDialog();
                        break;
                    }
                    case 4: {
                        this.currentTunnelsDialog();
                    }
                }
                break;
            }
            case 3: {
                switch (nArray[1]) {
                    case 1: {
                        break block1;
                    }
                    case 2: {
                        SSHMenuHandlerFull.about(this.parent, this.client);
                    }
                }
            }
        }
    }

    public void update() {
        boolean bl = this.client.isOpened();
        boolean bl2 = this.client.isConnected();
        boolean bl3 = this.client.propsHandler.getSSHHomeDir() != null;
        ((MenuItem)this.menuItems[0][14]).setEnabled(bl);
        ((MenuItem)this.menuItems[0][8]).setEnabled(bl && bl3);
        ((MenuItem)this.menuItems[0][3]).setEnabled(!bl2);
        ((MenuItem)this.menuItems[0][4]).setEnabled(bl2);
        ((MenuItem)this.menuItems[0][6]).setEnabled(!bl2);
        ((MenuItem)this.menuItems[0][7]).setEnabled(this.client.propsHandler.wantSave() && this.client.propsHandler.currentAlias != null);
        ((MenuItem)this.menuItems[1][1]).setEnabled(!bl);
        ((MenuItem)this.menuItems[1][2]).setEnabled(bl);
        ((MenuItem)this.menuItems[1][6]).setEnabled(!bl);
        ((MenuItem)this.menuItems[1][7]).setEnabled(!bl);
        ((CheckboxMenuItem)this.menuItems[1][9]).setEnabled(bl3);
        ((CheckboxMenuItem)this.menuItems[1][10]).setEnabled(bl3);
        ((CheckboxMenuItem)this.menuItems[1][11]).setEnabled(bl3);
        ((CheckboxMenuItem)this.menuItems[1][9]).setState(this.client.propsHandler.autoSaveProps);
        ((CheckboxMenuItem)this.menuItems[1][10]).setState(this.client.propsHandler.autoLoadProps);
        ((CheckboxMenuItem)this.menuItems[1][11]).setState(this.client.propsHandler.savePasswords);
        ((MenuItem)this.menuItems[2][4]).setEnabled(bl);
        ((MenuItem)this.menuItems[2][1]).setEnabled(bl);
        ((MenuItem)this.menuItems[2][2]).setEnabled(bl);
        ((MenuItem)this.menuItems[3][1]).setEnabled(false);
        this.updatePluginMenu();
    }

    void updatePluginMenu() {
        for (int i = 0; i < this.modCnt; ++i) {
            if (this.getModuleLabel(i) == null) continue;
            this.modMenuItems[i].setEnabled(this.modules[i].isAvailable(this.client));
        }
    }

    public void close() {
    }

    public void prepareMenuBar(MenuBar menuBar) {
        menuBar.add(this.getMenu(0));
        menuBar.add(((TerminalMenuHandlerFull)this.term.getMenus()).getMenu(1));
        menuBar.add(this.getMenu(1));
        Menu menu = this.getPluginMenu();
        if (menu != null) {
            menuBar.add(menu);
        }
        menuBar.add(((TerminalMenuHandlerFull)this.term.getMenus()).getMenu(3));
        menuBar.add(this.getMenu(2));
        menuBar.setHelpMenu(this.getMenu(3));
        this.term.updateMenus();
    }

    public void preparePopupMenu(PopupMenu popupMenu) {
        this.havePopupMenu = true;
        popupMenu.add(this.getMenu(0));
        popupMenu.add(((TerminalMenuHandlerFull)this.term.getMenus()).getMenu(1));
        popupMenu.add(this.getMenu(1));
        Menu menu = this.getPluginMenu();
        if (menu != null) {
            popupMenu.add(menu);
        }
        popupMenu.add(((TerminalMenuHandlerFull)this.term.getMenus()).getMenu(3));
        popupMenu.add(this.getMenu(2));
        popupMenu.addSeparator();
        popupMenu.add(this.getMenu(3));
        this.update();
    }

    public final void sshSettingsDialog2() {
        Object object;
        if (this.settingsDialog2 == null) {
            this.ciphers = SSH2ListUtil.arrayFromList(SSHPropertyHandler.ciphAlgsSort);
            this.macs = SSH2ListUtil.arrayFromList(SSHPropertyHandler.macAlgs);
            this.hktypes = SSH2ListUtil.arrayFromList(SSHPropertyHandler.hostKeyAlgs);
            this.settingsDialog2 = new Dialog(this.parent, "MindTerm - SSH Preferences", true);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(this.settingsDialog2);
            Label label = new Label("Protocol:");
            aWTGridBagContainer.add(label, 0, 1);
            this.choiceProto = AWTConvenience.newChoice(protos);
            Actions actions = new Actions(14);
            this.choiceProto.addItemListener(actions);
            aWTGridBagContainer.add(this.choiceProto, 0, 1);
            label = new Label("Host key type:");
            aWTGridBagContainer.add(label, 0, 2);
            this.choiceHKey = AWTConvenience.newChoice(this.hktypes);
            aWTGridBagContainer.add(this.choiceHKey, 0, 1);
            aWTGridBagContainer.getConstraints().insets = new Insets(16, 4, 0, 4);
            label = new Label("Transport prefs.");
            aWTGridBagContainer.add(label, 1, 2);
            label = new Label("Client to Server:");
            aWTGridBagContainer.add(label, 1, 2);
            label = new Label("Server to Client:");
            aWTGridBagContainer.add(label, 1, 2);
            aWTGridBagContainer.getConstraints().insets = new Insets(4, 4, 0, 4);
            label = new Label("Cipher:");
            aWTGridBagContainer.add(label, 2, 2);
            label = new Label("Mac:");
            aWTGridBagContainer.add(label, 3, 2);
            label = new Label("Compression:");
            aWTGridBagContainer.add(label, 4, 2);
            this.choiceCipherC2S = AWTConvenience.newChoice(this.ciphers);
            this.choiceCipherS2C = AWTConvenience.newChoice(this.ciphers);
            this.choiceMacC2S = AWTConvenience.newChoice(this.macs);
            this.choiceMacS2C = AWTConvenience.newChoice(this.macs);
            this.choiceCompC2S = AWTConvenience.newChoice(compc2s);
            this.choiceCompS2C = AWTConvenience.newChoice(comps2c);
            this.choiceCipherC2S.insert("any standard", 0);
            this.choiceCipherS2C.insert("any standard", 0);
            this.choiceMacC2S.insert("any standard", 0);
            this.choiceMacS2C.insert("any standard", 0);
            this.choiceHKey.insert("any standard", 0);
            aWTGridBagContainer.add(this.choiceCipherC2S, 2, 2);
            aWTGridBagContainer.add(this.choiceMacC2S, 3, 2);
            aWTGridBagContainer.add(this.choiceCompC2S, 4, 2);
            aWTGridBagContainer.add(this.choiceCipherS2C, 2, 2);
            aWTGridBagContainer.add(this.choiceMacS2C, 3, 2);
            aWTGridBagContainer.add(this.choiceCompS2C, 4, 2);
            this.choiceCipherC2S.addItemListener(new Actions(15));
            this.choiceMacC2S.addItemListener(new Actions(16));
            this.choiceCompC2S.addItemListener(new Actions(17));
            aWTGridBagContainer.getConstraints().insets = new Insets(16, 4, 0, 4);
            this.cbX11 = new Checkbox("X11 forward");
            this.cbX11.addItemListener(actions);
            aWTGridBagContainer.add(this.cbX11, 5, 2);
            label = new Label("Local display:");
            aWTGridBagContainer.add(label, 5, 2);
            this.textDisp = new TextField("", 12);
            aWTGridBagContainer.add(this.textDisp, 5, 2);
            aWTGridBagContainer.getConstraints().insets = new Insets(4, 4, 0, 4);
            this.cbAlive = new Checkbox("Send keep-alive");
            this.cbAlive.addItemListener(actions);
            aWTGridBagContainer.add(this.cbAlive, 6, 2);
            label = new Label("Interval (seconds):");
            aWTGridBagContainer.add(label, 6, 2);
            this.textAlive = new TextField("", 12);
            aWTGridBagContainer.add(this.textAlive, 6, 2);
            this.cbLocHst = new Checkbox("Bind address");
            this.cbLocHst.addItemListener(actions);
            aWTGridBagContainer.add(this.cbLocHst, 7, 2);
            label = new Label("Local address:");
            aWTGridBagContainer.add(label, 7, 2);
            this.textLocHost = new TextField("", 12);
            aWTGridBagContainer.add(this.textLocHost, 7, 2);
            this.cbIdHost = new Checkbox("Strict host verify");
            aWTGridBagContainer.add(this.cbIdHost, 8, 2);
            this.cbForcPty = new Checkbox("Allocate PTY");
            aWTGridBagContainer.add(this.cbForcPty, 8, 2);
            this.cbKeyNoise = new Checkbox("Key timing noise");
            aWTGridBagContainer.add(this.cbKeyNoise, 8, 2);
            aWTGridBagContainer.getConstraints().insets = new Insets(0, 0, 0, 0);
            aWTGridBagContainer.getConstraints().anchor = 10;
            Panel panel = new Panel(new FlowLayout());
            object = new Button("OK");
            panel.add((Component)object);
            ((Button)object).addActionListener(new Actions(1));
            Button button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.settingsDialog2));
            aWTGridBagContainer.add(panel, 9, 0);
            this.settingsDialog2.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.settingsDialog2);
            AWTConvenience.setKeyListenerOfChildren(this.settingsDialog2, new AWTConvenience.OKCancelAdapter((Button)object, button), null);
            this.settingsDialog2.setResizable(true);
            this.settingsDialog2.pack();
        }
        this.choiceHKey.select(0);
        this.choiceCipherC2S.select(0);
        this.choiceCipherS2C.select(0);
        this.choiceMacC2S.select(0);
        this.choiceMacS2C.select(0);
        this.choiceProto.select(this.client.propsHandler.getProperty("protocol"));
        this.choiceHKey.select(this.client.propsHandler.getProperty("server-host-key-algorithms"));
        this.choiceCipherC2S.select(this.client.propsHandler.getProperty("enc-algorithms-cli2srv"));
        this.choiceCipherS2C.select(this.client.propsHandler.getProperty("enc-algorithms-srv2cli"));
        this.choiceMacC2S.select(this.client.propsHandler.getProperty("mac-algorithms-cli2srv"));
        this.choiceMacS2C.select(this.client.propsHandler.getProperty("mac-algorithms-srv2cli"));
        int n = this.client.propsHandler.getCompressionLevel();
        this.choiceCompC2S.select(lvl2comp[n]);
        object = this.client.propsHandler.getProperty("comp-algorithms-srv2cli");
        if ("none".equals(object)) {
            this.choiceCompS2C.select("none");
        } else {
            this.choiceCompS2C.select("medium");
        }
        this.textDisp.setText(this.client.propsHandler.getProperty("display"));
        this.textAlive.setText(this.client.propsHandler.getProperty("alive"));
        this.cbX11.setState(Boolean.valueOf(this.client.propsHandler.getProperty("x11fwd")));
        this.cbAlive.setState(!this.client.propsHandler.getProperty("alive").equals("0"));
        this.cbLocHst.setState(!this.client.propsHandler.getProperty("localhst").equals("0.0.0.0"));
        this.textLocHost.setEnabled(false);
        this.cbIdHost.setState(Boolean.valueOf(this.client.propsHandler.getProperty("stricthostid")));
        this.cbKeyNoise.setState(Boolean.valueOf(this.client.propsHandler.getProperty("key-timing-noise")));
        this.cbForcPty.setState(Boolean.valueOf(this.client.propsHandler.getProperty("forcpty")));
        this.updateChoices2();
        AWTConvenience.placeDialog(this.settingsDialog2);
        ((Component)this.settingsDialog2).setVisible(true);
    }

    void updateChoices2() {
        boolean bl = this.client.isOpened();
        boolean bl2 = !"ssh1".equals(this.choiceProto.getSelectedItem()) || bl && this.client.isSSH2;
        this.choiceProto.setEnabled(!bl);
        this.choiceHKey.setEnabled(bl2 && !bl);
        this.cbX11.setEnabled(!bl);
        this.cbIdHost.setEnabled(!bl);
        this.cbForcPty.setEnabled(!bl);
        boolean bl3 = false;
        if (this.client.transport != null) {
            bl3 = this.client.transport.incompatibleCantReKey;
        }
        boolean bl4 = !bl || bl2 && bl && !bl3;
        this.choiceCipherS2C.setEnabled(bl4 && bl2);
        this.choiceMacS2C.setEnabled(bl4 && bl2);
        this.choiceCompS2C.setEnabled(bl4 && bl2);
        this.choiceCipherC2S.setEnabled(bl4);
        this.choiceMacC2S.setEnabled(bl4 && bl2);
        this.choiceCompC2S.setEnabled(bl4);
        this.updateCheckedText(this.cbAlive, this.textAlive, "alive");
        this.updateCheckedText(this.cbLocHst, this.textLocHost, "localhst");
        this.updateCheckedText(this.cbX11, this.textDisp, "display");
    }

    private void updateCheckedText(Checkbox checkbox, TextField textField, String string) {
        if (!textField.isEnabled()) {
            if (checkbox.getState()) {
                textField.setText(this.client.propsHandler.getProperty(string));
            } else {
                textField.setText(this.client.propsHandler.getDefaultProperty(string));
            }
        }
        textField.setEnabled(checkbox.isEnabled() && checkbox.getState());
        if (!textField.isEnabled()) {
            textField.setText(this.client.propsHandler.getDefaultProperty(string));
        }
    }

    public final void sshSettingsDialog() {
        Object object;
        if (this.settingsDialog == null) {
            this.settingsDialog = new Dialog(this.parent, "MindTerm - New Server", true);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(this.settingsDialog);
            object = new Label("Server:");
            aWTGridBagContainer.add((Component)object, 0, 2);
            this.textSrv = new TextField("", 12);
            aWTGridBagContainer.add(this.textSrv, 0, 3);
            object = new Label("Port:");
            aWTGridBagContainer.add((Component)object, 0, 1);
            this.textPort = new TextField("", 4);
            aWTGridBagContainer.add(this.textPort, 0, 1);
            object = new Label("Username:");
            aWTGridBagContainer.add((Component)object, 1, 2);
            this.textUser = new TextField("", 12);
            aWTGridBagContainer.add(this.textUser, 1, 3);
            this.cbSaveAlias = new Checkbox("Save as alias");
            Actions actions = new Actions(18);
            this.cbSaveAlias.addItemListener(actions);
            aWTGridBagContainer.add(this.cbSaveAlias, 1, 3);
            object = new Label("Authentication:");
            aWTGridBagContainer.add((Component)object, 2, 3);
            this.choiceAuthTyp = AWTConvenience.newChoice(authtyp);
            aWTGridBagContainer.add(this.choiceAuthTyp, 2, 2);
            this.choiceAuthTyp.addItemListener(actions);
            this.textAlias = new TextField("", 8);
            aWTGridBagContainer.add(this.textAlias, 2, 2);
            aWTGridBagContainer.add(this.getAuthPanel(), 3, 0);
            Panel panel = new Panel(new FlowLayout(2));
            Button button = new Button("Use Proxy...");
            button.addActionListener(new Actions(2));
            panel.add(button);
            this.advButton = new Button("Preferences...");
            this.advButton.addActionListener(new Actions(3));
            panel.add(this.advButton);
            panel.add(new Panel());
            Button button2 = new Button("Connect");
            panel.add(button2);
            button2.addActionListener(new Actions(4));
            Button button3 = new Button("Cancel");
            panel.add(button3);
            button3.addActionListener(new AWTConvenience.CloseAction(this.settingsDialog));
            aWTGridBagContainer.getConstraints().anchor = 13;
            aWTGridBagContainer.add(panel, 4, 0);
            this.settingsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button3));
            AWTConvenience.setBackgroundOfChildren(this.settingsDialog);
            AWTConvenience.setKeyListenerOfChildren(this.settingsDialog, new AWTConvenience.OKCancelAdapter(button2, button3), null);
            this.settingsDialog.setResizable(true);
            this.settingsDialog.pack();
        }
        this.client.propsHandler.clearServerSetting();
        this.textPort.setText(this.client.propsHandler.getProperty("port"));
        this.textUser.setText(this.client.propsHandler.getProperty("username"));
        this.cbSaveAlias.setState(false);
        object = this.client.propsHandler.getProperty("authtyp");
        if (((String)object).indexOf(44) == -1) {
            this.choiceAuthTyp.select((String)object);
        } else {
            this.choiceAuthTyp.select("custom list...");
            this.textAuthList.setText((String)object);
        }
        this.textId.setText(this.client.propsHandler.getProperty("idfile"));
        this.textPwd.setText("");
        this.updateChoices();
        AWTConvenience.placeDialog(this.settingsDialog);
        if (this.textSrv.isEnabled()) {
            this.textSrv.requestFocus();
        } else {
            this.textUser.requestFocus();
        }
        ((Component)this.settingsDialog).setVisible(true);
    }

    private Panel getAuthPanel() {
        this.authCP = new Panel();
        this.authCL = new CardLayout();
        this.authCP.setLayout(this.authCL);
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        panel.add(new Label("Password:"));
        this.textPwd = new TextField("", 16);
        panel.add(this.textPwd);
        this.textPwd.setEchoChar('*');
        this.authCP.add((Component)panel, "password");
        panel = new Panel(new FlowLayout(0, 0, 0));
        panel.add(new Label("Method list:"));
        this.textAuthList = new TextField("", 24);
        panel.add(this.textAuthList);
        this.authCP.add((Component)panel, "custom list...");
        panel = new Panel(new FlowLayout(0, 0, 0));
        panel.add(new Label("Identity:"));
        this.textId = new TextField("", 20);
        panel.add(this.textId);
        panel.add(new Panel());
        this.idFileBut = new Button("Browse...");
        panel.add(this.idFileBut);
        this.idFileBut.addActionListener(new Actions(5));
        this.authCP.add((Component)panel, "publickey");
        panel = new Panel(new FlowLayout());
        panel.add(new Label("Have SecurID token ready when connecting"));
        this.authCP.add((Component)panel, "securid");
        panel = new Panel(new FlowLayout());
        panel.add(new Label("Have CryptoCard token ready when connecting"));
        this.authCP.add((Component)panel, "cryptocard");
        panel = new Panel(new FlowLayout());
        panel.add(new Label("TIS challenge/response will occur when connecting"));
        this.authCP.add((Component)panel, "tis");
        panel = new Panel(new FlowLayout());
        panel.add(new Label("Generic keyboard interactive authentication"));
        this.authCP.add((Component)panel, "kbd-interact");
        return this.authCP;
    }

    private void checkSupportedByPeer() throws Exception {
        this.checkSupportedByPeer("enc-algorithms-cli2srv", this.choiceCipherC2S);
        this.checkSupportedByPeer("enc-algorithms-srv2cli", this.choiceCipherS2C);
        this.checkSupportedByPeer("mac-algorithms-cli2srv", this.choiceMacC2S);
        this.checkSupportedByPeer("mac-algorithms-srv2cli", this.choiceMacS2C);
        if (!this.choiceCompC2S.getSelectedItem().equals("none") && !this.client.transport.getPeerPreferences().isSupported("comp-algorithms-cli2srv", "zlib") || !this.choiceCompS2C.getSelectedItem().equals("none") && !this.client.transport.getPeerPreferences().isSupported("comp-algorithms-srv2cli", "zlib")) {
            throw new Exception("Peer doesn't support 'zlib'");
        }
    }

    private void checkSupportedByPeer(String string, Choice choice) throws Exception {
        if (choice.getSelectedIndex() == 0) {
            return;
        }
        String string2 = choice.getSelectedItem();
        if (!this.client.transport.getPeerPreferences().isSupported(string, string2)) {
            throw new Exception("Peer doesn't support: " + string2);
        }
    }

    private void updateChoices() {
        String string = this.choiceAuthTyp.getSelectedItem();
        this.authCL.show(this.authCP, string);
        if (this.cbSaveAlias.getState()) {
            String string2 = this.textAlias.getText();
            if (!(this.textAlias.isEnabled() || string2 != null && string2.trim().length() != 0)) {
                String string3 = this.textPort.getText().trim();
                this.textAlias.setText(this.textSrv.getText() + (string3.equals("22") ? "" : "_" + string3));
                this.textAlias.setEnabled(true);
                this.textAlias.requestFocus();
            }
        } else {
            this.textAlias.setText("");
            this.textAlias.setEnabled(false);
        }
    }

    public final void currentTunnelsDialog() {
        if (this.currentTunnelsDialog == null) {
            this.currentTunnelsDialog = new Dialog(this.parent, "MindTerm - Currently Open Tunnels", false);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(this.currentTunnelsDialog);
            Label label = new Label("Currently open tunnels:");
            aWTGridBagContainer.add(label, 0, 2);
            aWTGridBagContainer.getConstraints().fill = 1;
            this.currList = new List(8);
            aWTGridBagContainer.add(this.currList, 1, 10);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("Close Tunnel");
            panel.add(button);
            button.addActionListener(new Actions(6));
            button = new Button("Refresh");
            panel.add(button);
            button.addActionListener(new Actions(7));
            button = new Button("Close Dialog");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.currentTunnelsDialog));
            aWTGridBagContainer.getConstraints().anchor = 10;
            aWTGridBagContainer.add(panel, 2, 0);
            this.currentTunnelsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.currentTunnelsDialog);
            this.currentTunnelsDialog.setResizable(true);
            this.currentTunnelsDialog.pack();
        }
        this.refreshCurrList();
        AWTConvenience.placeDialog(this.currentTunnelsDialog);
        this.currList.requestFocus();
        ((Component)this.currentTunnelsDialog).setVisible(true);
    }

    void refreshCurrList() {
        this.currList.removeAll();
        String[] stringArray = this.client.listTunnels();
        for (int i = 0; i < stringArray.length; ++i) {
            this.currList.add(stringArray[i]);
        }
        if (stringArray.length > 0) {
            this.currList.select(0);
        }
    }

    public final void advancedTunnelsDialog() {
        if (this.tunnelDialog == null) {
            this.tunnelDialog = new Dialog(this.parent, "MindTerm - Advanced Tunnels Setup", true);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(this.tunnelDialog);
            aWTGridBagContainer.getConstraints().fill = 1;
            aWTGridBagContainer.getConstraints().weightx = 1.0;
            aWTGridBagContainer.getConstraints().weighty = 1.0;
            this.localEdit = new TunnelEditor("Local: ([/plug/][<loc-host>:]<loc-port>:<rem-host>:<rem-port>)", new Actions(8), new Actions(9));
            aWTGridBagContainer.add(this.localEdit, 0, 1);
            this.remoteEdit = new TunnelEditor("Remote: ([/plug/][<rem-host>:]<rem-port>:<loc-host>:<loc-port>)", new Actions(10), new Actions(11));
            aWTGridBagContainer.add(this.remoteEdit, 1, 1);
            Button button = new Button("Close Dialog");
            button.addActionListener(new AWTConvenience.CloseAction(this.tunnelDialog));
            aWTGridBagContainer.getConstraints().fill = 0;
            aWTGridBagContainer.getConstraints().anchor = 10;
            aWTGridBagContainer.getConstraints().weighty = 0.0;
            aWTGridBagContainer.add(button, 2, 1);
            this.tunnelDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.tunnelDialog);
            this.tunnelDialog.setResizable(true);
            this.tunnelDialog.pack();
        }
        this.updateAdvancedTunnelLists();
        AWTConvenience.placeDialog(this.tunnelDialog);
        ((Component)this.tunnelDialog).setVisible(true);
    }

    void updateAdvancedTunnelLists() {
        String string;
        Object object;
        int n;
        this.localEdit.removeAll();
        this.remoteEdit.removeAll();
        for (n = 0; n < this.client.localForwards.size(); ++n) {
            object = (SSHClient.LocalForward)this.client.localForwards.elementAt(n);
            string = ((SSHClient.LocalForward)object).plugin.equals("general") ? "" : "/" + ((SSHClient.LocalForward)object).plugin + "/";
            this.localEdit.addToList(string + ((SSHClient.LocalForward)object).localHost + ":" + ((SSHClient.LocalForward)object).localPort + ":" + ((SSHClient.LocalForward)object).remoteHost + ":" + ((SSHClient.LocalForward)object).remotePort);
        }
        for (n = 0; n < this.client.remoteForwards.size(); ++n) {
            object = (SSHClient.RemoteForward)this.client.remoteForwards.elementAt(n);
            string = ((SSHClient.RemoteForward)object).plugin.equals("general") ? "" : "/" + ((SSHClient.RemoteForward)object).plugin + "/";
            this.remoteEdit.addToList(string + ((SSHClient.RemoteForward)object).remotePort + ":" + ((SSHClient.RemoteForward)object).localHost + ":" + ((SSHClient.RemoteForward)object).localPort);
        }
    }

    public final void connectDialog() {
        Object object;
        if (this.connectDialog == null) {
            this.connectDialog = new Dialog(this.parent, "MindTerm - Connect", true);
            object = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.connectDialog.setLayout((LayoutManager)object);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(8, 8, 0, 8);
            Label label = new Label("Available hosts/aliases:");
            ((GridBagLayout)object).setConstraints(label, gridBagConstraints);
            this.connectDialog.add(label);
            gridBagConstraints.gridy = 1;
            label = new Label("(dir: " + this.client.propsHandler.getSSHHomeDir() + ")");
            ((GridBagLayout)object).setConstraints(label, gridBagConstraints);
            this.connectDialog.add(label);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            gridBagConstraints.gridy = 2;
            this.hostList = new List(8);
            ((GridBagLayout)object).setConstraints(this.hostList, gridBagConstraints);
            this.connectDialog.add(this.hostList);
            Actions actions = new Actions(12);
            this.hostList.addActionListener(actions);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("Connect");
            panel.add(button);
            button.addActionListener(actions);
            button = new Button("New Server");
            panel.add(button);
            button.addActionListener(new Actions(13));
            button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.connectDialog));
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 10;
            ((GridBagLayout)object).setConstraints(panel, gridBagConstraints);
            this.connectDialog.add(panel);
            this.connectDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.connectDialog);
            this.connectDialog.setResizable(true);
            this.connectDialog.pack();
        }
        this.hostList.removeAll();
        object = this.client.propsHandler.availableAliases();
        if (object != null) {
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.hostList.add(object[i]);
            }
        }
        this.hostList.select(0);
        this.connectDialog.pack();
        AWTConvenience.placeDialog(this.connectDialog);
        this.hostList.requestFocus();
        ((Component)this.connectDialog).setVisible(true);
        if (this.wantToRunSettingsDialog) {
            this.wantToRunSettingsDialog = false;
            this.sshSettingsDialog();
        }
    }

    public final void loadFileDialog() {
        if (this.loadFileDialog == null) {
            this.loadFileDialog = new FileDialog(this.parent, "MindTerm - Select file to load settings from", 0);
        }
        this.loadFileDialog.setDirectory(this.client.propsHandler.getSSHHomeDir());
        ((Component)this.loadFileDialog).setVisible(true);
        String string = this.loadFileDialog.getFile();
        String string2 = this.loadFileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            try {
                String string3 = "";
                while (true) {
                    try {
                        this.client.propsHandler.setPropertyPassword(string3);
                        this.client.propsHandler.loadAbsoluteFile(string2 + string, false);
                        this.client.quiet = true;
                        this.client.sshStdIO.breakPromptLine("Loaded new settings: " + string);
                    }
                    catch (SSHClient.AuthFailException authFailException) {
                        if ((string3 = this.passwordDialog("Please give password for " + string, "MindTerm - File Password")) != null) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.alertDialog("Error loading settings: " + throwable.getMessage());
            }
        }
    }

    public final void saveAsFileDialog() {
        if (this.saveAsFileDialog == null) {
            this.saveAsFileDialog = new FileDialog(this.parent, "MindTerm - Select file to save settings to", 1);
        }
        this.saveAsFileDialog.setDirectory(this.client.propsHandler.getSSHHomeDir());
        String string = this.client.propsHandler.currentAlias;
        if (string == null) {
            string = this.client.propsHandler.getProperty("server");
        }
        SSHPropertyHandler cfr_ignored_0 = this.client.propsHandler;
        this.saveAsFileDialog.setFile(string + ".mtp");
        ((Component)this.saveAsFileDialog).setVisible(true);
        String string2 = this.saveAsFileDialog.getFile();
        String string3 = this.saveAsFileDialog.getDirectory();
        if (string2 != null && string2.length() > 0) {
            try {
                if (this.client.propsHandler.savePasswords) {
                    String string4 = this.setPasswordDialog("Please set password for " + string2, "MindTerm - Set File Password");
                    if (string4 == null) {
                        return;
                    }
                    this.client.propsHandler.setPropertyPassword(string4);
                }
                this.client.propsHandler.saveAsCurrentFile(string3 + string2);
            }
            catch (Throwable throwable) {
                this.alertDialog("Error saving settings: " + throwable.getMessage());
            }
        }
    }

    public final void alertDialog(String string) {
        SSHMiscDialogs.alert("MindTerm - Alert", string, this.parent);
    }

    public final String passwordDialog(String string, String string2) {
        return SSHMiscDialogs.password(string2, string, this.parent);
    }

    public final String setPasswordDialog(String string, String string2) {
        return SSHMiscDialogs.setPassword(string2, string, this.parent);
    }

    public final boolean confirmDialog(String string, boolean bl) {
        return SSHMiscDialogs.confirm("MindTerm - Confirmation", string, bl, this.parent);
    }

    public final void textDialog(String string, String string2, int n, int n2, boolean bl) {
        SSHMiscDialogs.notice(string, string2, n, n2, bl, this.parent);
    }

    public static void about(Frame frame, SSHInteractiveClient sSHInteractiveClient) {
        Dialog dialog = null;
        dialog = new Dialog(frame, "About " + SSH.VER_MINDTERM, true);
        AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(dialog);
        aWTGridBagContainer.getConstraints().anchor = 10;
        Logo logo = sSHInteractiveClient.getLogo();
        if (logo != null) {
            aWTGridBagContainer.add(logo, 0, 0);
        }
        TextArea textArea = new TextArea(aboutText, 12, 40, 1);
        textArea.setEditable(false);
        aWTGridBagContainer.add(textArea, 1, 0);
        Button button = new Button("OK");
        button.addActionListener(new AWTConvenience.CloseAction(dialog));
        aWTGridBagContainer.getConstraints().fill = 0;
        aWTGridBagContainer.add(button, 2, 0);
        dialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
        AWTConvenience.setBackgroundOfChildren(dialog);
        dialog.setResizable(true);
        dialog.pack();
        AWTConvenience.placeDialog(dialog);
        button.requestFocus();
        ((Component)dialog).setVisible(true);
    }

    protected class TunnelEditor
    extends Panel {
        List list;
        TextField text;

        public TunnelEditor(String string, ActionListener actionListener, ActionListener actionListener2) {
            super(new BorderLayout(5, 5));
            this.add((Component)new Label(string), "North");
            this.list = new List(5, false);
            this.add((Component)this.list, "Center");
            Panel panel = new Panel(new FlowLayout());
            this.text = new TextField("", 26);
            panel.add(this.text);
            Button button = new Button("Add");
            panel.add(button);
            button.addActionListener(actionListener);
            button = new Button("Delete");
            panel.add(button);
            button.addActionListener(actionListener2);
            this.add((Component)panel, "South");
            this.list.addActionListener(new Actions(0, this.text, this.list));
        }

        public int getItemCount() {
            return this.list.getItemCount();
        }

        public String getItem(int n) {
            return this.list.getItem(n);
        }

        public void addToList(String string) {
            this.list.add(string);
        }

        public int getSelectedIndex() {
            return this.list.getSelectedIndex();
        }

        public void selectText() {
            this.text.selectAll();
        }

        public String getText() {
            return this.text.getText();
        }

        public void removeAll() {
            this.list.removeAll();
        }
    }

    private class Actions
    implements ActionListener,
    ItemListener {
        private int action;
        private TextField text;
        private List list;

        public Actions(int n, TextField textField, List list) {
            this(n);
            this.text = textField;
            this.list = list;
        }

        public Actions(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block7 : switch (this.action) {
                case 0: {
                    this.text.setText(this.list.getSelectedItem());
                    this.text.requestFocus();
                    break;
                }
                case 1: {
                    try {
                        boolean bl;
                        String string = SSHMenuHandlerFull.this.choiceCipherC2S.getSelectedItem();
                        String string2 = SSHMenuHandlerFull.this.choiceCipherS2C.getSelectedItem();
                        boolean bl2 = bl = SSHMenuHandlerFull.this.client.isConnected() && SSHMenuHandlerFull.this.client.isSSH2 && !SSHMenuHandlerFull.this.client.transport.incompatibleCantReKey;
                        if (bl) {
                            SSHMenuHandlerFull.this.checkSupportedByPeer();
                        }
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("protocol", SSHMenuHandlerFull.this.choiceProto.getSelectedItem());
                        if (SSHMenuHandlerFull.this.choiceHKey.getSelectedIndex() > 0) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("server-host-key-algorithms", SSHMenuHandlerFull.this.choiceHKey.getSelectedItem());
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.resetProperty("server-host-key-algorithms");
                        }
                        if (SSHMenuHandlerFull.this.choiceCipherC2S.getSelectedIndex() > 0) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("enc-algorithms-cli2srv", string);
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("cipher", string);
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.resetProperty("enc-algorithms-cli2srv");
                            SSHMenuHandlerFull.this.client.propsHandler.resetProperty("cipher");
                        }
                        if (SSHMenuHandlerFull.this.choiceCipherS2C.getSelectedIndex() > 0) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("enc-algorithms-srv2cli", string2);
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.resetProperty("enc-algorithms-srv2cli");
                        }
                        if (SSHMenuHandlerFull.this.choiceMacC2S.getSelectedIndex() > 0) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("mac-algorithms-cli2srv", SSHMenuHandlerFull.this.choiceMacC2S.getSelectedItem());
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.resetProperty("mac-algorithms-cli2srv");
                        }
                        if (SSHMenuHandlerFull.this.choiceMacS2C.getSelectedIndex() > 0) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("mac-algorithms-srv2cli", SSHMenuHandlerFull.this.choiceMacS2C.getSelectedItem());
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.resetProperty("mac-algorithms-srv2cli");
                        }
                        int n = comp2lvl[SSHMenuHandlerFull.this.choiceCompC2S.getSelectedIndex()];
                        if (n > 0) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("comp-algorithms-cli2srv", "zlib");
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("comp-algorithms-cli2srv", "none");
                        }
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("compression", String.valueOf(n));
                        n = SSHMenuHandlerFull.this.choiceCompS2C.getSelectedIndex();
                        if (n > 0) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("comp-algorithms-srv2cli", "zlib");
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("comp-algorithms-srv2cli", "none");
                        }
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("display", SSHMenuHandlerFull.this.textDisp.getText());
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("x11fwd", String.valueOf(SSHMenuHandlerFull.this.cbX11.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("stricthostid", String.valueOf(SSHMenuHandlerFull.this.cbIdHost.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("key-timing-noise", String.valueOf(SSHMenuHandlerFull.this.cbKeyNoise.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("forcpty", String.valueOf(SSHMenuHandlerFull.this.cbForcPty.getState()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("localhst", String.valueOf(SSHMenuHandlerFull.this.textLocHost.getText()));
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("alive", SSHMenuHandlerFull.this.textAlive.getText());
                        if (bl) {
                            SSH2Preferences sSH2Preferences = new SSH2Preferences(SSHMenuHandlerFull.this.client.propsHandler.getProperties());
                            SSHMenuHandlerFull.this.client.transport.startKeyExchange(sSH2Preferences);
                        }
                        ((Component)SSHMenuHandlerFull.this.settingsDialog2).setVisible(false);
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.alertDialog("Error: " + exception.getMessage());
                    }
                    break;
                }
                case 2: {
                    SSHProxyDialog.show("MindTerm - Proxy Settings", SSHMenuHandlerFull.this.parent, SSHMenuHandlerFull.this.client.propsHandler);
                    break;
                }
                case 3: {
                    SSHMenuHandlerFull.this.sshSettingsDialog2();
                    break;
                }
                case 4: {
                    try {
                        String string;
                        String string3;
                        String string4 = null;
                        string4 = SSHMenuHandlerFull.this.textSrv.getText();
                        if (string4.length() == 0) {
                            SSHMenuHandlerFull.this.alertDialog("Please specify a server to connect to");
                            return;
                        }
                        if (SSHMenuHandlerFull.this.cbSaveAlias.getState()) {
                            string3 = SSHMenuHandlerFull.this.textAlias.getText();
                            if (string3 == null || string3.trim().length() == 0) {
                                SSHMenuHandlerFull.this.alertDialog("Please specify an alias name for these settings");
                                return;
                            }
                            if (SSHMenuHandlerFull.this.client.propsHandler.savePasswords) {
                                string = SSHMenuHandlerFull.this.setPasswordDialog("Please set password for alias " + string4, "MindTerm - Set File Password");
                                if (string == null) {
                                    return;
                                }
                                SSHMenuHandlerFull.this.client.propsHandler.setPropertyPassword(string);
                            }
                            SSHMenuHandlerFull.this.client.propsHandler.setAlias(string3);
                        }
                        SSHMenuHandlerFull.this.client.quiet = true;
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("server", string4);
                        string3 = SSHMenuHandlerFull.this.client.propsHandler.getProperty("prxpassword");
                        SSHMenuHandlerFull.this.client.propsHandler.clearPasswords();
                        if (string3 != null) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("prxpassword", string3);
                        }
                        SSHMenuHandlerFull.this.client.propsHandler.clearAllForwards();
                        string = SSHMenuHandlerFull.this.choiceAuthTyp.getSelectedItem();
                        if (string.equals("custom list...")) {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("authtyp", SSHMenuHandlerFull.this.textAuthList.getText());
                        } else {
                            SSHMenuHandlerFull.this.client.propsHandler.setProperty("authtyp", string);
                        }
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("port", SSHMenuHandlerFull.this.textPort.getText());
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("usrname", SSHMenuHandlerFull.this.textUser.getText());
                        String string5 = SSHMenuHandlerFull.this.textPwd.getText();
                        if (string5.length() == 0) {
                            string5 = null;
                        }
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("password", string5);
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("idfile", SSHMenuHandlerFull.this.textId.getText());
                        SSHMenuHandlerFull.this.client.sshStdIO.breakPromptLine();
                        ((Component)SSHMenuHandlerFull.this.settingsDialog).setVisible(false);
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.alertDialog("Error: " + exception.getMessage());
                    }
                    break;
                }
                case 5: {
                    if (SSHMenuHandlerFull.this.idFileFD == null) {
                        SSHMenuHandlerFull.this.idFileFD = new FileDialog(SSHMenuHandlerFull.this.parent, "MindTerm - Select file with identity (private)", 0);
                        SSHMenuHandlerFull.this.idFileFD.setDirectory(SSHMenuHandlerFull.this.client.propsHandler.getSSHHomeDir());
                    }
                    ((Component)SSHMenuHandlerFull.this.idFileFD).setVisible(true);
                    if (SSHMenuHandlerFull.this.idFileFD.getFile() == null || SSHMenuHandlerFull.this.idFileFD.getFile().length() <= 0) break;
                    SSHMenuHandlerFull.this.textId.setText(SSHMenuHandlerFull.this.idFileFD.getDirectory() + SSHMenuHandlerFull.this.idFileFD.getFile());
                    break;
                }
                case 6: {
                    int n = SSHMenuHandlerFull.this.currList.getSelectedIndex();
                    if (n == -1) {
                        SSHMenuHandlerFull.this.term.doBell();
                        return;
                    }
                    SSHMenuHandlerFull.this.client.closeTunnelFromList(n);
                    Thread.yield();
                    SSHMenuHandlerFull.this.refreshCurrList();
                    break;
                }
                case 7: {
                    SSHMenuHandlerFull.this.refreshCurrList();
                    break;
                }
                case 8: {
                    try {
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("local" + SSHMenuHandlerFull.this.client.localForwards.size(), SSHMenuHandlerFull.this.localEdit.getText());
                        SSHMenuHandlerFull.this.updateAdvancedTunnelLists();
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.localEdit.selectText();
                    }
                    break;
                }
                case 9: {
                    int n = SSHMenuHandlerFull.this.localEdit.getSelectedIndex();
                    if (n == -1) break;
                    SSHMenuHandlerFull.this.client.propsHandler.removeLocalTunnelAt(n, true);
                    SSHMenuHandlerFull.this.updateAdvancedTunnelLists();
                    break;
                }
                case 10: {
                    try {
                        SSHMenuHandlerFull.this.client.propsHandler.setProperty("remote" + SSHMenuHandlerFull.this.client.remoteForwards.size(), SSHMenuHandlerFull.this.remoteEdit.getText());
                        SSHMenuHandlerFull.this.updateAdvancedTunnelLists();
                    }
                    catch (Exception exception) {
                        SSHMenuHandlerFull.this.remoteEdit.selectText();
                    }
                    break;
                }
                case 11: {
                    int n = SSHMenuHandlerFull.this.remoteEdit.getSelectedIndex();
                    if (SSHMenuHandlerFull.this.remoteEdit.getItem(n).indexOf("#FTP") != -1) {
                        return;
                    }
                    if (n == -1) break;
                    SSHMenuHandlerFull.this.client.propsHandler.removeRemoteTunnelAt(n);
                    SSHMenuHandlerFull.this.updateAdvancedTunnelLists();
                    break;
                }
                case 12: {
                    String string = SSHMenuHandlerFull.this.hostList.getSelectedItem();
                    try {
                        String string6 = "";
                        while (true) {
                            try {
                                SSHMenuHandlerFull.this.client.propsHandler.setPropertyPassword(string6);
                                SSHMenuHandlerFull.this.client.propsHandler.loadAliasFile(string, false);
                                SSHMenuHandlerFull.this.client.quiet = true;
                                SSHMenuHandlerFull.this.client.sshStdIO.breakPromptLine();
                                ((Component)SSHMenuHandlerFull.this.connectDialog).setVisible(false);
                                break block7;
                            }
                            catch (SSHClient.AuthFailException authFailException) {
                                if ((string6 = SSHMenuHandlerFull.this.passwordDialog("Please give file password for " + string, "MindTerm - File Password")) != null) continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        SSHMenuHandlerFull.this.alertDialog("Error loading settings: " + throwable.getMessage());
                    }
                    break;
                }
                case 13: {
                    ((Component)SSHMenuHandlerFull.this.connectDialog).setVisible(false);
                    try {
                        SSHMenuHandlerFull.this.client.propsHandler.checkSave();
                    }
                    catch (Throwable throwable) {
                        SSHMenuHandlerFull.this.alertDialog("Error saving settings: " + throwable.getMessage());
                    }
                    SSHMenuHandlerFull.this.client.propsHandler.clearServerSetting();
                    SSHMenuHandlerFull.this.wantToRunSettingsDialog = true;
                    ((Component)SSHMenuHandlerFull.this.connectDialog).setVisible(false);
                    break;
                }
                default: {
                    if (this.action < 32) break;
                    SSHMenuHandlerFull.this.modules[this.action - 32].activate(SSHMenuHandlerFull.this.client);
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            switch (this.action) {
                case 14: {
                    SSHMenuHandlerFull.this.updateChoices2();
                    break;
                }
                case 15: {
                    SSHMenuHandlerFull.this.choiceCipherS2C.select((String)itemEvent.getItem());
                    break;
                }
                case 16: {
                    SSHMenuHandlerFull.this.choiceMacS2C.select((String)itemEvent.getItem());
                    break;
                }
                case 17: {
                    if ("none".equals(itemEvent.getItem())) {
                        SSHMenuHandlerFull.this.choiceCompS2C.select("none");
                        break;
                    }
                    SSHMenuHandlerFull.this.choiceCompS2C.select("medium");
                    break;
                }
                case 18: {
                    SSHMenuHandlerFull.this.updateChoices();
                }
            }
        }
    }
}

