/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSHCipher;
import com.mindbright.ssh.SSHCompressor;
import com.mindbright.ssh.SSHDataOutputStream;
import com.mindbright.ssh.SSHPdu;
import com.mindbright.util.CRC32;
import com.mindbright.util.SecureRandomAndPad;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SSHPduOutputStream
extends SSHDataOutputStream
implements SSHPdu {
    public static final int SSH_DEFAULT_PKT_LEN = 8192;
    public static int mtu = 8192;
    byte[] readFromRawData;
    int readFromOff;
    int readFromSize;
    public int type;
    public SSHCipher cipher;
    public SSHCompressor compressor;
    public SecureRandomAndPad rand;

    public static synchronized void setMTU(int n) {
        mtu = n;
    }

    SSHPduOutputStream(SSHCipher sSHCipher, SSHCompressor sSHCompressor, SecureRandomAndPad secureRandomAndPad) {
        super(null);
        this.cipher = sSHCipher;
        this.compressor = sSHCompressor;
        this.rand = secureRandomAndPad;
    }

    SSHPduOutputStream(int n, SSHCipher sSHCipher, SSHCompressor sSHCompressor, SecureRandomAndPad secureRandomAndPad) throws IOException {
        super(new PduByteArrayOutputStream(mtu));
        this.type = n;
        this.cipher = sSHCipher;
        this.compressor = sSHCompressor;
        this.rand = secureRandomAndPad;
        if (sSHCipher != null) {
            PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
            secureRandomAndPad.nextPadBytes(pduByteArrayOutputStream.getBuf(), 0, 8);
            pduByteArrayOutputStream.setCount(8);
        } else {
            for (int i = 0; i < 8; ++i) {
                this.write(0);
            }
        }
        this.write(n);
    }

    public SSHPdu createPdu() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(this.type, this.cipher, this.compressor, this.rand);
        return sSHPduOutputStream;
    }

    public void readFrom(InputStream inputStream) throws IOException {
        if (this.type != 23 && this.type != 16) {
            throw new IOException("Trying to read raw data into non-data PDU");
        }
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        this.readFromRawData = pduByteArrayOutputStream.getBuf();
        this.readFromOff = pduByteArrayOutputStream.size() + 4;
        this.readFromSize = inputStream.read(this.readFromRawData, this.readFromOff, mtu - this.readFromOff);
        if (this.readFromSize == -1) {
            throw new IOException("EOF");
        }
        this.writeInt(this.readFromSize);
        pduByteArrayOutputStream.setCount(this.readFromOff + this.readFromSize);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        if (this.compressor != null) {
            this.compressor.compress(this);
        }
        int n = pduByteArrayOutputStream.size();
        int n2 = (n + 4) % 8;
        int n3 = (int)CRC32.getValue(pduByteArrayOutputStream.getBuf(), n2, n - n2);
        int n4 = n + 4 - n2;
        this.writeInt(n3);
        byte[] byArray = pduByteArrayOutputStream.getBuf();
        if (this.cipher != null) {
            this.cipher.encrypt(byArray, n2, byArray, n2, n4);
        }
        int n5 = n4 - (8 - n2);
        outputStream.write(n5 >>> 24 & 0xFF);
        outputStream.write(n5 >>> 16 & 0xFF);
        outputStream.write(n5 >>> 8 & 0xFF);
        outputStream.write(n5 >>> 0 & 0xFF);
        outputStream.write(byArray, n2, n4);
        outputStream.flush();
    }

    public PduByteArrayOutputStream getOut() {
        return (PduByteArrayOutputStream)this.out;
    }

    public byte[] rawData() {
        return this.readFromRawData;
    }

    public void rawSetData(byte[] byArray) {
    }

    public int rawOffset() {
        return this.readFromOff;
    }

    public int rawSize() {
        byte[] byArray = this.readFromRawData;
        int n = this.readFromOff - 4;
        int n2 = byArray[n++] + 256 & 0xFF;
        int n3 = byArray[n++] + 256 & 0xFF;
        int n4 = byArray[n++] + 256 & 0xFF;
        int n5 = byArray[n] + 256 & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public void rawAdjustSize(int n) {
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        pduByteArrayOutputStream.setCount(n);
    }

    public static final class PduByteArrayOutputStream
    extends ByteArrayOutputStream {
        PduByteArrayOutputStream() {
        }

        PduByteArrayOutputStream(int n) {
            super(n);
        }

        PduByteArrayOutputStream(byte[] byArray) {
            this.buf = byArray;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }

        public void setBuf(byte[] byArray) {
            this.buf = byArray;
        }

        public void setCount(int n) {
            this.count = n;
        }
    }
}

