/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHPropertyHandler;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public final class SSHProxyDialog {
    private static Dialog proxyDialog = null;
    private static Choice choicePrxType;
    private static Checkbox cbNeedAuth;
    private static TextField textPrxHost;
    private static TextField textPrxPort;
    private static TextField textPrxUser;
    private static TextField textPrxPasswd;
    private static String[] prxTypes;
    private static SSHPropertyHandler propsHandler;

    public static void show(String string, Frame frame, SSHPropertyHandler sSHPropertyHandler) {
        Object object;
        Object object2;
        propsHandler = sSHPropertyHandler;
        if (proxyDialog == null) {
            prxTypes = SSH.getProxyTypes();
            proxyDialog = new Dialog(frame, string, true);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(proxyDialog);
            aWTGridBagContainer.getConstraints().fill = 2;
            aWTGridBagContainer.getConstraints().anchor = 17;
            aWTGridBagContainer.getConstraints().insets = new Insets(4, 4, 0, 4);
            object2 = new Label("Proxy type:");
            aWTGridBagContainer.add((Component)object2, 0, 2);
            choicePrxType = AWTConvenience.newChoice(prxTypes);
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getSource() == choicePrxType) {
                        textPrxPort.setText(String.valueOf(SSH.defaultProxyPorts[SSH.getProxyType(choicePrxType.getSelectedItem())]));
                    }
                    SSHProxyDialog.updateFromType();
                }
            };
            choicePrxType.addItemListener(itemListener);
            aWTGridBagContainer.add(choicePrxType, 0, 2);
            object2 = new Label("Server:");
            aWTGridBagContainer.add((Component)object2, 1, 2);
            textPrxHost = new TextField("", 16);
            aWTGridBagContainer.add(textPrxHost, 1, 4);
            object2 = new Label("Port:");
            aWTGridBagContainer.add((Component)object2, 1, 1);
            textPrxPort = new TextField("", 4);
            aWTGridBagContainer.add(textPrxPort, 1, 1);
            object2 = new Label("Username:");
            aWTGridBagContainer.add((Component)object2, 2, 2);
            textPrxUser = new TextField("", 10);
            aWTGridBagContainer.add(textPrxUser, 2, 2);
            object2 = new Label("Password:");
            aWTGridBagContainer.add((Component)object2, 2, 2);
            textPrxPasswd = new TextField("", 10);
            textPrxPasswd.setEchoChar('*');
            aWTGridBagContainer.add(textPrxPasswd, 2, 2);
            cbNeedAuth = new Checkbox("Need authentication");
            aWTGridBagContainer.add(cbNeedAuth, 3, 4);
            cbNeedAuth.addItemListener(itemListener);
            Panel panel = new Panel(new FlowLayout());
            object = new Button("OK");
            panel.add((Component)object);
            ((Button)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String string = choicePrxType.getSelectedItem();
                        propsHandler.setProperty("proxytype", string);
                        if (!"none".equalsIgnoreCase(string)) {
                            propsHandler.setProperty("proxyhost", textPrxHost.getText());
                            propsHandler.setProperty("proxyport", textPrxPort.getText());
                        }
                        if (cbNeedAuth.getState()) {
                            propsHandler.setProperty("proxyuser", textPrxUser.getText());
                            propsHandler.setProperty("prxpassword", textPrxPasswd.getText());
                        } else if ("socks4".equals(string)) {
                            propsHandler.setProperty("proxyuser", textPrxUser.getText());
                        }
                        ((Component)proxyDialog).setVisible(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            object = new Button("Cancel");
            panel.add((Component)object);
            ((Button)object).addActionListener(new AWTConvenience.CloseAction(proxyDialog));
            aWTGridBagContainer.getConstraints().anchor = 10;
            aWTGridBagContainer.getConstraints().fill = 0;
            aWTGridBagContainer.add(panel, 4, 0);
            proxyDialog.addWindowListener(new AWTConvenience.CloseAdapter((Button)object));
            AWTConvenience.setBackgroundOfChildren(proxyDialog);
            proxyDialog.setResizable(true);
            proxyDialog.pack();
        }
        proxyDialog.setTitle(string);
        object2 = propsHandler.getProperty("proxytype");
        choicePrxType.select((String)object2);
        object = propsHandler.getProperty("proxyuser");
        boolean bl = object != null && ((String)object).trim().length() > 0;
        cbNeedAuth.setState(bl);
        textPrxHost.setText(propsHandler.getProperty("proxyhost"));
        textPrxPort.setText(propsHandler.getProperty("proxyport"));
        textPrxUser.setText(propsHandler.getProperty("proxyuser"));
        SSHProxyDialog.updateFromType();
        AWTConvenience.placeDialog(proxyDialog);
        ((Component)proxyDialog).setVisible(true);
    }

    private static void updateFromType() {
        boolean bl = false;
        boolean bl2 = false;
        String string = choicePrxType.getSelectedItem();
        int n = 0;
        try {
            n = SSH.getProxyType(string);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    bl2 = true;
                }
                case 2: {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        textPrxHost.setEnabled(bl);
        textPrxPort.setEnabled(bl);
        cbNeedAuth.setEnabled(bl2);
        if (!bl2) {
            cbNeedAuth.setState(false);
        }
        boolean bl3 = cbNeedAuth.getState();
        textPrxUser.setEnabled(bl3);
        textPrxPasswd.setEnabled(bl3);
        if (bl) {
            if (textPrxHost.getText().length() == 0) {
                textPrxHost.setText(propsHandler.getProperty("proxyhost"));
            }
            if (textPrxPort.getText().length() == 0) {
                textPrxPort.setText(propsHandler.getProperty("proxyport"));
            }
        } else {
            textPrxHost.setText("");
            textPrxPort.setText("");
        }
        if (bl3) {
            if (textPrxUser.getText().length() == 0) {
                textPrxUser.setText(propsHandler.getProperty("proxyuser"));
            }
        } else {
            textPrxUser.setText("");
            textPrxPasswd.setText("");
        }
        if (n == 2) {
            textPrxUser.setEnabled(true);
            String string2 = propsHandler.getProperty("proxyuser");
            if (textPrxUser.getText().length() == 0) {
                if (string2 == null) {
                    string2 = "anonymous";
                }
                textPrxUser.setText(string2);
            }
        }
        if (bl) {
            textPrxHost.requestFocus();
        }
    }
}

