/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.security.publickey.RSAPublicKey;
import com.mindbright.ssh.SSHDataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SSHRSAPublicKeyString
extends RSAPublicKey {
    String user;
    String opts;

    public SSHRSAPublicKeyString(String string, String string2, BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger2, bigInteger);
        this.opts = string;
        this.user = string2;
    }

    public static SSHRSAPublicKeyString createKey(String string, String string2) throws NoSuchElementException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = null;
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
        }
        return new SSHRSAPublicKeyString(string, string3, new BigInteger(string5), new BigInteger(string6));
    }

    public String getOpts() {
        return this.opts;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        int n = this.getModulus().bitLength();
        return (this.opts != null ? this.opts + " " : "") + n + " " + this.getPublicExponent() + " " + this.getModulus() + " " + (this.user != null ? this.user : "");
    }

    public void toFile(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        SSHDataOutputStream sSHDataOutputStream = new SSHDataOutputStream(fileOutputStream);
        sSHDataOutputStream.writeBytes(this.toString());
        sSHDataOutputStream.close();
    }
}

