/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSH;
import com.mindbright.ssh.SSHChannel;
import com.mindbright.ssh.SSHChannelController;
import com.mindbright.ssh.SSHChannelListener;
import com.mindbright.ssh.SSHPdu;
import com.mindbright.ssh.SSHPduOutputStream;
import com.mindbright.ssh.SSHRxChannel;
import com.mindbright.ssh.SSHTxChannel;
import com.mindbright.util.Queue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;

public class SSHTunnel
implements SSHChannelListener {
    int channelId;
    int remoteChannelId;
    boolean sentInputEOF;
    boolean sentOutputClosed;
    boolean receivedInputEOF;
    boolean receivedOutputClosed;
    protected SSHChannelController controller;
    protected Socket ioSocket;
    protected SSHTxChannel txChan;
    protected SSHRxChannel rxChan;
    protected Queue txQueue;
    protected String remoteDesc;

    public SSHTunnel(Socket socket, int n, int n2, SSHChannelController sSHChannelController) throws IOException {
        this.ioSocket = socket;
        this.channelId = n;
        this.remoteChannelId = n2;
        this.controller = sSHChannelController;
        this.sentInputEOF = false;
        this.sentOutputClosed = false;
        this.receivedInputEOF = false;
        this.receivedOutputClosed = false;
        if (socket != null) {
            try {
                this.rxChan = new SSHRxChannel(new BufferedInputStream(socket.getInputStream(), 8192), n);
                this.txChan = new SSHTxChannel(new BufferedOutputStream(socket.getOutputStream()), n);
            }
            catch (Exception exception) {
                throw new IOException("Could not create tunnel: " + exception.toString());
            }
            this.txQueue = this.txChan.getQueue();
            this.rxChan.setSSHPduFactory(new SSHPduOutputStream(23, sSHChannelController.sndCipher, sSHChannelController.sndComp, SSH.secureRandom()));
            this.txChan.setSSHChannelListener(this);
            this.rxChan.setSSHChannelListener(this);
        }
    }

    public int getLocalPort() {
        if (this.ioSocket != null) {
            return this.ioSocket.getLocalPort();
        }
        return 0;
    }

    public String getLocalHost() {
        if (this.ioSocket != null) {
            return this.ioSocket.getLocalAddress().getHostAddress();
        }
        return "N/A";
    }

    public boolean isOpen() {
        return this.remoteChannelId != -4;
    }

    public boolean setRemoteChannelId(int n) {
        if (this.isOpen()) {
            return false;
        }
        this.remoteChannelId = n;
        return true;
    }

    public void start() {
        this.txChan.start();
        this.rxChan.start();
    }

    public void openFailure() {
        if (this.ioSocket != null) {
            try {
                this.ioSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public SSHPdu prepare(SSHPdu sSHPdu) throws IOException {
        ((SSHPduOutputStream)sSHPdu).writeInt(this.remoteChannelId);
        return sSHPdu;
    }

    public void receive(SSHPdu sSHPdu) {
        this.controller.transmit(sSHPdu);
    }

    public void transmit(SSHPdu sSHPdu) {
        this.txQueue.putLast(sSHPdu);
    }

    public void close(SSHChannel sSHChannel) {
        if (sSHChannel == null || sSHChannel instanceof SSHTxChannel) {
            this.sendOutputClosed();
            try {
                this.ioSocket.close();
            }
            catch (IOException iOException) {
                this.controller.alert("Error closing socket for: " + this.channelId + " : " + iOException.toString());
            }
        } else {
            this.sendInputEOF();
        }
        this.checkTermination();
    }

    public synchronized void terminateNow() {
        this.close(null);
    }

    public synchronized void checkTermination() {
        if (this.sentInputEOF && this.sentOutputClosed && this.receivedInputEOF && this.receivedOutputClosed) {
            this.controller.delTunnel(this.channelId);
            if (this.txChan != null && this.txChan.isAlive()) {
                this.txChan.stop();
            }
            if (this.rxChan != null && this.rxChan.isAlive()) {
                this.rxChan.stop();
            }
        }
    }

    public void sendOutputClosed() {
        if (this.sentOutputClosed) {
            return;
        }
        try {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(25, this.controller.sndCipher, this.controller.sndComp, SSH.secureRandom());
            sSHPduOutputStream.writeInt(this.remoteChannelId);
            this.controller.transmit(sSHPduOutputStream);
            this.sentOutputClosed = true;
        }
        catch (Exception exception) {
            this.controller.alert("Error sending output-closed: " + exception.toString());
        }
    }

    public void sendInputEOF() {
        if (this.sentInputEOF) {
            return;
        }
        try {
            SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(24, this.controller.sndCipher, this.controller.sndComp, SSH.secureRandom());
            sSHPduOutputStream.writeInt(this.remoteChannelId);
            this.controller.transmit(sSHPduOutputStream);
            this.sentInputEOF = true;
        }
        catch (Exception exception) {
            this.controller.alert("Error sending input-EOF: " + exception.toString());
        }
    }

    public void receiveOutputClosed() {
        if (this.rxChan != null) {
            this.rxChan.stop();
        }
        this.receivedOutputClosed = true;
        this.sendInputEOF();
        this.checkTermination();
    }

    public void receiveInputEOF() {
        if (this.txChan != null) {
            this.txChan.setClosePending();
        }
        this.receivedInputEOF = true;
        this.checkTermination();
    }

    public void setRemoteDesc(String string) {
        this.remoteDesc = string;
    }

    public String getDescription() {
        if (this.ioSocket != null) {
            return this.ioSocket.getInetAddress().getHostAddress() + ":" + this.ioSocket.getPort() + " <--> " + this.getLocalHost() + ":" + this.ioSocket.getLocalPort() + " <-ssh-> " + this.remoteDesc;
        }
        return "< N/A >";
    }
}

