/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.ssh.SSHClient;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh.SSHPropertyHandler;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public final class SSHTunnelDialog {
    protected static final int ACT_LIST_CLICK = 0;
    protected static final int ACT_ADD = 1;
    protected static final int ACT_DEL = 2;
    private static Dialog basicTunnelsDialog = null;
    private static List tunnelList;
    private static TextField remoteHost;
    private static TextField remotePort;
    private static TextField localPort;
    private static Choice protoChoice;
    private static final String[] protos;
    static final int[] servs;
    private static SSHPropertyHandler propsHandler;
    private static Frame parent;
    private static SSHInteractiveClient client;

    public static void show(String string, SSHInteractiveClient sSHInteractiveClient, SSHPropertyHandler sSHPropertyHandler, Frame frame) {
        propsHandler = sSHPropertyHandler;
        parent = frame;
        client = sSHInteractiveClient;
        if (basicTunnelsDialog == null) {
            basicTunnelsDialog = new Dialog(parent, string, true);
            AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(basicTunnelsDialog);
            aWTGridBagContainer.getConstraints().fill = 0;
            Label label = new Label("Current local tunnels:");
            aWTGridBagContainer.add(label, 0, 2);
            aWTGridBagContainer.getConstraints().fill = 1;
            aWTGridBagContainer.getConstraints().insets = new Insets(4, 4, 4, 4);
            aWTGridBagContainer.getConstraints().weightx = 1.0;
            aWTGridBagContainer.getConstraints().weighty = 1.0;
            tunnelList = new List(8);
            aWTGridBagContainer.add(tunnelList, 1, 4);
            tunnelList.addActionListener(new Actions(0));
            aWTGridBagContainer.getConstraints().fill = 0;
            aWTGridBagContainer.getConstraints().weighty = 0.0;
            label = new Label("Local port:");
            aWTGridBagContainer.add(label, 2, 1);
            aWTGridBagContainer.getConstraints().fill = 2;
            localPort = new TextField("", 5);
            aWTGridBagContainer.add(localPort, 2, 1);
            aWTGridBagContainer.getConstraints().fill = 0;
            label = new Label("Protocol:");
            aWTGridBagContainer.add(label, 2, 1);
            protoChoice = AWTConvenience.newChoice(protos);
            protoChoice.select("general");
            aWTGridBagContainer.add(protoChoice, 2, 1);
            protoChoice.addItemListener(new Actions(-1));
            label = new Label("Remote host:");
            aWTGridBagContainer.add(label, 3, 1);
            aWTGridBagContainer.getConstraints().fill = 2;
            remoteHost = new TextField("", 16);
            aWTGridBagContainer.add(remoteHost, 3, 3);
            aWTGridBagContainer.getConstraints().fill = 0;
            label = new Label("Remote port:");
            aWTGridBagContainer.add(label, 4, 1);
            aWTGridBagContainer.getConstraints().fill = 2;
            aWTGridBagContainer.getConstraints().weightx = 0.9;
            remotePort = new TextField("", 5);
            aWTGridBagContainer.add(remotePort, 4, 1);
            Button button = new Button("Add");
            button.addActionListener(new Actions(1));
            aWTGridBagContainer.getConstraints().weightx = 0.1;
            aWTGridBagContainer.add(button, 4, 1);
            button = new Button("Delete");
            button.addActionListener(new Actions(2));
            aWTGridBagContainer.add(button, 4, 1);
            button = new Button("Close Dialog");
            button.addActionListener(new AWTConvenience.CloseAction(basicTunnelsDialog));
            aWTGridBagContainer.getConstraints().fill = 0;
            aWTGridBagContainer.getConstraints().anchor = 10;
            aWTGridBagContainer.getConstraints().ipady = 2;
            aWTGridBagContainer.getConstraints().ipadx = 2;
            aWTGridBagContainer.add(button, 5, 0);
            basicTunnelsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(basicTunnelsDialog);
            basicTunnelsDialog.setResizable(true);
            basicTunnelsDialog.pack();
        }
        SSHTunnelDialog.updateTunnelList();
        basicTunnelsDialog.setTitle(string);
        AWTConvenience.placeDialog(basicTunnelsDialog);
        localPort.requestFocus();
        ((Component)basicTunnelsDialog).setVisible(true);
    }

    private static void updateTunnelList() {
        tunnelList.removeAll();
        for (int i = 0; i < SSHTunnelDialog.client.localForwards.size(); ++i) {
            SSHClient.LocalForward localForward = (SSHClient.LocalForward)SSHTunnelDialog.client.localForwards.elementAt(i);
            String string = localForward.plugin.equals("general") ? "" : " (plugin: " + localForward.plugin + ")";
            tunnelList.add("local: " + localForward.localPort + " -> remote: " + localForward.remoteHost + "/" + localForward.remotePort + string);
        }
    }

    static {
        protos = new String[]{"general", "ftp", "telnet", "smtp", "http", "pop2", "pop3", "nntp", "imap"};
        servs = new int[]{0, 21, 23, 25, 80, 109, 110, 119, 143};
    }

    private static class Actions
    implements ActionListener,
    ItemListener {
        private int action;

        public Actions(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 0: {
                    int n = tunnelList.getSelectedIndex();
                    if (n == -1) break;
                    SSHClient.LocalForward localForward = (SSHClient.LocalForward)client.localForwards.elementAt(n);
                    localPort.setText(String.valueOf(localForward.localPort));
                    remotePort.setText(String.valueOf(localForward.remotePort));
                    remoteHost.setText(localForward.remoteHost);
                    for (n = 1; n < servs.length; ++n) {
                        if (localForward.remotePort != servs[n]) continue;
                        protoChoice.select(protos[n]);
                        break;
                    }
                    if (n != servs.length) break;
                    protoChoice.select("general");
                    break;
                }
                case 1: {
                    String string = remoteHost.getText();
                    String string2 = "general";
                    int n = -1;
                    int n2 = -1;
                    try {
                        n = Integer.valueOf(localPort.getText());
                        n2 = Integer.valueOf(remotePort.getText());
                        if (n < 1 || n > 65535) {
                            n = -1;
                            throw new NumberFormatException();
                        }
                        if (n2 < 1 || n2 > 65535) {
                            n2 = -1;
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (n == -1) {
                            localPort.setText("");
                            localPort.requestFocus();
                        } else {
                            remotePort.setText("");
                            remotePort.requestFocus();
                        }
                        return;
                    }
                    if (protoChoice.getSelectedItem().equals("ftp")) {
                        string2 = "ftp";
                    }
                    try {
                        propsHandler.setProperty("local" + client.localForwards.size(), "/" + string2 + "/" + n + ":" + string + ":" + n2);
                        if (client.isOpened()) {
                            SSHMiscDialogs.alert("Tunnel Notice", "Tunnel is now open and operational", parent);
                        }
                    }
                    catch (Throwable throwable) {
                        SSHMiscDialogs.alert("Tunnel Notice", "Could not open tunnel: " + throwable.getMessage(), parent);
                    }
                    SSHTunnelDialog.updateTunnelList();
                    break;
                }
                case 2: {
                    int n = tunnelList.getSelectedIndex();
                    if (n != -1) {
                        propsHandler.removeLocalTunnelAt(n, true);
                    }
                    SSHTunnelDialog.updateTunnelList();
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n;
            String string = (String)itemEvent.getItem();
            for (n = 0; n < protos.length && !string.equals(protos[n]); ++n) {
            }
            if (n > 0) {
                remotePort.setText(String.valueOf(servs[n]));
            }
        }
    }
}

