/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2AuthModule;
import com.mindbright.ssh2.SSH2Interactor;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.ssh2.SSH2UserCancelException;

public class SSH2AuthPassword
implements SSH2AuthModule {
    public static final String STANDARD_NAME = "password";
    private String password;
    private String newPassword;
    private SSH2Interactor interactor;
    private String prompt;

    public SSH2AuthPassword(String string) {
        this.setPassword(string);
    }

    public SSH2AuthPassword(SSH2Interactor sSH2Interactor, String string) {
        this.interactor = sSH2Interactor;
        this.prompt = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    protected String getPassword() throws SSH2UserCancelException {
        if (this.password != null) {
            String string = new String(this.password);
            this.password = null;
            return string;
        }
        this.password = this.interactor != null ? this.interactor.promptLine(this.prompt, false) : "";
        return this.password;
    }

    protected String getNewPassword(String string, String string2) throws SSH2UserCancelException {
        if (this.newPassword != null) {
            return this.newPassword;
        }
        this.newPassword = this.interactor != null ? this.interactor.promptLine(string, false) : "";
        return this.newPassword;
    }

    public String getStandardName() {
        return STANDARD_NAME;
    }

    public SSH2TransportPDU processMethodMessage(SSH2UserAuth sSH2UserAuth, SSH2TransportPDU sSH2TransportPDU) throws SSH2UserCancelException {
        switch (sSH2TransportPDU.getType()) {
            case 60: {
                String string = sSH2TransportPDU.readJavaString();
                String string2 = sSH2TransportPDU.readJavaString();
                sSH2TransportPDU = this.createChangeRequest(sSH2UserAuth, string, string2);
                break;
            }
            default: {
                sSH2UserAuth.getTransport().getLog().warning("SSH2AuthPassword", "received unexpected packet of type: " + sSH2TransportPDU.getType());
                sSH2TransportPDU = null;
            }
        }
        return sSH2TransportPDU;
    }

    public SSH2TransportPDU startAuthentication(SSH2UserAuth sSH2UserAuth) throws SSH2UserCancelException {
        SSH2TransportPDU sSH2TransportPDU = sSH2UserAuth.createUserAuthRequest(STANDARD_NAME);
        sSH2TransportPDU.writeBoolean(false);
        sSH2TransportPDU.writeString(this.getPassword());
        return sSH2TransportPDU;
    }

    private SSH2TransportPDU createChangeRequest(SSH2UserAuth sSH2UserAuth, String string, String string2) throws SSH2UserCancelException {
        SSH2TransportPDU sSH2TransportPDU = sSH2UserAuth.createUserAuthRequest(STANDARD_NAME);
        sSH2TransportPDU.writeBoolean(true);
        sSH2TransportPDU.writeString(this.getPassword());
        sSH2TransportPDU.writeString(this.getNewPassword(string, string2));
        return sSH2TransportPDU;
    }

    public void clearSensitiveData() {
        this.password = null;
    }

    public boolean retryPointless() {
        return false;
    }
}

