/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2AuthModule;
import com.mindbright.ssh2.SSH2Interactor;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2UserAuth;
import com.mindbright.ssh2.SSH2UserCancelException;

public class SSH2AuthSSHComSecurID
implements SSH2AuthModule {
    public static final String STANDARD_NAME = "securid-1@ssh.com";
    SSH2Interactor interactor;
    String promptPIN;
    String promptNext;
    String promptNew;
    String promptNew2;
    String promptSelect;
    String promptSystem;

    public SSH2AuthSSHComSecurID(SSH2Interactor sSH2Interactor, String string, String string2, String string3, String string4, String string5, String string6) {
        this.interactor = sSH2Interactor;
        this.promptPIN = string;
        this.promptNext = string2;
        this.promptNew = string3;
        this.promptNew2 = string4;
        this.promptSelect = string5;
        this.promptSystem = string6;
    }

    public String getStandardName() {
        return STANDARD_NAME;
    }

    public SSH2TransportPDU processMethodMessage(SSH2UserAuth sSH2UserAuth, SSH2TransportPDU sSH2TransportPDU) throws SSH2UserCancelException {
        switch (sSH2TransportPDU.getType()) {
            case 60: {
                sSH2TransportPDU = this.getPasscodeResponse(sSH2UserAuth, true);
                break;
            }
            case 61: {
                int n = sSH2TransportPDU.readInt();
                int n2 = sSH2TransportPDU.readInt();
                int n3 = sSH2TransportPDU.readByte();
                boolean bl = sSH2TransportPDU.readBoolean();
                String string = sSH2TransportPDU.readJavaString();
                String string2 = this.getNewPIN(string, n3, bl, n, n2);
                sSH2TransportPDU = this.createResponse(sSH2UserAuth, string2, true);
                break;
            }
            default: {
                sSH2UserAuth.getTransport().getLog().warning("SSH2AuthSSHComSecurID", "received unexpected packet of type: " + sSH2TransportPDU.getType());
                sSH2TransportPDU = null;
            }
        }
        return sSH2TransportPDU;
    }

    public SSH2TransportPDU startAuthentication(SSH2UserAuth sSH2UserAuth) throws SSH2UserCancelException {
        return this.getPasscodeResponse(sSH2UserAuth, false);
    }

    private String getNewPIN(String string, int n, boolean bl, int n2, int n3) throws SSH2UserCancelException {
        String string2 = "";
        String string3 = null;
        if (n == 2) {
            string3 = this.interactor.promptLine(this.promptSelect, true);
            n = string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("y") ? 1 : 0;
        }
        if (n == 0) {
            string3 = this.interactor.promptLine(this.promptSystem + string + " (yes/no)? ", true);
            if (string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("y")) {
                string2 = string;
            }
        } else if (n == 1) {
            String[] stringArray;
            while (!(stringArray = this.interactor.promptMulti(new String[]{this.promptNew + " (" + n2 + " - " + n3 + (bl ? "characters" : "digits") + ")", this.promptNew2}, new boolean[]{false, false}))[0].equals(stringArray[1])) {
            }
            string2 = stringArray[0];
        }
        return string2;
    }

    private SSH2TransportPDU getPasscodeResponse(SSH2UserAuth sSH2UserAuth, boolean bl) throws SSH2UserCancelException {
        String string = bl ? this.promptNext : this.promptPIN;
        String string2 = this.interactor.promptLine(string, true);
        return this.createResponse(sSH2UserAuth, string2, bl);
    }

    private SSH2TransportPDU createResponse(SSH2UserAuth sSH2UserAuth, String string, boolean bl) {
        SSH2TransportPDU sSH2TransportPDU = sSH2UserAuth.createUserAuthRequest(STANDARD_NAME);
        sSH2TransportPDU.writeBoolean(bl);
        sSH2TransportPDU.writeString(string);
        return sSH2TransportPDU;
    }

    public void clearSensitiveData() {
    }

    public boolean retryPointless() {
        return false;
    }
}

