/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2ChannelCloseListener;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2Listener;
import com.mindbright.ssh2.SSH2TransportPDU;
import java.util.Vector;

public abstract class SSH2Channel {
    public static final int STATUS_UNDEFINED = 0;
    public static final int STATUS_OPEN = 1;
    public static final int STATUS_CLOSED = 2;
    public static final int STATUS_FAILED = 3;
    protected SSH2Connection connection;
    protected Vector closeListeners;
    protected int channelType;
    protected int channelId;
    protected int peerChanId;
    protected int rxMaxPktSz;
    protected int rxInitWinSz;
    protected int rxCurrWinSz;
    protected int txInitWinSz;
    protected int txCurrWinSz;
    protected int txMaxPktSz;
    protected volatile boolean eofSent;
    protected volatile boolean eofReceived;
    protected volatile boolean closeReceived;
    protected volatile boolean closeSent;
    protected volatile boolean deleted;
    protected Object creator;
    protected Object openMonitor;
    protected int openStatus;

    protected SSH2Channel(int n, SSH2Connection sSH2Connection, Object object) {
        this.channelType = n;
        this.connection = sSH2Connection;
        this.creator = object;
        this.rxCurrWinSz = this.rxInitWinSz = sSH2Connection.getPreferences().getIntPreference("rx-init-win-sz");
        this.rxMaxPktSz = sSH2Connection.getPreferences().getIntPreference("rx-max-pkt-sz");
        this.openStatus = 0;
        this.openMonitor = new Object();
        sSH2Connection.addChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void openConfirmation(SSH2TransportPDU sSH2TransportPDU) {
        int n = sSH2TransportPDU.readInt();
        int n2 = sSH2TransportPDU.readInt();
        int n3 = sSH2TransportPDU.readInt();
        this.init(n, n2, n3);
        this.openConfirmationImpl(sSH2TransportPDU);
        switch (this.channelType) {
            case 0: {
                this.connection.getEventHandler().localForwardedConnect(this.connection, (SSH2Listener)this.creator, this);
                break;
            }
            case 1: {
                if (!(this.creator instanceof SSH2Listener)) break;
                this.connection.getEventHandler().localDirectConnect(this.connection, (SSH2Listener)this.creator, this);
                break;
            }
            case 2: {
                this.connection.getEventHandler().localSessionConnect(this.connection, this);
                break;
            }
            case 3: {
                this.connection.getEventHandler().localX11Connect(this.connection, (SSH2Listener)this.creator, this);
            }
        }
        Object object = this.openMonitor;
        synchronized (object) {
            this.openStatus = 1;
            this.openMonitor.notifyAll();
        }
        this.connection.getLog().info("SSH2Channel", "open confirmation, ch. #" + this.channelId + ", init-winsz = " + this.txInitWinSz + ", max-pktsz = " + this.txMaxPktSz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void openFailure(int n, String string, String string2) {
        this.closeSent = true;
        this.eofSent = true;
        boolean bl = this.openFailureImpl(n, string, string2);
        this.connection.getEventHandler().localChannelOpenFailure(this.connection, this, n, string, string2);
        if (!bl) {
            this.connection.delChannel(this);
        }
        Object object = this.openMonitor;
        synchronized (object) {
            this.openStatus = 3;
            this.openMonitor.notifyAll();
        }
        this.connection.getLog().info("SSH2Channel", "open failure on ch. #" + this.channelId + ", reason: " + string);
    }

    protected final void windowAdjust(SSH2TransportPDU sSH2TransportPDU) {
        int n = sSH2TransportPDU.readInt();
        this.windowAdjustImpl(n);
    }

    protected void data(SSH2TransportPDU sSH2TransportPDU) {
    }

    protected void extData(SSH2TransportPDU sSH2TransportPDU) {
    }

    protected final void handleRequest(SSH2TransportPDU sSH2TransportPDU) {
        String string = sSH2TransportPDU.readJavaString();
        boolean bl = sSH2TransportPDU.readBoolean();
        this.handleRequestImpl(string, bl, sSH2TransportPDU);
    }

    protected void requestSuccess(SSH2TransportPDU sSH2TransportPDU) {
    }

    protected void requestFailure(SSH2TransportPDU sSH2TransportPDU) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkTermination() {
        if (this.closeSent && this.closeReceived && !this.deleted) {
            Object object;
            this.deleted = true;
            this.connection.delChannel(this);
            if (this.closeListeners != null) {
                object = this.closeListeners.elements();
                while (object.hasMoreElements()) {
                    SSH2ChannelCloseListener sSH2ChannelCloseListener = (SSH2ChannelCloseListener)object.nextElement();
                    sSH2ChannelCloseListener.closed(this);
                }
            }
            object = this.openMonitor;
            synchronized (object) {
                this.openStatus = 2;
                this.openMonitor.notifyAll();
            }
        }
    }

    protected final void recvEOF() {
        if (this.eofReceived) {
            this.connection.getLog().debug("SSH2Channel", "ch. # " + this.channelId + " received multiple EOFs");
        }
        this.eofReceived = true;
        this.eofImpl();
        if (this.eofSent) {
            this.sendClose();
        }
    }

    protected final synchronized void recvClose() {
        if (!this.closeReceived) {
            this.closeReceived = true;
            this.eofSent = true;
            this.closeImpl();
            this.sendClose();
            this.connection.getLog().debug("SSH2Channel", "closing ch. #" + this.channelId + " (" + this.getType() + ")");
            this.connection.getEventHandler().channelClosed(this.connection, this);
        }
        this.checkTermination();
    }

    protected final void sendEOF() {
        if (!this.eofSent && !this.closeSent) {
            SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(96);
            sSH2TransportPDU.writeInt(this.peerChanId);
            this.connection.transmit(sSH2TransportPDU);
            this.eofSent = true;
        }
    }

    protected final synchronized void sendClose() {
        if (!this.closeSent) {
            this.closeSent = true;
            SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(97);
            sSH2TransportPDU.writeInt(this.peerChanId);
            this.connection.transmit(sSH2TransportPDU);
        }
        this.checkTermination();
    }

    protected void init(int n, int n2, int n3) {
        int n4 = this.connection.getPreferences().getIntPreference("tx-max-pkt-sz");
        n3 = n3 > n4 ? n4 : n3;
        this.peerChanId = n;
        this.txInitWinSz = n2;
        this.txMaxPktSz = n3;
        this.txCurrWinSz = n2;
    }

    protected void transmit(SSH2TransportPDU sSH2TransportPDU) {
        if (!this.closeSent) {
            this.connection.transmit(sSH2TransportPDU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openStatus() {
        Object object = this.openMonitor;
        synchronized (object) {
            if (this.openStatus == 0) {
                try {
                    this.openMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.openStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilClosed() {
        Object object = this.openMonitor;
        synchronized (object) {
            while (this.openStatus != 2) {
                try {
                    this.openMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public final synchronized void close() {
        if (!this.connection.getTransport().isConnected()) {
            this.recvClose();
        }
        this.sendClose();
    }

    public String getType() {
        return SSH2Connection.channelTypes[this.channelType];
    }

    public int getId() {
        return this.channelId;
    }

    public int getPeerId() {
        return this.peerChanId;
    }

    public Object getCreator() {
        return this.creator;
    }

    public SSH2Connection getConnection() {
        return this.connection;
    }

    protected abstract void openConfirmationImpl(SSH2TransportPDU var1);

    protected abstract boolean openFailureImpl(int var1, String var2, String var3);

    protected abstract void windowAdjustImpl(int var1);

    protected abstract void eofImpl();

    protected abstract void closeImpl();

    protected abstract void handleRequestImpl(String var1, boolean var2, SSH2TransportPDU var3);

    public final void addCloseListener(SSH2ChannelCloseListener sSH2ChannelCloseListener) {
        if (this.closeListeners == null) {
            this.closeListeners = new Vector();
        }
        this.closeListeners.removeElement(sSH2ChannelCloseListener);
        this.closeListeners.addElement(sSH2ChannelCloseListener);
    }

    public void removeCloseListener(SSH2ChannelCloseListener sSH2ChannelCloseListener) {
        if (this.closeListeners != null) {
            this.closeListeners.removeElement(sSH2ChannelCloseListener);
            if (this.closeListeners.size() == 0) {
                this.closeListeners = null;
            }
        }
    }
}

