/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2CompressionException;
import com.mindbright.ssh2.SSH2DataBuffer;

public abstract class SSH2Compressor {
    public static final int COMPRESS_MODE = 1;
    public static final int UNCOMPRESS_MODE = 2;

    public static SSH2Compressor getInstance(String string) throws SSH2CompressionException {
        if ("zlib".equals(string)) {
            try {
                Class<?> clazz = Class.forName("com.mindbright.ssh2.SSH2CompressorZLib");
                SSH2Compressor sSH2Compressor = (SSH2Compressor)clazz.newInstance();
                return sSH2Compressor;
            }
            catch (Exception exception) {
                throw new SSH2CompressionException(exception.toString());
            }
        }
        return null;
    }

    public abstract void init(int var1, int var2);

    public abstract void compress(SSH2DataBuffer var1) throws SSH2CompressionException;

    public abstract int uncompress(SSH2DataBuffer var1, int var2) throws SSH2CompressionException;

    public abstract long numOfCompressedBytes();

    public abstract long numOfUncompressedBytes();
}

