/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import java.math.BigInteger;

public class SSH2DataBuffer {
    public static final int BOOLEAN_TRUE = 1;
    public static final int BOOLEAN_FALSE = 0;
    protected byte[] data;
    protected int rPos;
    protected int wPos;

    protected SSH2DataBuffer() {
        this(0);
    }

    public SSH2DataBuffer(int n) {
        this.data = new byte[n];
        this.reset();
    }

    public final void reset() {
        this.rPos = 0;
        this.wPos = 0;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final void setData(byte[] byArray) {
        this.data = byArray;
    }

    public final void setWPos(int n) {
        this.wPos = n;
    }

    public final int getWPos() {
        return this.wPos;
    }

    public final void setRPos(int n) {
        this.rPos = n;
    }

    public final int getRPos() {
        return this.rPos;
    }

    public final int getMaxReadSize() {
        return this.wPos - this.rPos;
    }

    public final int getMaxWriteSize() {
        return this.data.length - this.wPos;
    }

    public final int readByte() {
        return this.data[this.rPos++] & 0xFF;
    }

    public final void writeByte(int n) {
        this.data[this.wPos++] = (byte)n;
    }

    public final boolean readBoolean() {
        return this.readByte() != 0;
    }

    public final void writeBoolean(boolean bl) {
        if (bl) {
            this.writeByte(1);
        } else {
            this.writeByte(0);
        }
    }

    public final int readInt() {
        int n = this.readByte();
        int n2 = this.readByte();
        int n3 = this.readByte();
        int n4 = this.readByte();
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public final void writeInt(int n) {
        this.writeByte(n >>> 24 & 0xFF);
        this.writeByte(n >>> 16 & 0xFF);
        this.writeByte(n >>> 8 & 0xFF);
        this.writeByte(n >>> 0 & 0xFF);
    }

    public final BigInteger readBigInt() {
        byte[] byArray = this.readString();
        if (byArray.length > 0) {
            return new BigInteger(byArray);
        }
        return BigInteger.valueOf(0L);
    }

    public final BigInteger readBigIntBits() {
        int n = this.readInt();
        byte[] byArray = new byte[(n + 7) / 8 + 1];
        byArray[0] = 0;
        this.readRaw(byArray, 1, byArray.length - 1);
        return new BigInteger(byArray);
    }

    public final void writeBigInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 && byArray[0] == 0) {
            byArray = new byte[]{};
        }
        this.writeString(byArray);
    }

    public final void writeBigIntBits(BigInteger bigInteger) {
        int n = (bigInteger.bitLength() + 7) / 8;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 && byArray[0] == 0) {
            this.writeInt(0);
            return;
        }
        this.writeInt(bigInteger.bitLength());
        if (byArray[0] == 0) {
            this.writeRaw(byArray, 1, n);
        } else {
            this.writeRaw(byArray, 0, n);
        }
    }

    public final String readJavaString() {
        int n = this.readInt();
        if (n < 0 || n > this.data.length - this.rPos) {
            throw new Error("Error in SSH2DataBuffer, corrupt string on read");
        }
        String string = new String(this.data, this.rPos, n);
        this.rPos += n;
        return string;
    }

    public final byte[] readString() {
        int n = this.readInt();
        if (n < 0 || n > this.data.length - this.rPos) {
            throw new Error("Error in SSH2DataBuffer, corrupt string on read");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, this.rPos, byArray, 0, n);
        this.rPos += n;
        return byArray;
    }

    public final int readString(byte[] byArray, int n) {
        int n2 = this.readInt();
        System.arraycopy(this.data, this.rPos, byArray, n, n2);
        this.rPos += n2;
        return n2;
    }

    public final void writeString(String string) {
        this.writeString(string.getBytes());
    }

    public final void writeString(byte[] byArray) {
        this.writeString(byArray, 0, byArray.length);
    }

    public final void writeString(byte[] byArray, int n, int n2) {
        this.writeInt(n2);
        System.arraycopy(byArray, n, this.data, this.wPos, n2);
        this.wPos += n2;
    }

    public final byte[] readRestRaw() {
        return this.readRaw(this.wPos - this.rPos);
    }

    public final byte[] readRaw(int n) {
        byte[] byArray = new byte[n];
        this.readRaw(byArray, 0, n);
        return byArray;
    }

    public final void readRaw(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.rPos, byArray, n, n2);
        this.rPos += n2;
    }

    public final void writeRaw(byte[] byArray) {
        this.writeRaw(byArray, 0, byArray.length);
    }

    public final void writeRaw(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.data, this.wPos, n2);
        this.wPos += n2;
    }
}

