/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.jce.crypto.spec.DHParameterSpec;
import com.mindbright.jce.crypto.spec.DHPublicKeySpec;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2KEXDHGroup1SHA1;
import com.mindbright.ssh2.SSH2KEXFailedException;
import com.mindbright.ssh2.SSH2Preferences;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2TransportPDU;
import java.math.BigInteger;

public class SSH2KEXDHGroupXSHA1
extends SSH2KEXDHGroup1SHA1 {
    private int reqBits;
    private BigInteger p;
    private BigInteger g;

    public void init(SSH2Transport sSH2Transport) throws SSH2Exception {
        this.transport = sSH2Transport;
        this.sha1 = this.createHash();
        if (!sSH2Transport.isServer()) {
            this.sendGEXRequest();
        }
    }

    public void processKEXMethodPDU(SSH2TransportPDU sSH2TransportPDU) throws SSH2Exception {
        switch (sSH2TransportPDU.getType()) {
            case 30: {
                break;
            }
            case 31: {
                if (this.transport.isServer()) {
                    throw new SSH2KEXFailedException("Unexpected KEXDH_GEX_GROUP");
                }
                this.p = sSH2TransportPDU.readBigInt();
                this.g = sSH2TransportPDU.readBigInt();
                DHParameterSpec dHParameterSpec = new DHParameterSpec(this.p, this.g);
                this.generateDHKeyPair(dHParameterSpec);
                this.sendDHINIT(32);
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                if (this.transport.isServer()) {
                    throw new SSH2KEXFailedException("Unexpected KEXDH_GEX_REPLY");
                }
                this.serverHostKey = sSH2TransportPDU.readString();
                this.serverF = sSH2TransportPDU.readBigInt();
                byte[] byArray = sSH2TransportPDU.readString();
                DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(this.serverF, this.p, this.g);
                this.computeSharedSecret_K(dHPublicKeySpec);
                this.computeExchangeHash_H();
                this.transport.authenticateHost(this.serverHostKey, byArray, this.exchangeHash_H);
                this.transport.sendNewKeys();
            }
        }
    }

    protected void computeExchangeHash_H() {
        SSH2DataBuffer sSH2DataBuffer = new SSH2DataBuffer(8192);
        if (this.transport.isServer()) {
            this.serverF = this.dhPublicKey.getY();
        } else {
            this.clientE = this.dhPublicKey.getY();
        }
        sSH2DataBuffer.writeString(this.transport.getClientVersion());
        sSH2DataBuffer.writeString(this.transport.getServerVersion());
        sSH2DataBuffer.writeString(this.transport.getClientKEXINITPDU().getData(), this.transport.getClientKEXINITPDU().getPayloadOffset(), this.transport.getClientKEXINITPDU().getPayloadLength());
        sSH2DataBuffer.writeString(this.transport.getServerKEXINITPDU().getData(), this.transport.getServerKEXINITPDU().getPayloadOffset(), this.transport.getServerKEXINITPDU().getPayloadLength());
        sSH2DataBuffer.writeString(this.serverHostKey);
        sSH2DataBuffer.writeInt(this.reqBits);
        sSH2DataBuffer.writeBigInt(this.p);
        sSH2DataBuffer.writeBigInt(this.g);
        sSH2DataBuffer.writeBigInt(this.clientE);
        sSH2DataBuffer.writeBigInt(this.serverF);
        sSH2DataBuffer.writeString(this.sharedSecret_K);
        this.sha1.reset();
        this.sha1.update(sSH2DataBuffer.getData(), 0, sSH2DataBuffer.getWPos());
        this.exchangeHash_H = this.sha1.digest();
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "E: ", this.clientE.toByteArray());
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "F: ", this.serverF.toByteArray());
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "K: ", this.sharedSecret_K);
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "Hash over: ", sSH2DataBuffer.getData(), 0, sSH2DataBuffer.getWPos());
        this.transport.getLog().debug2("SSH2KEXDHGroup1SHA1", "computeExchangeHash_H", "H: ", this.exchangeHash_H);
    }

    protected void sendGEXRequest() throws SSH2Exception {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(30);
        this.reqBits = this.estimateGroupBits();
        sSH2TransportPDU.writeInt(this.reqBits);
        this.transport.transmitInternal(sSH2TransportPDU);
    }

    private int estimateGroupBits() {
        SSH2Preferences sSH2Preferences = this.transport.getOurPreferences();
        int n = SSH2Preferences.getCipherKeyLen(sSH2Preferences.getAgreedCipher(true, false));
        int n2 = SSH2Preferences.getCipherKeyLen(sSH2Preferences.getAgreedCipher(false, false));
        int n3 = (n > n2 ? n : n2) * 8;
        if (n3 < 64) {
            return 512;
        }
        if (n3 < 128) {
            return 1024;
        }
        if (n3 < 192) {
            return 2048;
        }
        return 4096;
    }
}

