/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2Listener;
import com.mindbright.ssh2.SSH2TCPChannel;
import java.io.IOException;
import java.net.Socket;

public class SSH2RetryingTCPChannel
extends SSH2TCPChannel {
    private int numOfRetries = 3;
    private long retryDelayTime = 200L;

    public SSH2RetryingTCPChannel(int n, SSH2Connection sSH2Connection, Object object, Socket socket, String string, int n2, String string2, int n3) throws IOException {
        super(n, sSH2Connection, object, socket, string, n2, string2, n3);
    }

    protected void setRetries(int n) {
        this.numOfRetries = n;
    }

    public void setRetryDelay(long l) {
        this.retryDelayTime = l;
    }

    protected boolean openFailureImpl(int n, String string, String string2) {
        boolean bl = true;
        if (this.numOfRetries > 0) {
            if (this.getCreator() instanceof SSH2Listener) {
                try {
                    Thread.sleep(this.retryDelayTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.connection.getLog().notice("SSH2RetryingTCPChannel", "retry (" + this.numOfRetries + ") connection on ch. #" + this.getId() + " to " + this.remoteAddr + ":" + this.remotePort);
                SSH2Listener sSH2Listener = (SSH2Listener)this.getCreator();
                sSH2Listener.sendChannelOpen(this, this.endpoint);
            } else {
                this.connection.getLog().error("SSH2RetryingTCPChannel", "openFailureImpl", "unexpected use of this class");
            }
        } else {
            this.outputClosed();
            bl = false;
        }
        --this.numOfRetries;
        return bl;
    }
}

