/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.isnetworks.ssh.AbstractFileBrowser;
import com.isnetworks.ssh.FileDisplay;
import com.isnetworks.ssh.FileListItem;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2SFTP;
import com.mindbright.ssh2.SSH2SFTPClient;

public class SSH2SFTPFileBrowser
extends AbstractFileBrowser {
    private SSH2Connection connection;
    private SSH2SFTPClient client;
    private String cwd;

    public SSH2SFTPFileBrowser(SSH2Connection sSH2Connection, FileDisplay fileDisplay, String string) {
        super(fileDisplay);
        this.connection = sSH2Connection;
        this.cwd = string;
    }

    public void fileDoubleClicked(FileListItem fileListItem) throws Exception {
        if (fileListItem != null & fileListItem.isDirectory()) {
            this.changeDirectory(this.cwd + "/" + fileListItem.getName());
        }
    }

    public void refresh() throws Exception {
        SSH2SFTP.FileHandle fileHandle = null;
        try {
            fileHandle = this.client.opendir(this.cwd);
            SSH2SFTP.FileAttributes[] fileAttributesArray = this.client.readdir(fileHandle);
            if (!this.cwd.equals("/") && !this.cwd.equals("")) {
                this.dirs.addElement(new FileListItem("..", "", true, "/"));
            }
            for (int i = 0; i < fileAttributesArray.length; ++i) {
                String string = fileAttributesArray[i].name;
                if ("..".equals(string) || ".".equals(string)) continue;
                boolean bl = fileAttributesArray[i].isDirectory();
                if (fileAttributesArray[i].isLink()) {
                    bl = this.isDirectory(string);
                }
                FileListItem fileListItem = new FileListItem(string, this.cwd, bl, "/", fileAttributesArray[i].size);
                if (bl) {
                    this.dirs.addElement(fileListItem);
                    continue;
                }
                this.files.addElement(fileListItem);
            }
            this.mFileDisplay.setFileList(this.dirs, this.files, this.cwd, "/");
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        finally {
            try {
                this.client.close(fileHandle);
            }
            catch (Exception exception) {}
        }
    }

    public void delete(FileListItem[] fileListItemArray) throws Exception {
        String string = null;
        try {
            for (int i = 0; i < fileListItemArray.length; ++i) {
                string = fileListItemArray[i].getAbsolutePath();
                SSH2SFTP.FileAttributes fileAttributes = this.client.stat(string);
                if (fileAttributes.isDirectory()) {
                    this.client.rmdir(string);
                    continue;
                }
                this.client.remove(string);
            }
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new Exception("Unable to delete " + string + " - may not have permission or directory may not be empty");
        }
    }

    public void initialize() throws Exception {
        try {
            this.client = new SSH2SFTPClient(this.connection, true);
            SSH2SFTP.FileAttributes fileAttributes = this.client.realpath(this.cwd);
            this.cwd = fileAttributes.lname;
            this.refresh();
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new Exception("Could not start sftp session: " + sFTPException.getMessage());
        }
    }

    public void makeDirectory(String string) throws Exception {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            this.client.mkdir(string, new SSH2SFTP.FileAttributes());
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new Exception(sFTPException.getMessage());
        }
    }

    public void rename(FileListItem fileListItem, String string) throws Exception {
        try {
            this.client.rename(fileListItem.getAbsolutePath(), fileListItem.getParent() + "/" + string);
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            throw new Exception(sFTPException.getMessage());
        }
    }

    public void changeDirectory(String string) throws Exception {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            SSH2SFTP.FileAttributes fileAttributes = this.client.realpath(string);
            SSH2SFTP.FileHandle fileHandle = this.client.opendir(string);
            string = fileAttributes.lname;
            this.client.close(fileHandle);
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            string = this.cwd;
        }
        this.cwd = string;
    }

    private boolean isDirectory(String string) {
        try {
            string = this.cwd + "/" + string;
            SSH2SFTP.FileHandle fileHandle = this.client.opendir(string);
            this.client.close(fileHandle);
            return true;
        }
        catch (SSH2SFTP.SFTPException sFTPException) {
            return false;
        }
    }

    public void disconnect() {
        if (this.client != null) {
            this.client.terminate();
        }
    }
}

