/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2DataBuffer;
import com.mindbright.ssh2.SSH2InternalChannel;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.util.InputStreamPipe;
import com.mindbright.util.OutputStreamPipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SSH2SessionChannel
extends SSH2InternalChannel {
    public static final int EXIT_ON_CLOSE = -1;
    public static final int EXIT_ON_FAILURE = -2;
    protected boolean started;
    protected boolean blocking;
    protected boolean exited;
    protected Object exitMonitor;
    protected Object reqMonitor;
    protected boolean exitedOnSignal;
    protected int exitStatus;
    protected boolean reqStatus;
    protected boolean x11Mapping;
    protected InputStreamPipe stderr;
    protected OutputStream stderrW;

    protected SSH2SessionChannel(SSH2Connection sSH2Connection) {
        super(2, sSH2Connection);
        this.rxInitWinSz = 16384;
        this.rxCurrWinSz = 16384;
        this.rxMaxPktSz = 4096;
        this.started = false;
        this.exited = false;
        this.blocking = true;
        this.reqStatus = true;
        this.x11Mapping = false;
        this.exitMonitor = new Object();
        this.reqMonitor = new Object();
        this.stderrW = null;
    }

    public boolean doShell() {
        if (this.started || this.openStatus() != 1) {
            return false;
        }
        SSH2TransportPDU sSH2TransportPDU = this.getRequestPDU("shell");
        this.started = this.sendAndBlockUntilReply(sSH2TransportPDU);
        return this.started;
    }

    public boolean doSingleCommand(String string) {
        if (this.started || this.openStatus() != 1) {
            return false;
        }
        SSH2TransportPDU sSH2TransportPDU = this.getRequestPDU("exec");
        sSH2TransportPDU.writeString(string);
        this.started = this.sendAndBlockUntilReply(sSH2TransportPDU);
        return this.started;
    }

    public boolean doSubsystem(String string) {
        if (this.started || this.openStatus() != 1) {
            return false;
        }
        SSH2TransportPDU sSH2TransportPDU = this.getRequestPDU("subsystem");
        sSH2TransportPDU.writeString(string);
        this.started = this.sendAndBlockUntilReply(sSH2TransportPDU);
        return this.started;
    }

    public boolean doBreak(int n) {
        if (this.started || this.openStatus() != 1) {
            return false;
        }
        SSH2TransportPDU sSH2TransportPDU = this.getRequestPDU("break");
        sSH2TransportPDU.writeInt(n);
        this.started = this.sendAndBlockUntilReply(sSH2TransportPDU);
        return this.started;
    }

    public int waitForExit() {
        return this.waitForExit(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForExit(long l) {
        Object object = this.exitMonitor;
        synchronized (object) {
            if (!this.exited) {
                try {
                    this.exitMonitor.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.exitStatus;
        }
    }

    public void changeStdOut(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void changeStdIn(InputStream inputStream) {
        this.in = inputStream;
    }

    public void changeStdErr(OutputStream outputStream) {
        this.stderrW = outputStream;
    }

    public void enableStdErr() {
        this.stderrW = new OutputStreamPipe();
        this.stderr = new InputStreamPipe();
        try {
            this.stderr.connect((OutputStreamPipe)this.stderrW);
        }
        catch (IOException iOException) {
            this.connection.getLog().error("SSH2SessionChannel", "enableStdErr", "can't happen, bug somewhere!?!");
        }
    }

    public InputStream getStdOut() {
        return this.getInputStream();
    }

    public OutputStream getStdIn() {
        return this.getOutputStream();
    }

    public InputStream getStdErr() {
        return this.stderr;
    }

    public void stdinWriteNoLatency(String string) {
        byte[] byArray = string.getBytes();
        this.stdinWriteNoLatency(byArray, 0, byArray.length);
    }

    public void stdinWriteNoLatency(byte[] byArray, int n, int n2) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(94, n2 + 128);
        sSH2TransportPDU.writeInt(this.peerChanId);
        sSH2TransportPDU.writeInt(n2);
        sSH2TransportPDU.writeRaw(byArray, n, n2);
        this.transmit(sSH2TransportPDU);
        this.txCounter += (long)n2;
    }

    public void stdinWriteNoLatency(int n) {
        this.stdinWriteNoLatency(new byte[]{(byte)n}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean bl) {
        Object object = this.reqMonitor;
        synchronized (object) {
            this.blocking = bl;
        }
    }

    public boolean requestPTY(String string, int n, int n2, byte[] byArray) {
        if (this.openStatus() != 1) {
            return false;
        }
        SSH2TransportPDU sSH2TransportPDU = this.getRequestPDU("pty-req");
        sSH2TransportPDU.writeString(string);
        sSH2TransportPDU.writeInt(n2);
        sSH2TransportPDU.writeInt(n);
        sSH2TransportPDU.writeInt(0);
        sSH2TransportPDU.writeInt(0);
        if (byArray == null) {
            byArray = new byte[]{0};
        }
        sSH2TransportPDU.writeString(byArray);
        return this.sendAndBlockUntilReply(sSH2TransportPDU);
    }

    public boolean requestX11Forward(String string, int n, byte[] byArray, boolean bl, int n2) {
        this.connection.getPreferences().setPreference("x11-display", string + ":" + n);
        this.connection.setX11RealCookie(byArray);
        return this.requestX11Forward(bl, n2);
    }

    public boolean requestX11Forward(boolean bl, int n) {
        Object object;
        if (this.openStatus() != 1 || this.x11Mapping) {
            if (this.x11Mapping) {
                this.connection.getLog().warning("SSH2SessionChannel", "requesting x11 forward multiple times");
            }
            return false;
        }
        byte[] byArray = this.connection.getX11FakeCookie();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            object = Integer.toHexString(byArray[i] & 0xFF);
            if (((String)object).length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append((String)object);
        }
        String string = stringBuffer.toString();
        object = this.getRequestPDU("x11-req");
        ((SSH2DataBuffer)object).writeBoolean(bl);
        ((SSH2DataBuffer)object).writeString("MIT-MAGIC-COOKIE-1");
        ((SSH2DataBuffer)object).writeString(string);
        ((SSH2DataBuffer)object).writeInt(n);
        this.x11Mapping = this.sendAndBlockUntilReply((SSH2TransportPDU)object);
        if (this.x11Mapping) {
            this.connection.setX11Mapping(bl);
        }
        return this.x11Mapping;
    }

    public boolean setEnvironment(String string, String string2) {
        if (this.openStatus() != 1) {
            return false;
        }
        SSH2TransportPDU sSH2TransportPDU = this.getRequestPDU("env");
        sSH2TransportPDU.writeString(string);
        sSH2TransportPDU.writeString(string2);
        return this.sendAndBlockUntilReply(sSH2TransportPDU);
    }

    public void sendWindowChange(int n, int n2) {
        SSH2TransportPDU sSH2TransportPDU = this.getNoReplyRequestPDU("window-change");
        sSH2TransportPDU.writeInt(n2);
        sSH2TransportPDU.writeInt(n);
        sSH2TransportPDU.writeInt(0);
        sSH2TransportPDU.writeInt(0);
        this.transmit(sSH2TransportPDU);
    }

    public void sendSignal(String string, boolean bl, String string2, String string3) {
        SSH2TransportPDU sSH2TransportPDU = this.getNoReplyRequestPDU("signal");
        sSH2TransportPDU.writeString(string);
        sSH2TransportPDU.writeBoolean(bl);
        sSH2TransportPDU.writeString(string2);
        sSH2TransportPDU.writeString(string3);
        this.transmit(sSH2TransportPDU);
    }

    public void doExit(int n) {
        this.doExit(n, false, null);
    }

    public void doExit(int n, boolean bl) {
        this.doExit(n, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExit(int n, boolean bl, String string) {
        Object object = this.exitMonitor;
        synchronized (object) {
            if (!this.exited) {
                this.exited = true;
                if (this.x11Mapping) {
                    this.x11Mapping = false;
                    this.connection.clearX11Mapping();
                }
                if (string == null) {
                    string = "<unknown>";
                }
                this.exitedOnSignal = bl;
                this.exitStatus = n;
                this.exitMonitor.notifyAll();
                this.connection.getLog().info("SSH2SessionChannel", "session (ch. #" + this.channelId + ") exit with " + (bl ? "signal " + string : "status " + n));
            }
        }
    }

    protected void extData(SSH2TransportPDU sSH2TransportPDU) {
        int n = sSH2TransportPDU.readInt();
        if (n != 1) {
            this.connection.getLog().error("SSH2SessionChannel", "extData", "extended data of unknown type: " + n);
        } else {
            try {
                int n2 = sSH2TransportPDU.readInt();
                byte[] byArray = sSH2TransportPDU.getData();
                int n3 = sSH2TransportPDU.getRPos();
                this.rxCounter += (long)n2;
                if (this.stderrW != null) {
                    this.stderrW.write(byArray, n3, n2);
                } else {
                    this.connection.getLog().debug("SSH2SessionChannel", "session (ch. #" + this.channelId + ") stderr : " + new String(byArray, n3, n2));
                }
                this.checkRxWindowSize(n2);
            }
            catch (IOException iOException) {
                this.connection.getLog().error("SSH2SessionChannel", "extData", "error writing to stderr: " + iOException.getMessage());
            }
        }
    }

    protected void closeImpl() {
        super.closeImpl();
        this.doExit(-1);
        this.requestFailure(null);
    }

    protected boolean openFailureImpl(int n, String string, String string2) {
        this.doExit(-2);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSuccess(SSH2TransportPDU sSH2TransportPDU) {
        Object object = this.reqMonitor;
        synchronized (object) {
            this.reqStatus = true;
            this.reqMonitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestFailure(SSH2TransportPDU sSH2TransportPDU) {
        Object object = this.reqMonitor;
        synchronized (object) {
            this.reqStatus = false;
            this.reqMonitor.notify();
        }
    }

    protected void handleRequestImpl(String string, boolean bl, SSH2TransportPDU sSH2TransportPDU) {
        if (string.equals("exit-status")) {
            int n = sSH2TransportPDU.readInt();
            this.doExit(n);
        } else if (string.equals("exit-signal")) {
            String string2 = null;
            try {
                string2 = sSH2TransportPDU.readJavaString();
                boolean bl2 = sSH2TransportPDU.readBoolean();
                String string3 = sSH2TransportPDU.readJavaString();
                String string4 = sSH2TransportPDU.readJavaString();
                this.connection.getLog().debug("SSH2SessionChannel", "handleRequestImpl", "got CH_REQ_EXIT_SIG:  sig=" + string2 + ", core=" + bl2 + ", msg=" + string4 + ", lang=" + string4);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.doExit(-1, true, string2);
        } else {
            if (!string.equals("keepalive@openssh.com")) {
                this.connection.getLog().error("SSH2SessionChannel", "handleRequestImpl", "got unknown channel-request: " + string);
            }
            if (bl) {
                SSH2TransportPDU sSH2TransportPDU2 = SSH2TransportPDU.createOutgoingPacket(100);
                sSH2TransportPDU2.writeInt(this.peerChanId);
                this.transmit(sSH2TransportPDU2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendAndBlockUntilReply(SSH2TransportPDU sSH2TransportPDU) {
        Object object = this.reqMonitor;
        synchronized (object) {
            this.transmit(sSH2TransportPDU);
            try {
                if (this.blocking) {
                    this.reqMonitor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.connection.getLog().error("SSH2SessionChannel", "sendAndBlockUntilReply", "wait for reply interrupted");
            }
            boolean bl = this.reqStatus;
            this.reqStatus = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSH2TransportPDU getRequestPDU(String string) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(98);
        sSH2TransportPDU.writeInt(this.peerChanId);
        sSH2TransportPDU.writeString(string);
        Object object = this.reqMonitor;
        synchronized (object) {
            sSH2TransportPDU.writeBoolean(this.blocking);
        }
        return sSH2TransportPDU;
    }

    private SSH2TransportPDU getNoReplyRequestPDU(String string) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(98);
        sSH2TransportPDU.writeInt(this.peerChanId);
        sSH2TransportPDU.writeString(string);
        sSH2TransportPDU.writeBoolean(false);
        return sSH2TransportPDU;
    }
}

