/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2AuthModule;
import com.mindbright.ssh2.SSH2Authenticator;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2ListUtil;
import com.mindbright.ssh2.SSH2Transport;
import com.mindbright.ssh2.SSH2TransportPDU;
import com.mindbright.ssh2.SSH2UserCancelException;
import com.mindbright.util.Queue;

public final class SSH2UserAuth {
    private SSH2Transport transport;
    private SSH2Authenticator authenticator;
    private SSH2AuthModule authModule;
    private volatile boolean isAuthenticated;
    String currentMethod;
    boolean retryPointless;
    String service;
    String user;
    String ourMethods;
    Queue procQueue;

    public SSH2UserAuth(SSH2Transport sSH2Transport, SSH2Authenticator sSH2Authenticator) {
        this.transport = sSH2Transport;
        this.authenticator = sSH2Authenticator;
        this.isAuthenticated = false;
        this.procQueue = new Queue();
    }

    public SSH2Transport getTransport() {
        return this.transport;
    }

    public SSH2Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean authenticateUser(String string) {
        this.service = string;
        this.user = this.authenticator.getUsername();
        this.currentMethod = null;
        this.retryPointless = false;
        this.transport.setUserAuth(this);
        this.transport.requestService("ssh-userauth");
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        block10: while (!this.isAuthenticated) {
            Object object;
            SSH2TransportPDU sSH2TransportPDU = null;
            if (!bl) {
                sSH2TransportPDU = (SSH2TransportPDU)this.procQueue.getFirst();
                if (sSH2TransportPDU == null) {
                    this.authenticator.authError();
                    break;
                }
                n = sSH2TransportPDU.getType();
            }
            try {
                switch (n) {
                    case 51: {
                        Object object2;
                        if (!bl) {
                            string2 = sSH2TransportPDU.readJavaString();
                            bl2 = sSH2TransportPDU.readBoolean();
                            this.authenticator.peerMethods(string2);
                        }
                        bl = false;
                        this.transport.getLog().info("SSH2UserAuth", "failure continuation: " + string2 + " (partial: " + bl2 + ")");
                        if (this.currentMethod != null) {
                            this.ourMethods = SSH2ListUtil.removeFirstFromList(this.ourMethods, this.currentMethod);
                            this.authenticator.authFailure(this.currentMethod, bl2);
                        } else {
                            this.ourMethods = this.authenticator.getMethods();
                        }
                        this.transport.getLog().info("SSH2UserAuth", "our remaining methods: " + (this.ourMethods.length() > 0 ? this.ourMethods : "<none>"));
                        this.currentMethod = SSH2ListUtil.chooseFromList(this.ourMethods, string2);
                        if (this.currentMethod != null) {
                            this.transport.getLog().info("SSH2UserAuth", "trying method: " + this.currentMethod);
                            this.authModule = this.authenticator.getModule(this.currentMethod);
                            this.retryPointless = this.authModule.retryPointless();
                            object2 = this.authModule.startAuthentication(this);
                            this.transport.transmit((SSH2TransportPDU)object2);
                            break;
                        }
                        this.authenticator.noMoreMethods();
                        this.transport.getLog().notice("SSH2UserAuth", "no more authentication methods, giving up");
                        break block10;
                    }
                    case 52: {
                        this.transport.getLog().notice("SSH2UserAuth", "successful authentication with " + this.currentMethod);
                        this.isAuthenticated = true;
                        this.authenticator.authSuccess(this.currentMethod);
                        break;
                    }
                    case 53: {
                        Object object2 = sSH2TransportPDU.readJavaString();
                        this.transport.getLog().warning("SSH2UserAuth", "banner: " + (String)object2);
                        this.authenticator.displayBanner((String)object2);
                        break;
                    }
                    case 6: {
                        if (this.transport.incompatibleServiceAccept) {
                            this.transport.getLog().info("SSH2UserAuth", "server accepted " + string + " (draft incompatible)");
                        } else {
                            this.transport.getLog().info("SSH2UserAuth", "server accepted: " + sSH2TransportPDU.readJavaString());
                        }
                        this.doNoneAuth();
                        break;
                    }
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: {
                        if (this.authModule != null) {
                            object = this.authModule.processMethodMessage(this, sSH2TransportPDU);
                            if (object != null) {
                                this.transport.transmit((SSH2TransportPDU)object);
                                break;
                            }
                        } else {
                            this.transport.fatalDisconnect(2, "Received userauth method packet when no method selected");
                            break block10;
                        }
                    }
                }
            }
            catch (SSH2UserCancelException sSH2UserCancelException) {
                object = sSH2UserCancelException.getMessage();
                this.authenticator.moduleCancel(this.currentMethod, (String)object);
                this.transport.fatalDisconnect(13, "User cancel: " + (String)object);
                this.transport.getLog().notice("SSH2UserAuth", "user canceled authentication: " + (String)object);
                break;
            }
            catch (SSH2Exception sSH2Exception) {
                this.transport.getLog().error("SSH2UserAuth", "authenticateUser", "error in module '" + this.currentMethod + "': " + sSH2Exception.getMessage());
                this.authenticator.moduleFailure(this.currentMethod, sSH2Exception);
                bl2 = false;
                bl = true;
                n = 51;
            }
            if (sSH2TransportPDU == null) continue;
            sSH2TransportPDU.release();
        }
        return this.isAuthenticated;
    }

    public SSH2TransportPDU createUserAuthRequest(String string) {
        SSH2TransportPDU sSH2TransportPDU = SSH2TransportPDU.createOutgoingPacket(50);
        sSH2TransportPDU.writeString(this.user);
        sSH2TransportPDU.writeString(this.service);
        sSH2TransportPDU.writeString(string);
        return sSH2TransportPDU;
    }

    public void terminate() {
        this.procQueue.setBlocking(false);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    private void doNoneAuth() {
        SSH2TransportPDU sSH2TransportPDU = this.createUserAuthRequest("none");
        this.transport.transmit(sSH2TransportPDU);
    }

    void processMessage(SSH2TransportPDU sSH2TransportPDU) {
        this.procQueue.putLast(sSH2TransportPDU);
    }
}

