/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2StreamChannel;
import com.mindbright.ssh2.SSH2StreamFilter;
import com.mindbright.ssh2.SSH2StreamFilterFactory;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SSH2X11Filter
implements SSH2StreamFilter,
SSH2StreamFilterFactory {
    protected static final String X11AUTH_PROTO = "MIT-MAGIC-COOKIE-1";
    private static SSH2X11Filter factoryInstance;
    protected SSH2Connection connection;
    protected SSH2StreamChannel channel;
    protected X11Output x11Out;

    public SSH2X11Filter() {
    }

    public static synchronized SSH2X11Filter getFilterFactory() {
        if (factoryInstance == null) {
            factoryInstance = new SSH2X11Filter();
        }
        return factoryInstance;
    }

    protected SSH2X11Filter(SSH2Connection sSH2Connection, SSH2StreamChannel sSH2StreamChannel) {
        this.connection = sSH2Connection;
        this.channel = sSH2StreamChannel;
    }

    public SSH2StreamFilter createFilter(SSH2Connection sSH2Connection, SSH2StreamChannel sSH2StreamChannel) {
        return new SSH2X11Filter(sSH2Connection, sSH2StreamChannel);
    }

    public InputStream getInputFilter(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getOutputFilter(OutputStream outputStream) {
        this.x11Out = new X11Output(outputStream);
        return this.x11Out;
    }

    class X11Output
    extends FilterOutputStream {
        byte[] buf = new byte[1024];
        int idx = 0;
        int wantedLen = 12;
        int protoLen;
        int cookieLen;
        boolean readAuth = false;

        public X11Output(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (!this.readAuth) {
                int n3;
                if (this.idx < 12) {
                    n3 = this.readMore(byArray, n, n2);
                    n2 -= n3;
                    n += n3;
                    if (this.wantedLen == 0) {
                        if (this.buf[0] == 66) {
                            this.protoLen = (this.buf[6] & 0xFF) << 8 | this.buf[7] & 0xFF;
                            this.cookieLen = (this.buf[8] & 0xFF) << 8 | this.buf[9] & 0xFF;
                        } else if (this.buf[0] == 108) {
                            this.protoLen = (this.buf[7] & 0xFF) << 8 | this.buf[6] & 0xFF;
                            this.cookieLen = (this.buf[9] & 0xFF) << 8 | this.buf[8] & 0xFF;
                        } else {
                            throw new IOException("Corrupt X11 authentication");
                        }
                        this.wantedLen = this.protoLen + 3 & 0xFFFFFFFC;
                        this.wantedLen += this.cookieLen + 3 & 0xFFFFFFFC;
                        if (this.wantedLen + this.idx > this.buf.length) {
                            throw new IOException("Corrupt X11 authentication");
                        }
                        if (this.wantedLen == 0) {
                            throw new IOException("No X11 authentication cookie");
                        }
                    }
                }
                if (n2 > 0) {
                    n3 = this.readMore(byArray, n, n2);
                    n2 -= n3;
                    n += n3;
                    if (this.wantedLen == 0) {
                        byte[] byArray2 = SSH2X11Filter.this.connection.getX11FakeCookie();
                        String string = new String(this.buf, 12, this.protoLen);
                        byte[] byArray3 = new byte[byArray2.length];
                        this.protoLen = this.protoLen + 3 & 0xFFFFFFFC;
                        System.arraycopy(this.buf, 12 + this.protoLen, byArray3, 0, byArray2.length);
                        if (!SSH2X11Filter.X11AUTH_PROTO.equals(string) || !this.compareCookies(byArray2, byArray3, byArray2.length)) {
                            throw new IOException("X11 authentication failed");
                        }
                        byte[] byArray4 = SSH2X11Filter.this.connection.getX11RealCookie();
                        if (byArray4.length != this.cookieLen) {
                            throw new IOException("X11 wrong cookie length");
                        }
                        System.arraycopy(byArray4, 0, this.buf, 12 + this.protoLen, byArray4.length);
                        this.readAuth = true;
                        this.out.write(this.buf, 0, this.idx);
                        this.buf = null;
                    }
                }
                if (!this.readAuth || n2 == 0) {
                    return;
                }
            }
            this.out.write(byArray, n, n2);
        }

        private boolean compareCookies(byte[] byArray, byte[] byArray2, int n) {
            int n2;
            for (n2 = 0; n2 < n && byArray[n2] == byArray2[n2]; ++n2) {
            }
            return n2 == n;
        }

        private int readMore(byte[] byArray, int n, int n2) {
            if (n2 > this.wantedLen) {
                System.arraycopy(byArray, n, this.buf, this.idx, this.wantedLen);
                this.idx += this.wantedLen;
                n2 = this.wantedLen;
                this.wantedLen = 0;
            } else {
                System.arraycopy(byArray, n, this.buf, this.idx, n2);
                this.idx += n2;
                this.wantedLen -= n2;
            }
            return n2;
        }
    }
}

