/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.sshcommon;

import com.isnetworks.ssh.FileBrowser;
import com.isnetworks.ssh.FileDisplay;
import com.isnetworks.ssh.FileListItem;
import com.mindbright.application.MindTermApp;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.sshcommon.SSHFileTransfer;
import com.mindbright.sshcommon.SSHFileTransferFactory;
import com.mindbright.sshcommon.SSHFileTransferGUIThread;
import com.mindbright.util.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public class SSHFileTransferDialog
extends Dialog {
    public static final int ACT_CLOSE = 0;
    public static final int ACT_TOREMOTE = 1;
    public static final int ACT_TOLOCAL = 2;
    private Button mUploadButton;
    private Button mDownloadButton;
    private Panel mFileDisplayPanel;
    private Panel mMainBottomSectionPanel;
    private Button closeButton;
    private FileDisplay mLocalFileDisplay;
    private FileDisplay mRemoteFileDisplay;
    private FileBrowser mRemoteFileBrowser;
    private FileBrowser mLocalFileBrowser;
    private MindTermApp client;
    private SSHFileTransferFactory fileXferFactory;

    public SSHFileTransferDialog(String string, MindTermApp mindTermApp, SSHFileTransferFactory sSHFileTransferFactory) {
        super(mindTermApp.getParentFrame(), string, false);
        this.setFont(mindTermApp.getParentFrame().getFont());
        this.client = mindTermApp;
        this.fileXferFactory = sSHFileTransferFactory;
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        this.add("South", this.getMainBottomSectionPanel());
        this.add("Center", this.getFileDisplayPanel());
        this.addWindowListener(new AWTConvenience.CloseAdapter(this.closeButton));
        this.pack();
    }

    public void setLocalFileBrowser(FileBrowser fileBrowser) {
        this.mLocalFileBrowser = fileBrowser;
    }

    public void setRemoteFileBrowser(FileBrowser fileBrowser) {
        this.mRemoteFileBrowser = fileBrowser;
    }

    private Panel getMainBottomSectionPanel() {
        if (this.mMainBottomSectionPanel == null) {
            this.mMainBottomSectionPanel = new Panel(new FlowLayout(2));
            this.closeButton = new Button("Close");
            this.closeButton.addActionListener(new Actions(0));
            this.mMainBottomSectionPanel.add(this.closeButton);
        }
        return this.mMainBottomSectionPanel;
    }

    private Panel getFileDisplayPanel() {
        if (this.mFileDisplayPanel == null) {
            this.mFileDisplayPanel = new Panel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 1.0;
            this.mFileDisplayPanel.add((Component)this.getLocalFileDisplay(), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 1.0;
            this.mFileDisplayPanel.add((Component)this.getRemoteFileDisplay(), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new Insets(0, 4, 2, 4);
            this.mFileDisplayPanel.add((Component)this.getDownloadButton(), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.insets = new Insets(2, 4, 0, 4);
            this.mFileDisplayPanel.add((Component)this.getUploadButton(), gridBagConstraints);
        }
        return this.mFileDisplayPanel;
    }

    public FileDisplay getLocalFileDisplay() {
        if (this.mLocalFileDisplay == null) {
            this.mLocalFileDisplay = this.newFileDisplay("Local System");
        }
        return this.mLocalFileDisplay;
    }

    public FileDisplay getRemoteFileDisplay() {
        if (this.mRemoteFileDisplay == null) {
            this.mRemoteFileDisplay = this.newFileDisplay("Remote System");
        }
        return this.mRemoteFileDisplay;
    }

    private FileDisplay newFileDisplay(String string) {
        return new FileDisplay(this.client.getParentFrame(), string, this);
    }

    private Button getDownloadButton() {
        if (this.mDownloadButton == null) {
            this.mDownloadButton = new Button("<--");
            this.mDownloadButton.addActionListener(new Actions(2));
        }
        return this.mDownloadButton;
    }

    private Button getUploadButton() {
        if (this.mUploadButton == null) {
            this.mUploadButton = new Button("-->");
            this.mUploadButton.addActionListener(new Actions(1));
        }
        return this.mUploadButton;
    }

    public void refresh() {
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        try {
            this.mRemoteFileBrowser.refresh();
            this.mLocalFileBrowser.refresh();
        }
        catch (Exception exception) {
            this.logError(exception);
        }
    }

    public void show() {
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
                PrivilegeManager.enablePrivilege("TerminalEmulator");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width > 600 ? 600 : dimension.width;
        int n2 = dimension.height > 400 ? 400 : dimension.height;
        ((Component)this).setSize(n, n2);
        try {
            this.mRemoteFileBrowser.initialize();
            this.mLocalFileBrowser.initialize();
        }
        catch (Exception exception) {
            this.logError(exception);
        }
        super.show();
    }

    public void logError(Exception exception) {
        this.client.alert(exception.getMessage());
    }

    private class Actions
    implements ActionListener {
        private int action;

        public Actions(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.action == 0) {
                ((Component)SSHFileTransferDialog.this).setVisible(false);
                SSHFileTransferDialog.this.mRemoteFileBrowser.disconnect();
            } else {
                boolean bl = this.action == 1;
                try {
                    Object object;
                    String string;
                    String string2;
                    FileListItem[] fileListItemArray;
                    String string3 = SSHFileTransferDialog.this.getLocalFileDisplay().getFileSystemLocationLabelText();
                    String string4 = SSHFileTransferDialog.this.getRemoteFileDisplay().getFileSystemLocationLabelText();
                    if (bl) {
                        fileListItemArray = SSHFileTransferDialog.this.mLocalFileDisplay.getSelectedFiles();
                        string2 = string3;
                        string = string4;
                    } else {
                        fileListItemArray = SSHFileTransferDialog.this.mRemoteFileDisplay.getSelectedFiles();
                        string2 = string4;
                        string = string3;
                    }
                    String[] stringArray = new String[fileListItemArray.length];
                    if (fileListItemArray.length == 0) {
                        throw new Exception("Please select file(s) to transfer");
                    }
                    for (int i = 0; i < fileListItemArray.length; ++i) {
                        stringArray[i] = string2 + fileListItemArray[i].getName();
                    }
                    String[] stringArray2 = new String[]{string};
                    if (!bl) {
                        object = stringArray2;
                        stringArray2 = stringArray;
                        stringArray = object;
                    }
                    object = SSHFileTransferDialog.this.fileXferFactory.create(SSHFileTransferDialog.this.client, new File(string3));
                    new SSHFileTransferGUIThread(SSHFileTransferDialog.this.client, (SSHFileTransfer)object, stringArray, stringArray2, true, false, bl, SSHFileTransferDialog.this);
                }
                catch (Exception exception) {
                    SSHFileTransferDialog.this.logError(exception);
                }
            }
        }
    }
}

