/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.sshcommon;

import com.mindbright.application.MindTermApp;
import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.gui.ProgressBar;
import com.mindbright.sshcommon.SSHFileTransfer;
import com.mindbright.sshcommon.SSHFileTransferDialog;
import com.mindbright.sshcommon.SSHFileTransferProgress;
import com.mindbright.util.StringUtil;
import com.mindbright.util.Util;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public final class SSHFileTransferGUIThread
extends Thread
implements SSHFileTransferProgress,
ActionListener {
    boolean recursive;
    boolean background;
    boolean toRemote;
    SSHFileTransferDialog xferDialog;
    MindTermApp client;
    String[] localFileList;
    String[] remoteFileList;
    Dialog copyIndicator;
    ProgressBar progress;
    SSHFileTransfer fileXfer;
    Thread copyThread;
    Label srcLbl;
    Label dstLbl;
    Label sizeLbl;
    Label nameLbl;
    Label speedLbl;
    Button cancB;
    long startTime;
    long lastTime;
    long totTransSize;
    long fileTransSize;
    long curFileSize;
    long lastSize;
    int fileCnt;
    boolean doneCopying;
    volatile boolean userCancel;
    boolean isCopyThread;

    public SSHFileTransferGUIThread(MindTermApp mindTermApp, SSHFileTransfer sSHFileTransfer, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2, boolean bl3, SSHFileTransferDialog sSHFileTransferDialog) throws Exception {
        this.setName("SSHFileTransferGUIThread1");
        this.isCopyThread = false;
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        this.localFileList = stringArray;
        this.remoteFileList = stringArray2;
        if (!bl3) {
            if (stringArray.length > 1) {
                throw new Exception("Ambiguous local target");
            }
        } else if (stringArray2.length > 1) {
            throw new Exception("Ambiguous remote target");
        }
        this.client = mindTermApp;
        this.fileXfer = sSHFileTransfer;
        this.recursive = bl;
        this.background = bl2;
        this.toRemote = bl3;
        this.fileCnt = 0;
        this.doneCopying = false;
        this.startTime = 0L;
        this.lastTime = 0L;
        this.totTransSize = 0L;
        this.fileTransSize = 0L;
        this.lastSize = 0L;
        this.xferDialog = sSHFileTransferDialog;
        this.start();
    }

    public void run() {
        if (this.isCopyThread) {
            this.copyThreadMain();
        } else {
            this.createGUIAndCopyThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyThreadMain() {
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
                PrivilegeManager.enablePrivilege("TerminalEmulator");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        try {
            this.nameLbl.setText("...connected");
            this.fileXfer.setProgress(this);
            if (this.toRemote) {
                this.fileXfer.copyToRemote(this.localFileList, this.remoteFileList[0], this.recursive);
            } else {
                this.fileXfer.copyToLocal(this.localFileList[0], this.remoteFileList, this.recursive);
            }
            this.copyThread.setPriority(5);
        }
        catch (Exception exception) {
            if (!this.userCancel) {
                this.client.alert("File Transfer Error: " + exception.getMessage());
            }
        }
        finally {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Throwable throwable) {}
        }
        this.nameLbl.setText("Copied " + this.fileCnt + " file" + (this.fileCnt != 1 ? "s" : "") + ".");
        this.sizeLbl.setText(StringUtil.nBytesToString(this.totTransSize, 4));
        this.doneCopying = true;
        if (this.fileXfer != null) {
            this.fileXfer.abort();
        }
        this.cancB.setLabel("Done");
        this.xferDialog.refresh();
        AWTConvenience.setKeyListenerOfChildren(this.copyIndicator, new AWTConvenience.OKCancelAdapter(this.cancB, this.cancB), null);
    }

    private void createGUIAndCopyThread() {
        Object object;
        String string = "localhost:" + this.unQuote(this.localFileList[0]);
        String string2 = this.client.getHost() + ":" + this.unQuote(this.remoteFileList[0]);
        if (!this.toRemote) {
            object = string;
            string = string2;
            string2 = object;
        }
        this.copyIndicator = new Dialog(this.client.getParentFrame(), "MindTerm - File Transfer", false);
        AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(this.copyIndicator);
        object = new Label("Source:");
        aWTGridBagContainer.add((Component)object, 0, 1);
        this.srcLbl = new Label(this.cutName(string, 32));
        aWTGridBagContainer.add(this.srcLbl, 0, 4);
        object = new Label("Destination:");
        aWTGridBagContainer.add((Component)object, 1, 1);
        this.dstLbl = new Label(this.cutName(string2, 32));
        aWTGridBagContainer.add(this.dstLbl, 1, 4);
        object = new Label("Current:");
        aWTGridBagContainer.add((Component)object, 2, 1);
        this.nameLbl = new Label("connecting...");
        aWTGridBagContainer.add(this.nameLbl, 2, 3);
        this.sizeLbl = new Label("");
        aWTGridBagContainer.add(this.sizeLbl, 2, 1);
        aWTGridBagContainer.getConstraints().fill = 0;
        aWTGridBagContainer.getConstraints().anchor = 10;
        aWTGridBagContainer.getConstraints().insets = new Insets(4, 12, 4, 4);
        this.progress = new ProgressBar(512L, 160, 20);
        aWTGridBagContainer.add(this.progress, 3, 3);
        aWTGridBagContainer.getConstraints().fill = 2;
        aWTGridBagContainer.getConstraints().insets = new Insets(4, 4, 4, 4);
        this.speedLbl = new Label("0.0 kB/sec", 1);
        aWTGridBagContainer.add(this.speedLbl, 3, 0);
        this.cancB = new Button("Cancel");
        this.cancB.addActionListener(this);
        aWTGridBagContainer.getConstraints().fill = 0;
        aWTGridBagContainer.getConstraints().ipadx = 2;
        aWTGridBagContainer.getConstraints().ipady = 2;
        aWTGridBagContainer.add(this.cancB, 4, 0);
        AWTConvenience.setBackgroundOfChildren(this.copyIndicator);
        Dimension dimension = this.speedLbl.getSize();
        dimension.width += dimension.width * 2;
        this.speedLbl.setSize(dimension);
        this.sizeLbl.setSize(dimension);
        this.copyIndicator.setResizable(true);
        this.copyIndicator.pack();
        AWTConvenience.placeDialog(this.copyIndicator);
        this.isCopyThread = true;
        this.copyThread = new Thread((Runnable)this, "SSHFileTransferGUIThread2");
        if (this.background) {
            this.copyThread.setPriority(1);
        }
        this.copyThread.start();
        ((Component)this.copyIndicator).setVisible(true);
    }

    public void startFile(String string, long l) {
        this.sizeLbl.setText(StringUtil.nBytesToString(l, 4));
        this.nameLbl.setText(this.unQuote(string));
        this.progress.setMax(l, true);
        this.lastTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = this.lastTime;
        }
        this.curFileSize = l;
        this.fileTransSize = 0L;
        ++this.fileCnt;
    }

    public void startDir(String string) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.toRemote) {
            this.srcLbl.setText(this.cutName("localhost:" + this.unQuote(string), 32));
        } else {
            this.dstLbl.setText(this.cutName("localhost:" + this.unQuote(string), 32));
        }
    }

    public void endFile() {
        this.progress.setValue(this.curFileSize, true);
    }

    public void endDir() {
    }

    public void progress(int n) {
        this.totTransSize += (long)n;
        this.fileTransSize += (long)n;
        if (this.curFileSize > 0L && (this.totTransSize - this.lastSize) * 100L / this.curFileSize >= 1L) {
            this.progress.setValue(this.fileTransSize, !this.background);
            long l = System.currentTimeMillis();
            long l2 = l - this.startTime;
            if (l2 > 0L) {
                long l3 = (long)((double)this.totTransSize / ((double)l2 / 1000.0));
                l2 = l - this.lastTime;
                if (l2 == 0L) {
                    l2 = 1L;
                }
                l3 += (long)((double)(this.totTransSize - this.lastSize) / ((double)l2 / 1000.0));
                this.speedLbl.setText(StringUtil.nBytesToString(l3 >>>= 1, 4) + "/sec");
            }
            this.lastSize = this.totTransSize;
            this.lastTime = l;
        }
    }

    String cutName(String string, int n) {
        if (string.length() > n) {
            String string2 = string.substring(0, (n -= 3) / 2);
            String string3 = string.substring(string.length() - n / 2);
            string = string2 + "..." + string3;
        }
        return string;
    }

    String unQuote(String string) {
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.doneCopying) {
            this.userCancel = true;
            if (this.fileXfer != null) {
                this.fileXfer.abort();
            }
            Thread.yield();
            if (this.copyThread != null) {
                this.copyThread.stop();
            }
        }
        ((Component)this.copyIndicator).setVisible(false);
    }
}

