/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.sshcommon;

import com.mindbright.sshcommon.SSHConsoleRemote;
import com.mindbright.sshcommon.SSHFileTransfer;
import com.mindbright.sshcommon.SSHFileTransferProgress;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class SSHSCP1
implements SSHFileTransfer {
    public static final int DEFAULT_COPY_BUFFER_SZ = 16384;
    private SSHConsoleRemote remote;
    private OutputStream out;
    private InputStream in;
    private File cwd;
    private boolean verbose;
    private SSHFileTransferProgress progress;
    private byte[] copyBuf;

    public SSHSCP1(File file, SSHConsoleRemote sSHConsoleRemote, boolean bl) {
        this.remote = sSHConsoleRemote;
        this.cwd = file;
        this.in = this.in;
        this.out = this.out;
        this.verbose = bl;
        this.copyBuf = new byte[16384];
    }

    public void setProgress(SSHFileTransferProgress sSHFileTransferProgress) {
        this.progress = sSHFileTransferProgress;
    }

    public void abort() {
        this.remote.close();
    }

    public void copyToRemote(String string, String string2, boolean bl) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.cwd, string);
        }
        if (!file.exists()) {
            throw new IOException("File: " + string + " does not exist");
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException("File: " + string + " is not a regular file or directory");
        }
        if (file.isDirectory() && !bl) {
            throw new IOException("File: " + string + " is a directory, use recursive mode");
        }
        if (string2 == null || string2.equals("")) {
            string2 = ".";
        }
        this.remoteConnect("scp " + (file.isDirectory() ? "-d " : "") + "-t " + (bl ? "-r " : "") + (this.verbose ? "-v " : "") + string2);
        this.failsafeReadResponse("After starting remote scp");
        this.writeFileToRemote(file, bl);
        this.remote.close();
    }

    public void copyToRemote(String[] stringArray, String string, boolean bl) throws IOException {
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (stringArray.length == 1) {
            this.copyToRemote(stringArray[0], string, bl);
        } else {
            this.remoteConnect("scp -d -t " + (bl ? "-r " : "") + (this.verbose ? "-v " : "") + string);
            this.readResponse("After starting remote scp");
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (!file.isAbsolute()) {
                    file = new File(this.cwd, stringArray[i]);
                }
                if (!file.isFile() && !file.isDirectory()) {
                    throw new IOException("File: " + file.getName() + " is not a regular file or directory");
                }
                this.writeFileToRemote(file, bl);
            }
            this.remote.close();
        }
    }

    public void copyToLocal(String string, String[] stringArray, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("\"");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\" ");
        }
        String string2 = stringBuffer.toString();
        string2 = string2.trim();
        this.copyToLocal(string, string2, bl);
    }

    public void copyToLocal(String string, String string2, boolean bl) throws IOException {
        File file;
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(this.cwd, string);
        }
        if (file.exists() && !file.isFile() && !file.isDirectory()) {
            throw new IOException("File: " + string + " is not a regular file or directory");
        }
        this.remoteConnect("scp -f " + (bl ? "-r " : "") + (this.verbose ? "-v " : "") + string2);
        this.readFromRemote(file);
        this.remote.close();
    }

    private boolean writeDirToRemote(File file, boolean bl) throws IOException {
        if (!bl) {
            this.writeError("File " + file.getName() + " is a directory, use recursive mode");
            return false;
        }
        this.writeString("D0755 0 " + file.getName() + "\n");
        if (this.progress != null) {
            this.progress.startDir(file.getAbsolutePath());
        }
        this.readResponse("After sedning dirdata");
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            this.writeFileToRemote(file2, bl);
        }
        this.writeString("E\n");
        if (this.progress != null) {
            this.progress.endDir();
        }
        return true;
    }

    private void writeFileToRemote(File file, boolean bl) throws IOException {
        if (file.isDirectory()) {
            if (!this.writeDirToRemote(file, bl)) {
                return;
            }
        } else if (file.isFile()) {
            this.writeString("C0644 " + file.length() + " " + file.getName() + "\n");
            if (this.progress != null) {
                this.progress.startFile(file.getName(), file.length());
            }
            this.readResponse("After sending filedata");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.writeFully(fileInputStream, file.length());
            this.writeByte(0);
            if (this.progress != null) {
                this.progress.endFile();
            }
        } else {
            throw new IOException("Not ordinary file: " + file.getName());
        }
        this.readResponse("After writing file");
    }

    private void readFromRemote(File file) throws IOException {
        String string;
        String[] stringArray = new String[3];
        this.writeByte(0);
        block7: while (true) {
            try {
                string = this.readString();
            }
            catch (EOFException eOFException) {
                return;
            }
            char c = string.charAt(0);
            switch (c) {
                case 'E': {
                    this.writeByte(0);
                    return;
                }
                case 'T': {
                    throw new IOException("SSHSCP1: (T)ime not supported: " + string);
                }
                case 'C': 
                case 'D': {
                    Object object;
                    String string2 = file.getAbsolutePath();
                    this.parseCommand(string, stringArray);
                    if (file.isDirectory()) {
                        string2 = string2 + File.separator + stringArray[2];
                    }
                    File file2 = new File(string2);
                    if (c == 'D') {
                        if (file2.exists()) {
                            if (!file2.isDirectory()) {
                                object = "Invalid target " + file2.getName() + ", must be a directory";
                                this.writeError((String)object);
                                throw new IOException((String)object);
                            }
                        } else if (!file2.mkdir()) {
                            object = "Could not create directory: " + file2.getName();
                            this.writeError((String)object);
                            throw new IOException((String)object);
                        }
                        if (this.progress != null) {
                            this.progress.startDir(file2.getAbsolutePath());
                        }
                        this.readFromRemote(file2);
                        if (this.progress == null) continue block7;
                        this.progress.endDir();
                        continue block7;
                    }
                    object = new FileOutputStream(file2);
                    this.writeByte(0);
                    long l = Long.parseLong(stringArray[1]);
                    if (this.progress != null) {
                        this.progress.startFile(file2.getName(), l);
                    }
                    this.readFully((FileOutputStream)object, l);
                    this.readResponse("After reading file");
                    if (this.progress != null) {
                        this.progress.endFile();
                    }
                    this.writeByte(0);
                    continue block7;
                }
            }
            break;
        }
        this.writeError("Unexpected cmd: " + string);
        throw new IOException("Unexpected cmd: " + string);
    }

    private void parseCommand(String string, String[] stringArray) throws IOException {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        if (n == -1 || n2 == -1) {
            this.writeError("Syntax error in cmd");
            throw new IOException("Syntax error in cmd");
        }
        stringArray[0] = string.substring(1, n);
        stringArray[1] = string.substring(n + 1, n2);
        stringArray[2] = string.substring(n2 + 1);
    }

    private void failsafeReadResponse(String string) throws IOException {
        int n;
        while ((n = this.readByte()) >= 10 && n < 127) {
        }
        if (n == 0) {
            return;
        }
        if (n == -1) {
            throw new EOFException("SSHSCP1: premature EOF");
        }
        String string2 = this.readString();
        if (n == 2) {
            throw new IOException(string2);
        }
        throw new IOException("SSHSCP1.readResponse, error: " + string2);
    }

    private void readResponse(String string) throws IOException {
        int n = this.readByte();
        if (n == 0) {
            return;
        }
        if (n == -1) {
            throw new EOFException("SSHSCP1: premature EOF");
        }
        String string2 = this.readString();
        if (n == 2) {
            throw new IOException(string2);
        }
        throw new IOException("SSHSCP1.readResponse, error: " + string2);
    }

    private void writeError(String string) throws IOException {
        this.writeByte(1);
        this.writeString(string);
    }

    private int readByte() throws IOException {
        return this.in.read();
    }

    private String readString() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.readByte()) != 10 && n >= 0) {
            this.copyBuf[n2++] = (byte)n;
        }
        if (n == -1) {
            throw new EOFException("SSHSCP1: premature EOF");
        }
        if (this.copyBuf[0] == 10) {
            throw new IOException("Unexpected <NL>");
        }
        if (this.copyBuf[0] == 2 || this.copyBuf[0] == 1) {
            String string = new String(this.copyBuf, 1, n2 - 1);
            if (this.copyBuf[0] == 2) {
                throw new IOException(string);
            }
            throw new IOException("SSHSCP.readString, error: " + string);
        }
        return new String(this.copyBuf, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFully(FileOutputStream fileOutputStream, long l) throws IOException {
        try {
            long l2;
            for (long i = 0L; i < l; i += l2) {
                l2 = this.in.read(this.copyBuf, 0, (int)(l - i < 16384L ? l - i : 16384L));
                if (l2 == -1L) {
                    throw new EOFException("SSHSCP1: premature EOF");
                }
                fileOutputStream.write(this.copyBuf, 0, (int)l2);
                if (this.progress == null) continue;
                this.progress.progress((int)l2);
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    private void writeByte(int n) throws IOException {
        this.out.write(n);
    }

    private void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.out.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFully(FileInputStream fileInputStream, long l) throws IOException {
        try {
            long l2;
            for (long i = 0L; i < l; i += l2) {
                l2 = fileInputStream.read(this.copyBuf, 0, (int)(l - i < 16384L ? l - i : 16384L));
                if (l2 == -1L) {
                    throw new EOFException("SSHSCP1: premature EOF");
                }
                this.out.write(this.copyBuf, 0, (int)l2);
                if (this.progress == null) continue;
                this.progress.progress((int)l2);
            }
        }
        finally {
            fileInputStream.close();
        }
    }

    private void remoteConnect(String string) throws IOException {
        if (!this.remote.command(string)) {
            throw new IOException("SSHSCP.remoteConnect, failed to run: " + string);
        }
        this.in = this.remote.getStdOut();
        this.out = this.remote.getStdIn();
    }
}

