/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class TerminalDefProps {
    public static final String[] terminalTypes = new String[]{"xterm", "linux", "scoansi", "att6386", "sun", "aixterm", "vt220", "vt100", "ansi", "vt52", "xterm-color", "linux-lat", "", "at386", "", "", "vt320", "vt102"};
    public static final int PROP_NAME = 0;
    public static final int PROP_VALUE = 1;
    public static Properties defaultProperties = new Properties();
    public static Hashtable oldPropNames = new Hashtable();
    public static final String[][] defaultPropDesc = new String[][]{{"rev-video", "false"}, {"autowrap", "true"}, {"rev-autowrap", "false"}, {"insert-mode", "false"}, {"auto-linefeed", "false"}, {"repos-input", "true"}, {"repos-output", "true"}, {"visible-cursor", "true"}, {"local-echo", "false"}, {"visual-bell", "false"}, {"map-ctrl-space", "true"}, {"80x132-toggle", "false"}, {"80x132-enable", "true"}, {"passthru-prn-enable", "true"}, {"local-pgkeys", "false"}, {"copy-crnl", "false"}, {"ascii-line", "false"}, {"copy-select", "true"}, {"font-name", TerminalDefProps.defaultFont()}, {"font-size", "12"}, {"geometry", "80x24"}, {"term-type", terminalTypes[0]}, {"save-lines", "512"}, {"scrollbar", "right"}, {"bg-color", "white"}, {"fg-color", "black"}, {"cursor-color", "i_blue"}, {"resize-gravity", "bottom"}, {"backspace-send", "DEL"}, {"delete-send", "DEL"}, {"select-delim", "\" \""}, {"paste-button", "middle"}, {"input-charset", "none"}, {"line-space-delta", "0"}};
    public static String[] systemFonts;

    public static String listAvailableTerminalTypes() {
        String string = " ";
        for (int i = 0; i < terminalTypes.length; ++i) {
            string = string + terminalTypes[i] + " ";
        }
        return string;
    }

    public static String backwardCompatProp(String string) {
        String string2 = (String)oldPropNames.get(string);
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public static void setAsDefault(Properties properties) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            string = TerminalDefProps.backwardCompatProp(string);
            ((Hashtable)defaultProperties).put(string, string2);
        }
    }

    public static String fontList() {
        if (systemFonts == null) {
            systemFonts = Toolkit.getDefaultToolkit().getFontList();
        }
        String string = "";
        for (int i = 0; i < systemFonts.length; ++i) {
            string = string + systemFonts[i];
            if (i >= systemFonts.length - 1) continue;
            string = string + ", ";
        }
        return string;
    }

    public static String defaultFont() {
        if (TerminalDefProps.fontExists("monospaced")) {
            return "Monospaced";
        }
        if (TerminalDefProps.fontExists("courier")) {
            return "Courier";
        }
        if (TerminalDefProps.fontExists("dialoginput")) {
            return "DialogInput";
        }
        return systemFonts[0];
    }

    public static boolean fontExists(String string) {
        try {
            int n;
            if (systemFonts == null) {
                systemFonts = Toolkit.getDefaultToolkit().getFontList();
            }
            for (n = 0; n < systemFonts.length && !systemFonts[n].equalsIgnoreCase(string); ++n) {
            }
            if (n == systemFonts.length) {
                return false;
            }
        }
        catch (Error error) {
            return true;
        }
        return true;
    }

    public static boolean isProperty(String string) {
        string = TerminalDefProps.backwardCompatProp(string);
        return ((Hashtable)defaultProperties).containsKey(string);
    }

    static {
        for (int i = 0; i < defaultPropDesc.length; ++i) {
            ((Hashtable)defaultProperties).put(defaultPropDesc[i][0], defaultPropDesc[i][1]);
        }
        oldPropNames.put("rv", "rev-video");
        oldPropNames.put("aw", "autowrap");
        oldPropNames.put("rw", "rev-autowrap");
        oldPropNames.put("im", "insert-mode");
        oldPropNames.put("al", "auto-linefeed");
        oldPropNames.put("sk", "repos-input");
        oldPropNames.put("si", "repos-output");
        oldPropNames.put("vi", "visible-cursor");
        oldPropNames.put("le", "local-echo");
        oldPropNames.put("vb", "visual-bell");
        oldPropNames.put("ct", "map-ctrl-space");
        oldPropNames.put("dc", "80x132-toggle");
        oldPropNames.put("da", "80x132-enable");
        oldPropNames.put("lp", "local-pgkeys");
        oldPropNames.put("sc", "copy-crnl");
        oldPropNames.put("ad", "ascii-line");
        oldPropNames.put("cs", "copy-select");
        oldPropNames.put("fn", "font-name");
        oldPropNames.put("fs", "font-size");
        oldPropNames.put("gm", "geometry");
        oldPropNames.put("te", "term-type");
        oldPropNames.put("sl", "save-lines");
        oldPropNames.put("sb", "scrollbar");
        oldPropNames.put("bg", "bg-color");
        oldPropNames.put("fg", "fg-color");
        oldPropNames.put("cc", "cursor-color");
        oldPropNames.put("rg", "resize-gravity");
        oldPropNames.put("bs", "backspace-send");
        oldPropNames.put("de", "delete-send");
        oldPropNames.put("sd", "select-delim");
        oldPropNames.put("pb", "paste-button");
    }
}

