/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.terminal.TerminalInputListener;

public abstract class TerminalInputChaff
implements TerminalInputListener,
Runnable {
    private Thread chaffThread;
    private volatile boolean chaffActive;
    private volatile long chaffLastKeyTime;
    private int[] lastKeyBuf;
    private int lastKeyROffs;
    private int lastKeyWOffs;

    public void startChaff() {
        if (!this.chaffActive) {
            this.chaffActive = true;
            this.lastKeyBuf = new int[4];
            this.lastKeyROffs = 0;
            this.lastKeyWOffs = 0;
            this.chaffThread = new Thread((Runnable)this, "SSH2TerminalAdapterImpl.chaff");
            this.chaffThread.setDaemon(true);
            this.chaffThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopChaff() {
        if (this.chaffActive) {
            this.chaffActive = false;
            Thread thread = this.chaffThread;
            synchronized (thread) {
                this.chaffThread.notify();
            }
            this.chaffThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typedChar(char c) {
        if (this.chaffThread == null) {
            this.sendTypedChar(c);
        } else {
            TerminalInputChaff terminalInputChaff = this;
            synchronized (terminalInputChaff) {
                this.lastKeyBuf[this.lastKeyWOffs++] = c;
                this.lastKeyWOffs &= 3;
            }
            this.dispenseChaff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: while (this.chaffActive) {
            try {
                long l;
                Thread thread = this.chaffThread;
                synchronized (thread) {
                    this.chaffThread.wait();
                }
                int n = (int)(System.currentTimeMillis() ^ (long)new Object().hashCode()) & 0x1FF;
                do {
                    int n2 = -1;
                    TerminalInputChaff terminalInputChaff = this;
                    synchronized (terminalInputChaff) {
                        if (this.lastKeyWOffs != this.lastKeyROffs) {
                            n2 = this.lastKeyBuf[this.lastKeyROffs++];
                            this.lastKeyROffs &= 3;
                        }
                    }
                    if (n2 >= 0) {
                        this.sendTypedChar(n2);
                    } else {
                        this.sendFakeChar();
                    }
                    Thread.sleep(30L);
                    l = System.currentTimeMillis();
                    if (!this.chaffActive) continue block8;
                } while (l - this.chaffLastKeyTime < (long)(1500 + n));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispenseChaff() {
        long l;
        if (this.chaffThread != null && (l = System.currentTimeMillis()) - this.chaffLastKeyTime > 1000L) {
            this.chaffLastKeyTime = l;
            Thread thread = this.chaffThread;
            synchronized (thread) {
                this.chaffThread.notify();
            }
        }
    }

    protected abstract void sendTypedChar(int var1);

    protected abstract void sendFakeChar();

    public abstract /* synthetic */ void signalWindowChanged(int var1, int var2, int var3, int var4);

    public abstract /* synthetic */ void sendBytes(byte[] var1);
}

