/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AlertDialog;
import com.mindbright.gui.ConfirmDialog;
import com.mindbright.terminal.GlobalClipboard;
import com.mindbright.terminal.TerminalCapture;
import com.mindbright.terminal.TerminalDefProps;
import com.mindbright.terminal.TerminalMenuHandler;
import com.mindbright.terminal.TerminalMenuListener;
import com.mindbright.terminal.TerminalPrinter;
import com.mindbright.terminal.TerminalWin;
import com.mindbright.terminal.TerminalXTerm;
import com.mindbright.util.Util;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

public final class TerminalMenuHandlerFull
extends TerminalMenuHandler
implements ActionListener,
ItemListener,
TerminalPrinter {
    protected static final int ACT_SETTINGS = 0;
    protected static final int ACT_COLORS = 1;
    protected static final int ACT_MISC = 2;
    protected static final int ACT_FIND_CANCEL = 3;
    protected static final int ACT_FIND = 4;
    TerminalWin term;
    String titleName;
    Object[][] menuItems;
    TerminalMenuListener listener;
    static final String[] settingsMenu = new String[]{"Terminal Settings", "Emulation", "Resize gravity", "Font", "Savelines", "Scrollbar", "Colors", "Backspace"};
    static final int MENU_FILE = 0;
    static final int MENU_EDIT = 1;
    static final int MENU_SETTINGS = 2;
    static final int MENU_OPTIONS = 3;
    static final int M_FILE_CAPTURE = 1;
    static final int M_FILE_SEND = 2;
    static final int M_FILE_CLOSE = 4;
    static final int M_SET_TERM = 1;
    static final int M_SET_TERM_MSC = 2;
    static final int M_SET_TERM_COL = 3;
    static final int M_EDIT_COPY = 1;
    static final int M_EDIT_PASTE = 2;
    static final int M_EDIT_CPPASTE = 3;
    static final int M_EDIT_SELALL = 4;
    static final int M_EDIT_FIND = 5;
    static final int M_EDIT_CLS = 7;
    static final int M_EDIT_CLEARSB = 8;
    static final int M_EDIT_VTRESET = 9;
    static final String[][] menuTexts = new String[][]{{"File", "_Capture To File...", "Send ASCII File...", null, "Close"}, {"Edit", "Copy Ctrl+Ins", "Paste Shift+Ins", "Copy & Paste", "Select All", "Find...", null, "Clear Screen", "Clear Scrollback", "VT Reset"}, {"Settings", "Terminal...", "Terminal Misc...", "Terminal Colors..."}, {"VT Options", "_Reverse Video", "_Auto Wraparound", "_Reverse Wraparound", "_Insert mode", "_Auto Linefeed", "_Scroll to Bottom On Key Press", "_Scroll to Bottom On Tty Output", "_Visible Cursor", "_Local Echo", "_Visual Bell", "_Map <CTRL>+<SPC> To ^@", "_Toggle 80/132 Columns", "_Enable 80/132 Switching", "_Enable Passthrough Print"}};
    static final int NO_SHORTCUT = -1;
    static final int[][] menuShortCuts = new int[][]{{-1, -1, -1, -1, 69}, {-1, -1, -1, -1, 65, 70, -1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    Dialog settingsDialog;
    Choice choiceTE;
    Choice choiceFN;
    Choice choiceSB;
    TextField textFS;
    TextField textRows;
    TextField textCols;
    TextField textInitPos;
    Label lblAlert;
    static final String[] sb = new String[]{"left", "right", "none"};
    static final String[] te = TerminalXTerm.getTerminalTypes();
    static final String[] fn = Toolkit.getDefaultToolkit().getFontList();
    TextField textFG;
    TextField textBG;
    TextField textCC;
    Choice choiceFG;
    Choice choiceBG;
    Choice choiceCC;
    Dialog colorsDialog;
    Label lblAlertC;
    Dialog settingsDialog2;
    Choice choiceRG;
    Choice choicePB;
    Checkbox cbDEL;
    Checkbox cbBS;
    Checkbox cbCpOnSel;
    Checkbox cbCpWinCR;
    Checkbox cbAsciiLD;
    Checkbox cbLocPG;
    TextField textSL;
    TextField textSD;
    static final String[] rg = new String[]{"bottom", "top"};
    static final String[] pb = new String[]{"middle", "right", "shift+left"};
    Dialog findDialog = null;
    TextField findText;
    Label label;
    Checkbox dirCheck;
    Checkbox caseCheck;
    Button findBut;
    Button cancBut;
    int curFindRow = 0;
    int curFindCol = 0;
    int findLen = 0;
    FileDialog sendFileDialog = null;
    FileDialog captureToFileDialog = null;
    TerminalCapture termCapture;
    FileOutputStream printerOut;

    public TerminalMenuHandlerFull() {
        this("MindTerm");
    }

    public TerminalMenuHandlerFull(String string) {
        this.setTitleName(string);
    }

    public void setTitleName(String string) {
        this.titleName = string;
    }

    public void setTerminalWin(TerminalWin terminalWin) {
        this.term = terminalWin;
        terminalWin.attachPrinter(this);
    }

    public void setTerminalMenuListener(TerminalMenuListener terminalMenuListener) {
        this.listener = terminalMenuListener;
    }

    public void addBasicMenus(TerminalWin terminalWin, Frame frame) {
        MenuBar menuBar = frame.getMenuBar();
        this.setTerminalWin(terminalWin);
        terminalWin.setMenus(this);
        menuBar.add(this.getMenu(0));
        menuBar.add(this.getMenu(1));
        menuBar.add(this.getMenu(2));
        menuBar.add(this.getMenu(3));
        frame.addWindowListener(new AWTConvenience.CloseAdapter((MenuItem)this.menuItems[0][4]));
        terminalWin.setClipboard(GlobalClipboard.getClipboardHandler(this));
        terminalWin.updateMenus();
    }

    public void updateSelection(boolean bl) {
        ((MenuItem)this.menuItems[1][1]).setEnabled(bl);
        ((MenuItem)this.menuItems[1][3]).setEnabled(bl);
    }

    public void update() {
        if (this.listener != null) {
            this.listener.update();
        }
    }

    public final void termSettingsDialog() {
        if (this.settingsDialog == null) {
            this.settingsDialog = new Dialog(this.term.ownerFrame, settingsMenu[0], true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.settingsDialog.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 6;
            Label label = new Label("Terminal type:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            this.choiceTE = AWTConvenience.newChoice(te);
            gridBagLayout.setConstraints(this.choiceTE, gridBagConstraints);
            this.settingsDialog.add(this.choiceTE);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            label = new Label("Columns:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            gridBagConstraints.gridwidth = 2;
            this.textCols = new TextField("", 3);
            gridBagLayout.setConstraints(this.textCols, gridBagConstraints);
            this.settingsDialog.add(this.textCols);
            label = new Label("Rows:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            this.textRows = new TextField("", 3);
            gridBagLayout.setConstraints(this.textRows, gridBagConstraints);
            this.settingsDialog.add(this.textRows);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            label = new Label("Font:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            gridBagConstraints.gridwidth = 6;
            this.choiceFN = AWTConvenience.newChoice(fn);
            gridBagLayout.setConstraints(this.choiceFN, gridBagConstraints);
            this.settingsDialog.add(this.choiceFN);
            gridBagConstraints.gridwidth = 2;
            this.textFS = new TextField("", 3);
            gridBagLayout.setConstraints(this.textFS, gridBagConstraints);
            this.settingsDialog.add(this.textFS);
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 6;
            label = new Label("Scrollback buffer:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            this.textSL = new TextField("", 4);
            gridBagLayout.setConstraints(this.textSL, gridBagConstraints);
            this.settingsDialog.add(this.textSL);
            gridBagConstraints.gridy = 4;
            label = new Label("Scrollbar position:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            this.choiceSB = AWTConvenience.newChoice(sb);
            gridBagLayout.setConstraints(this.choiceSB, gridBagConstraints);
            this.settingsDialog.add(this.choiceSB);
            this.lblAlert = new Label("", 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.lblAlert, gridBagConstraints);
            this.settingsDialog.add(this.lblAlert);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("OK");
            panel.add(button);
            button.addActionListener(new Actions(0));
            button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.settingsDialog));
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.settingsDialog.add(panel);
            this.settingsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.settingsDialog);
            this.settingsDialog.setResizable(true);
            this.settingsDialog.pack();
        }
        this.choiceTE.select(this.term.getProperty("te"));
        this.choiceFN.select(this.term.getProperty("fn"));
        this.textFS.setText(this.term.getProperty("fs"));
        this.textCols.setText(String.valueOf(this.term.cols()));
        this.textRows.setText(String.valueOf(this.term.rows()));
        this.choiceSB.select(this.term.getProperty("sb"));
        this.textSL.setText(this.term.getProperty("sl"));
        this.lblAlert.setText("");
        AWTConvenience.placeDialog(this.settingsDialog);
        this.choiceTE.requestFocus();
        ((Component)this.settingsDialog).setVisible(true);
    }

    public final void termColorsDialog() {
        if (this.colorsDialog == null) {
            this.colorsDialog = new Dialog(this.term.ownerFrame, "Terminal Colors", true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.colorsDialog.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 10;
            Label label = new Label("Foreground color:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.colorsDialog.add(label);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 6;
            this.choiceFG = new Choice();
            gridBagLayout.setConstraints(this.choiceFG, gridBagConstraints);
            this.colorsDialog.add(this.choiceFG);
            Actions actions = new Actions(-1);
            this.choiceFG.addItemListener(actions);
            this.textFG = new TextField("", 10);
            gridBagLayout.setConstraints(this.textFG, gridBagConstraints);
            this.colorsDialog.add(this.textFG);
            gridBagConstraints.gridy = 2;
            label = new Label("Background color:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.colorsDialog.add(label);
            gridBagConstraints.gridy = 3;
            this.choiceBG = new Choice();
            gridBagLayout.setConstraints(this.choiceBG, gridBagConstraints);
            this.colorsDialog.add(this.choiceBG);
            this.choiceBG.addItemListener(actions);
            this.textBG = new TextField("", 10);
            gridBagLayout.setConstraints(this.textBG, gridBagConstraints);
            this.colorsDialog.add(this.textBG);
            gridBagConstraints.gridy = 4;
            label = new Label("Cursor color:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.colorsDialog.add(label);
            gridBagConstraints.gridy = 5;
            this.choiceCC = new Choice();
            gridBagLayout.setConstraints(this.choiceCC, gridBagConstraints);
            this.colorsDialog.add(this.choiceCC);
            this.choiceCC.addItemListener(actions);
            this.textCC = new TextField("", 10);
            gridBagLayout.setConstraints(this.textCC, gridBagConstraints);
            this.colorsDialog.add(this.textCC);
            this.lblAlertC = new Label("", 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 6;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.lblAlertC, gridBagConstraints);
            this.colorsDialog.add(this.lblAlertC);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("OK");
            panel.add(button);
            button.addActionListener(new Actions(1));
            button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.colorsDialog));
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.colorsDialog.add(panel);
            this.fillChoices();
            this.colorsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.colorsDialog);
            this.colorsDialog.setResizable(true);
            this.colorsDialog.pack();
        }
        this.initColorSelect(this.choiceFG, this.textFG, this.term.getProperty("fg"));
        this.initColorSelect(this.choiceBG, this.textBG, this.term.getProperty("bg"));
        this.initColorSelect(this.choiceCC, this.textCC, this.term.getProperty("cc"));
        this.updateColors();
        this.lblAlertC.setText("");
        AWTConvenience.placeDialog(this.colorsDialog);
        this.choiceFG.requestFocus();
        ((Component)this.colorsDialog).setVisible(true);
    }

    void initColorSelect(Choice choice, TextField textField, String string) {
        if (Character.isDigit(string.charAt(0))) {
            choice.select("custom rgb");
            textField.setText(string);
        } else {
            textField.setText("");
            textField.setEnabled(false);
            choice.select(string);
        }
    }

    void checkColorSelect(Choice choice, TextField textField) {
        int n = choice.getSelectedIndex();
        if (n == 0) {
            boolean bl = textField.isEnabled();
            if (!bl) {
                textField.setEditable(true);
                textField.setEnabled(true);
                textField.setBackground(SystemColor.text);
                textField.requestFocus();
            }
        } else {
            textField.setText("");
            textField.setEditable(false);
            textField.setEnabled(false);
            textField.setBackground(TerminalWin.termColors[n - 1]);
        }
    }

    void updateColors() {
        this.checkColorSelect(this.choiceFG, this.textFG);
        this.checkColorSelect(this.choiceBG, this.textBG);
        this.checkColorSelect(this.choiceCC, this.textCC);
    }

    String getSelectedColor(Choice choice, TextField textField) {
        String string = choice.getSelectedIndex() == 0 ? textField.getText() : choice.getSelectedItem();
        return string;
    }

    void fillChoices() {
        this.choiceBG.add("custom rgb");
        this.choiceFG.add("custom rgb");
        this.choiceCC.add("custom rgb");
        int n = 0;
        while (true) {
            if (n >= TerminalWin.termColorNames.length) break;
            this.choiceBG.add(TerminalWin.termColorNames[n]);
            this.choiceFG.add(TerminalWin.termColorNames[n]);
            this.choiceCC.add(TerminalWin.termColorNames[n]);
            ++n;
        }
    }

    public final void termSettingsDialog2() {
        Object object;
        if (this.settingsDialog2 == null) {
            this.settingsDialog2 = new Dialog(this.term.ownerFrame, "Terminal Misc. Settings", true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.settingsDialog2.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(4, 4, 0, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 4;
            object = new Label("Paste button:");
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.settingsDialog2.add((Component)object);
            this.choicePB = AWTConvenience.newChoice(pb);
            gridBagLayout.setConstraints(this.choicePB, gridBagConstraints);
            this.settingsDialog2.add(this.choicePB);
            gridBagConstraints.gridy = 1;
            object = new Label("Select delim.:");
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.settingsDialog2.add((Component)object);
            this.textSD = new TextField("", 4);
            gridBagLayout.setConstraints(this.textSD, gridBagConstraints);
            this.settingsDialog2.add(this.textSD);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 8;
            gridBagConstraints.insets = new Insets(4, 16, 0, 0);
            this.cbCpWinCR = new Checkbox("Copy <cr><nl> line ends");
            gridBagLayout.setConstraints(this.cbCpWinCR, gridBagConstraints);
            this.settingsDialog2.add(this.cbCpWinCR);
            gridBagConstraints.gridy = 3;
            this.cbCpOnSel = new Checkbox("Copy on select");
            gridBagLayout.setConstraints(this.cbCpOnSel, gridBagConstraints);
            this.settingsDialog2.add(this.cbCpOnSel);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.insets = new Insets(4, 4, 0, 0);
            object = new Label("Resize gravity:");
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            this.settingsDialog2.add((Component)object);
            this.choiceRG = AWTConvenience.newChoice(rg);
            gridBagLayout.setConstraints(this.choiceRG, gridBagConstraints);
            this.settingsDialog2.add(this.choiceRG);
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 8;
            gridBagConstraints.insets = new Insets(4, 16, 0, 0);
            this.cbBS = new Checkbox("Backspace sends Delete");
            gridBagLayout.setConstraints(this.cbBS, gridBagConstraints);
            this.settingsDialog2.add(this.cbBS);
            gridBagConstraints.gridy = 6;
            this.cbDEL = new Checkbox("Delete sends Backspace");
            gridBagLayout.setConstraints(this.cbDEL, gridBagConstraints);
            this.settingsDialog2.add(this.cbDEL);
            gridBagConstraints.gridy = 7;
            this.cbLocPG = new Checkbox("Local PgUp/PgDn");
            gridBagLayout.setConstraints(this.cbLocPG, gridBagConstraints);
            this.settingsDialog2.add(this.cbLocPG);
            gridBagConstraints.gridy = 8;
            this.cbAsciiLD = new Checkbox("Use ASCII for line draw");
            gridBagLayout.setConstraints(this.cbAsciiLD, gridBagConstraints);
            this.settingsDialog2.add(this.cbAsciiLD);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("OK");
            panel.add(button);
            button.addActionListener(new Actions(2));
            button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.settingsDialog2));
            gridBagConstraints.gridy = 9;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.settingsDialog2.add(panel);
            this.settingsDialog2.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.settingsDialog2);
            this.settingsDialog2.setResizable(true);
            this.settingsDialog2.pack();
        }
        this.choicePB.select(this.term.getProperty("pb"));
        object = this.term.getProperty("sd");
        if (((String)object).charAt(0) == '\"' && ((String)object).charAt(((String)object).length() - 1) == '\"') {
            object = ((String)object).substring(1, ((String)object).length() - 1);
        }
        this.textSD.setText((String)object);
        this.cbCpOnSel.setState(Boolean.valueOf(this.term.getProperty("cs")));
        this.cbCpWinCR.setState(Boolean.valueOf(this.term.getProperty("sc")));
        this.choiceRG.select(this.term.getProperty("rg"));
        if (this.term.getProperty("bs").equals("DEL")) {
            this.cbBS.setState(true);
        } else {
            this.cbBS.setState(false);
        }
        if (this.term.getProperty("de").equals("BS")) {
            this.cbDEL.setState(true);
        } else {
            this.cbDEL.setState(false);
        }
        this.cbAsciiLD.setState(Boolean.valueOf(this.term.getProperty("ad")));
        this.cbLocPG.setState(Boolean.valueOf(this.term.getProperty("lp")));
        AWTConvenience.placeDialog(this.settingsDialog2);
        this.choiceRG.requestFocus();
        ((Component)this.settingsDialog2).setVisible(true);
    }

    public final void findDialog() {
        if (this.findDialog == null) {
            this.findDialog = new Dialog(this.term.ownerFrame, this.titleName + " - Find", false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.findDialog.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            this.label = new Label("Find:");
            gridBagLayout.setConstraints(this.label, gridBagConstraints);
            this.findDialog.add(this.label);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 5;
            this.findText = new TextField("", 26);
            gridBagLayout.setConstraints(this.findText, gridBagConstraints);
            this.findDialog.add(this.findText);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.ipadx = 4;
            gridBagConstraints.ipady = 4;
            gridBagConstraints.insets = new Insets(6, 3, 3, 6);
            this.findBut = new Button("Find");
            gridBagLayout.setConstraints(this.findBut, gridBagConstraints);
            this.findDialog.add(this.findBut);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            this.caseCheck = new Checkbox("Case sensitive");
            gridBagLayout.setConstraints(this.caseCheck, gridBagConstraints);
            this.findDialog.add(this.caseCheck);
            this.dirCheck = new Checkbox("Find backwards");
            gridBagLayout.setConstraints(this.dirCheck, gridBagConstraints);
            this.findDialog.add(this.dirCheck);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.ipadx = 4;
            gridBagConstraints.ipady = 4;
            gridBagConstraints.insets = new Insets(3, 3, 6, 6);
            gridBagConstraints.fill = 2;
            this.cancBut = new Button("Cancel");
            gridBagLayout.setConstraints(this.cancBut, gridBagConstraints);
            this.findDialog.add(this.cancBut);
            this.cancBut.addActionListener(new Actions(3));
            this.findBut.addActionListener(new Actions(4));
            this.findDialog.addWindowListener(new AWTConvenience.CloseAdapter(this.cancBut));
            AWTConvenience.setBackgroundOfChildren(this.findDialog);
            AWTConvenience.setKeyListenerOfChildren(this.findDialog, new AWTConvenience.OKCancelAdapter(this.findBut, this.cancBut), null);
            this.findDialog.setResizable(true);
            this.findDialog.pack();
        }
        AWTConvenience.placeDialog(this.findDialog);
        this.findText.requestFocus();
        ((Component)this.findDialog).setVisible(true);
    }

    static final boolean doMatch(String string, char c, char[] cArray, int n, boolean bl, int n2) {
        if (bl) {
            if (cArray[n] != c) {
                return false;
            }
            String string2 = new String(cArray, n, n2);
            if (string2.equals(string)) {
                return true;
            }
        } else {
            if (Character.toLowerCase(cArray[n]) != c) {
                return false;
            }
            String string3 = new String(cArray, n, n2);
            if (string3.equalsIgnoreCase(string)) {
                return true;
            }
        }
        return false;
    }

    void doFind() {
        int n;
        char c;
        String string = this.findText.getText();
        int n2 = string.length();
        boolean bl = this.caseCheck.getState();
        boolean bl2 = this.dirCheck.getState();
        int n3 = this.term.saveVisTop + this.term.curRow;
        boolean bl3 = false;
        int n4 = 0;
        char c2 = c = bl ? string.charAt(0) : Character.toLowerCase(string.charAt(0));
        if (this.findLen > 0) {
            this.term.clearSelection(this.curFindRow, this.curFindCol, this.curFindRow, this.curFindCol + this.findLen - 1);
        }
        if (bl2) {
            int n5;
            if (this.findLen > 0) {
                n5 = this.curFindCol - 1;
            } else {
                this.curFindRow = n3;
                n5 = this.term.cols - n2;
            }
            block0: for (n = this.curFindRow; n >= 0; --n) {
                for (n4 = n5; n4 >= 0; --n4) {
                    if (this.term.screen[n][n4] != '\u0000' && TerminalMenuHandlerFull.doMatch(string, c, this.term.screen[n], n4, bl, n2)) break block0;
                }
                n5 = this.term.cols - n2;
            }
            if (n >= 0) {
                bl3 = true;
            }
        } else {
            int n6 = this.curFindCol + this.findLen;
            block2: for (n = this.curFindRow; n < n3; ++n) {
                for (n4 = n6; n4 < this.term.cols - n2; ++n4) {
                    if (this.term.screen[n][n4] != '\u0000' && TerminalMenuHandlerFull.doMatch(string, c, this.term.screen[n], n4, bl, n2)) break block2;
                }
                n6 = 0;
            }
            if (n < n3) {
                bl3 = true;
            }
        }
        if (bl3) {
            this.findLen = n2;
            if (this.term.saveVisTop < n) {
                this.term.visTop = this.term.saveVisTop;
            } else if (this.term.visTop > n || n - this.term.visTop > this.term.rows) {
                this.term.visTop = n;
            }
            this.term.updateScrollbarValues();
            this.term.makeAllDirty(false);
            this.term.makeSelection(n, n4, n, n4 + n2 - 1);
            this.curFindRow = n;
            this.curFindCol = n4;
            this.findLen = n2;
        } else {
            this.term.doBell();
            this.curFindRow = 0;
            this.curFindCol = 0;
            this.findLen = 0;
        }
    }

    public final void sendFileDialog() {
        if (this.sendFileDialog == null) {
            this.sendFileDialog = new FileDialog(this.term.ownerFrame, this.titleName + " - Select ASCII-file to send", 0);
        }
        ((Component)this.sendFileDialog).setVisible(true);
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        String string = this.sendFileDialog.getFile();
        String string2 = this.sendFileDialog.getDirectory();
        if (string != null && string.length() > 0) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string2 + string);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                this.term.sendBytes(byArray);
            }
            catch (Throwable throwable) {
                AlertDialog.show(this.titleName + " - Alert", throwable.getMessage(), this.term.ownerFrame);
            }
        }
    }

    public final FileOutputStream chooseFileDialog(String string) {
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        if (this.captureToFileDialog == null) {
            this.captureToFileDialog = new FileDialog(this.term.ownerFrame, this.titleName + " - " + string, 1);
        }
        ((Component)this.captureToFileDialog).setVisible(true);
        String string2 = this.captureToFileDialog.getFile();
        String string3 = this.captureToFileDialog.getDirectory();
        if (string2 != null && string2.length() > 0) {
            try {
                if (!string3.endsWith(File.separator)) {
                    string3 = string3 + File.separator;
                }
                File file = new File(string3 + string2);
                boolean bl = false;
                if (file.exists()) {
                    bl = ConfirmDialog.show(this.titleName + " - File exists", "File exists, overwrite or append?", 0, 0, "Append", "Overwrite", true, this.term.ownerFrame, false);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(string3 + string2, bl);
                return fileOutputStream;
            }
            catch (Throwable throwable) {
                AlertDialog.show(this.titleName + " - Alert", throwable.getMessage(), this.term.ownerFrame);
            }
        }
        return null;
    }

    public final boolean captureToFileDialog() {
        FileOutputStream fileOutputStream;
        if (Util.isNetscapeJava()) {
            try {
                PrivilegeManager.enablePrivilege("UniversalFileAccess");
            }
            catch (ForbiddenTargetException forbiddenTargetException) {
                // empty catch block
            }
        }
        if ((fileOutputStream = this.chooseFileDialog("Select file to capture to")) != null) {
            this.termCapture = new TerminalCapture(fileOutputStream);
            this.termCapture.startCapture(this.term);
            return true;
        }
        return false;
    }

    public void endCapture() {
        if (this.termCapture != null) {
            this.termCapture.endCapture();
            try {
                this.termCapture.getTarget().close();
            }
            catch (IOException iOException) {
                AlertDialog.show(this.titleName + " - Alert", iOException.getMessage(), this.term.ownerFrame);
            }
        }
    }

    public void setEnabledOpt(int n, boolean bl) {
        ((CheckboxMenuItem)this.menuItems[3][n + 1]).setEnabled(bl);
    }

    public void setStateOpt(int n, boolean bl) {
        ((CheckboxMenuItem)this.menuItems[3][n + 1]).setState(bl);
    }

    public Menu getMenu(int n) {
        Menu menu = new Menu(menuTexts[n][0]);
        int n2 = menuTexts[n].length;
        if (this.menuItems == null) {
            this.menuItems = new Object[menuTexts.length][];
        }
        if (this.menuItems[n] == null) {
            this.menuItems[n] = new Object[menuTexts[n].length];
        }
        for (int i = 1; i < n2; ++i) {
            MenuItem menuItem;
            String string = menuTexts[n][i];
            if (string == null) {
                menu.addSeparator();
                continue;
            }
            if (string.charAt(0) == '_') {
                string = string.substring(1);
                menuItem = new CheckboxMenuItem(string);
                ((CheckboxMenuItem)menuItem).addItemListener(this);
            } else {
                menuItem = new MenuItem(string);
                menuItem.addActionListener(this);
            }
            if (menuShortCuts[n][i] != -1) {
                menuItem.setShortcut(new MenuShortcut(menuShortCuts[n][i], true));
            }
            this.menuItems[n][i] = menuItem;
            menu.add(menuItem);
        }
        return menu;
    }

    int[] mapAction(String string) {
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 0;
        block0: for (n = 0; n < menuTexts.length; ++n) {
            for (n2 = 1; n2 < menuTexts[n].length; ++n2) {
                String string2 = menuTexts[n][n2];
                if (string2 == null || !string.equals(string2)) continue;
                nArray[0] = n;
                nArray[1] = n2;
                n = menuTexts.length;
                continue block0;
            }
        }
        return nArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.mapAction(((MenuItem)actionEvent.getSource()).getLabel());
        this.handleMenuAction(nArray);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int[] nArray = this.mapAction("_" + (String)itemEvent.getItem());
        this.handleMenuAction(nArray);
    }

    public void handleMenuAction(int[] nArray) {
        switch (nArray[0]) {
            case 0: {
                switch (nArray[1]) {
                    case 1: {
                        if (((CheckboxMenuItem)this.menuItems[0][1]).getState()) {
                            if (this.captureToFileDialog()) break;
                            ((CheckboxMenuItem)this.menuItems[0][1]).setState(false);
                            break;
                        }
                        this.endCapture();
                        break;
                    }
                    case 2: {
                        ((TerminalMenuHandlerFull)this.term.getMenus()).sendFileDialog();
                        break;
                    }
                    case 4: {
                        if (this.listener == null) break;
                        this.listener.close(this);
                    }
                }
                break;
            }
            case 1: {
                switch (nArray[1]) {
                    case 1: {
                        this.term.doCopy();
                        break;
                    }
                    case 2: {
                        this.term.doPaste();
                        break;
                    }
                    case 3: {
                        this.term.doCopy();
                        this.term.doPaste();
                        break;
                    }
                    case 4: {
                        this.term.selectAll();
                        break;
                    }
                    case 5: {
                        this.findDialog();
                        break;
                    }
                    case 7: {
                        this.term.clearScreen();
                        this.term.cursorSetPos(0, 0, false);
                        break;
                    }
                    case 8: {
                        this.term.clearSaveLines();
                        break;
                    }
                    case 9: {
                        this.term.resetInterpreter();
                    }
                }
                break;
            }
            case 2: {
                switch (nArray[1]) {
                    case 1: {
                        this.termSettingsDialog();
                        break;
                    }
                    case 2: {
                        this.termSettingsDialog2();
                        break;
                    }
                    case 3: {
                        this.termColorsDialog();
                    }
                }
                break;
            }
            case 3: {
                int n = nArray[1] - 1;
                this.term.setProperty(TerminalDefProps.defaultPropDesc[n][0], String.valueOf(!this.term.termOptions[n]));
            }
        }
    }

    public void write(char c) {
        if (this.printerOut != null) {
            try {
                this.printerOut.write(c);
            }
            catch (IOException iOException) {
                AlertDialog.show(this.titleName + " - Alert", iOException.getMessage(), this.term.ownerFrame);
            }
        }
    }

    public void printScreen() {
    }

    public void startPrinter() {
        this.printerOut = this.chooseFileDialog("Passthrough print to file");
    }

    public void stopPrinter() {
        if (this.printerOut != null) {
            try {
                this.printerOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.printerOut = null;
            AlertDialog.show(this.titleName + " - Alert", "Passthrough printing ended, file saved.", this.term.ownerFrame);
        }
    }

    private class Actions
    implements ActionListener,
    ItemListener {
        private int action;

        public Actions(int n) {
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.action) {
                case 0: {
                    try {
                        TerminalMenuHandlerFull.this.term.setProperty("te", te[TerminalMenuHandlerFull.this.choiceTE.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("fn", fn[TerminalMenuHandlerFull.this.choiceFN.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("fs", TerminalMenuHandlerFull.this.textFS.getText());
                        TerminalMenuHandlerFull.this.term.setProperty("sb", sb[TerminalMenuHandlerFull.this.choiceSB.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("sl", TerminalMenuHandlerFull.this.textSL.getText());
                        TerminalMenuHandlerFull.this.term.setProperty("gm", TerminalMenuHandlerFull.this.textCols.getText() + "x" + TerminalMenuHandlerFull.this.textRows.getText());
                        ((Component)TerminalMenuHandlerFull.this.settingsDialog).setVisible(false);
                    }
                    catch (Exception exception) {
                        TerminalMenuHandlerFull.this.lblAlert.setText(exception.getMessage());
                    }
                    break;
                }
                case 1: {
                    try {
                        TerminalMenuHandlerFull.this.term.setProperty("fg", TerminalMenuHandlerFull.this.getSelectedColor(TerminalMenuHandlerFull.this.choiceFG, TerminalMenuHandlerFull.this.textFG));
                        TerminalMenuHandlerFull.this.term.setProperty("bg", TerminalMenuHandlerFull.this.getSelectedColor(TerminalMenuHandlerFull.this.choiceBG, TerminalMenuHandlerFull.this.textBG));
                        TerminalMenuHandlerFull.this.term.setProperty("cc", TerminalMenuHandlerFull.this.getSelectedColor(TerminalMenuHandlerFull.this.choiceCC, TerminalMenuHandlerFull.this.textCC));
                        ((Component)TerminalMenuHandlerFull.this.colorsDialog).setVisible(false);
                    }
                    catch (Exception exception) {
                        TerminalMenuHandlerFull.this.lblAlertC.setText(exception.getMessage());
                    }
                    break;
                }
                case 2: {
                    try {
                        TerminalMenuHandlerFull.this.term.setProperty("pb", pb[TerminalMenuHandlerFull.this.choicePB.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("rg", rg[TerminalMenuHandlerFull.this.choiceRG.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("sd", TerminalMenuHandlerFull.this.textSD.getText());
                        if (TerminalMenuHandlerFull.this.cbBS.getState()) {
                            TerminalMenuHandlerFull.this.term.setProperty("bs", "DEL");
                        } else {
                            TerminalMenuHandlerFull.this.term.setProperty("bs", "BS");
                        }
                        if (TerminalMenuHandlerFull.this.cbDEL.getState()) {
                            TerminalMenuHandlerFull.this.term.setProperty("de", "BS");
                        } else {
                            TerminalMenuHandlerFull.this.term.setProperty("de", "DEL");
                        }
                        TerminalMenuHandlerFull.this.term.setProperty("lp", String.valueOf(TerminalMenuHandlerFull.this.cbLocPG.getState()));
                        TerminalMenuHandlerFull.this.term.setProperty("sc", String.valueOf(TerminalMenuHandlerFull.this.cbCpWinCR.getState()));
                        TerminalMenuHandlerFull.this.term.setProperty("cs", String.valueOf(TerminalMenuHandlerFull.this.cbCpOnSel.getState()));
                        TerminalMenuHandlerFull.this.term.setProperty("ad", String.valueOf(TerminalMenuHandlerFull.this.cbAsciiLD.getState()));
                        ((Component)TerminalMenuHandlerFull.this.settingsDialog2).setVisible(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.out.println("Fatal error in dialog: " + exception);
                    }
                    break;
                }
                case 3: {
                    ((Component)TerminalMenuHandlerFull.this.findDialog).setVisible(false);
                    if (TerminalMenuHandlerFull.this.findLen > 0) {
                        TerminalMenuHandlerFull.this.term.clearSelection(TerminalMenuHandlerFull.this.curFindRow, TerminalMenuHandlerFull.this.curFindCol, TerminalMenuHandlerFull.this.curFindRow, TerminalMenuHandlerFull.this.curFindCol + TerminalMenuHandlerFull.this.findLen - 1);
                    }
                    TerminalMenuHandlerFull.this.curFindRow = 0;
                    TerminalMenuHandlerFull.this.curFindCol = 0;
                    TerminalMenuHandlerFull.this.findLen = 0;
                    break;
                }
                case 4: {
                    String string = TerminalMenuHandlerFull.this.findText.getText();
                    if (string == null || string.length() <= 0) break;
                    TerminalMenuHandlerFull.this.doFind();
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            TerminalMenuHandlerFull.this.updateColors();
        }
    }
}

