/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import com.mindbright.util.Base64;
import com.mindbright.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class ASCIIArmour {
    public static final int DEFAULT_LINE_LENGTH = 70;
    String EOL = "\r\n";
    String headerLine;
    Hashtable headerFields;
    Vector fieldsOrder;
    String tailLine;
    boolean blankHeaderSep;
    int lineLen;
    boolean haveChecksum;
    boolean unknownHeaderLines;
    String headerLinePrePostFix;

    public ASCIIArmour(String string, String string2, boolean bl, int n) {
        this.headerLine = string;
        this.tailLine = string2;
        this.blankHeaderSep = bl;
        this.lineLen = n;
        this.unknownHeaderLines = false;
        this.headerFields = new Hashtable();
        this.fieldsOrder = new Vector();
    }

    public ASCIIArmour(String string, String string2) {
        this(string, string2, false, 70);
    }

    public ASCIIArmour(String string) {
        this(string, string);
        this.unknownHeaderLines = true;
    }

    public void setCanonicalLineEnd(boolean bl) {
        this.EOL = bl ? "\r\n" : "\n";
    }

    public void setBlankHeaderSep(boolean bl) {
        this.blankHeaderSep = bl;
    }

    public void setLineLength(int n) {
        this.lineLen = n;
    }

    public String getHeaderLine() {
        return this.headerLine;
    }

    public void setHeaderLine(String string) {
        this.unknownHeaderLines = false;
        this.headerLine = string;
    }

    public void setTailLine(String string) {
        this.unknownHeaderLines = false;
        this.tailLine = string;
    }

    public Hashtable getHeaderFields() {
        return this.headerFields;
    }

    public String getHeaderField(String string) {
        return (String)this.headerFields.get(string);
    }

    public void setHeaderField(String string, String string2) {
        if (string2 != null) {
            this.headerFields.put(string, string2);
            this.fieldsOrder.addElement(string.intern());
        } else {
            this.headerFields.remove(string);
            this.fieldsOrder.removeElement(string.intern());
        }
    }

    public byte[] encode(byte[] byArray) {
        return this.encode(byArray, 0, byArray.length);
    }

    public byte[] encode(byte[] byArray, int n, int n2) {
        if (this.unknownHeaderLines) {
            return null;
        }
        int n3 = n2 / 3 * 4;
        StringBuffer stringBuffer = new StringBuffer(this.headerLine.length() + this.tailLine.length() + n3 + n3 / this.lineLen + 512);
        stringBuffer.append(this.headerLine);
        stringBuffer.append(this.EOL);
        int n4 = stringBuffer.length();
        stringBuffer.append(this.printHeaders());
        if (this.blankHeaderSep && n4 < stringBuffer.length()) {
            stringBuffer.append(this.EOL);
        }
        byte[] byArray2 = Base64.encode(byArray, n, n2);
        for (int i = 0; i < byArray2.length; i += this.lineLen) {
            int n5 = this.lineLen;
            if (i + n5 > byArray2.length) {
                n5 = byArray2.length - i;
            }
            String string = new String(byArray2, i, n5);
            stringBuffer.append(string);
            stringBuffer.append(this.EOL);
        }
        if (this.haveChecksum) {
            // empty if block
        }
        stringBuffer.append(this.tailLine);
        stringBuffer.append(this.EOL);
        return stringBuffer.toString().getBytes();
    }

    public void encode(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.encode(byArray, n, n2);
        outputStream.write(byArray2);
    }

    public void encode(OutputStream outputStream, byte[] byArray) throws IOException {
        this.encode(outputStream, byArray, 0, byArray.length);
    }

    public byte[] decode(byte[] byArray) {
        return this.decode(byArray, 0, byArray.length);
    }

    public byte[] decode(byte[] byArray, int n, int n2) {
        CharSequence charSequence;
        String string = new String(byArray, n, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        while (!bl && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith(this.headerLine)) continue;
            bl = true;
            if (!this.unknownHeaderLines) continue;
            this.headerLine = string2;
        }
        this.headerFields = new Hashtable();
        String string3 = null;
        while (!bl2 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string3 != null) {
                charSequence = (String)this.headerFields.get(string3);
                this.headerFields.put(string3, (String)charSequence + StringUtil.trimRight(string2));
                string3 = null;
                continue;
            }
            int n3 = string2.indexOf(58);
            if (n3 < 0) {
                bl2 = true;
                continue;
            }
            String string4 = string2.substring(0, n3).trim();
            String string5 = string2.substring(n3 + 1).trim();
            if (string5.length() > 0 && string5.charAt(0) == '\"' && string5.charAt(string5.length() - 1) == '\\') {
                string3 = string4;
                string5 = string5.substring(0, string5.length() - 1);
            }
            this.headerFields.put(string4, string5);
        }
        if (this.blankHeaderSep) {
            // empty if block
        }
        charSequence = new StringBuffer();
        while (!bl3) {
            if (string2.startsWith(this.tailLine)) {
                bl3 = true;
                if (!this.unknownHeaderLines) continue;
                this.tailLine = string2;
                continue;
            }
            ((StringBuffer)charSequence).append(string2);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                continue;
            }
            return null;
        }
        byArray = Base64.decode(((StringBuffer)charSequence).toString().getBytes());
        return byArray;
    }

    public byte[] decode(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < 2) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                throw new IOException("Premature EOF, corrupt ascii-armour");
            }
            if (n2 == 13) continue;
            if (n2 != 10) {
                stringBuffer.append((char)n2);
                continue;
            }
            String string = new String(stringBuffer);
            if (n == 0) {
                if (string.startsWith(this.headerLine)) {
                    stringBuffer2.append(string);
                    stringBuffer2.append(this.EOL);
                    ++n;
                }
            } else {
                stringBuffer2.append(string);
                stringBuffer2.append(this.EOL);
                if (string.startsWith(this.tailLine)) {
                    ++n;
                }
            }
            stringBuffer.setLength(0);
        }
        return this.decode(stringBuffer2.toString().getBytes());
    }

    public String printHeaders() {
        Enumeration enumeration = this.fieldsOrder.elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append(": ");
            String string2 = (String)this.headerFields.get(string);
            if (string2.length() > 0 && string2.charAt(0) == '\"' && string.length() + 2 + string2.length() > this.lineLen) {
                int n = this.lineLen - (string.length() + 2);
                stringBuffer.append(string2.substring(0, n));
                stringBuffer.append("\\");
                stringBuffer.append(this.EOL);
                string2 = string2.substring(n);
            }
            stringBuffer.append(string2);
            stringBuffer.append(this.EOL);
        }
        return stringBuffer.toString();
    }
}

