/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarLoader
extends ClassLoader {
    String jarName;
    String jarPath;
    ZipFile jarFile;

    public JarLoader(String string, String string2) throws IOException {
        this.jarName = string2;
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":;");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                this.jarFile = new ZipFile(stringTokenizer.nextToken() + "/" + string2);
                return;
            }
            catch (IOException iOException) {
            }
        }
        throw new IOException("Failed to locate '" + string2 + "' with jar-path: " + string);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        byte[] byArray = this.loadClassData(string.replace('.', '/') + ".class");
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        byte[] byArray;
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.findSystemClass(string);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null && (byArray = this.loadClassData(string.replace('.', '/') + ".class")) != null) {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private byte[] loadClassData(String string) throws ClassNotFoundException {
        ZipEntry zipEntry = this.jarFile.getEntry(string);
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            int n2 = (int)zipEntry.getSize();
            byte[] byArray = new byte[n2];
            bufferedInputStream = new BufferedInputStream(this.jarFile.getInputStream(zipEntry));
            int n3 = 0;
            while (n2 > 0 && (n = bufferedInputStream.read(byArray, n3, n2)) >= 0) {
                n2 -= n;
                n3 += n;
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Can't find " + string + " in " + this.jarName);
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

